/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.List;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.gui.OverlayConfigAccessor;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.VROverlayManager;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayFrameBuffer;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsGeneral;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsIdentity;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsMisc;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsScreenRegion;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.registry.VROverlayRegistry;
import me.phoenixra.visor.core.client.gui.registry.VROverlayTemplateRegistry;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenGeneral;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenIdentity;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenMisc;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenPose;
import me.phoenixra.visor.core.client.gui.screens.overlayoptions.OptionsScreenRegion;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.helpers.RenderGuiHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VROverlayManagerImpl
implements VROverlayManager {
    private final VROverlayRegistry overlaysRegistry = new VROverlayRegistry();
    private final VROverlayTemplateRegistry overlayTemplatesRegistry = new VROverlayTemplateRegistry();
    private VRKeyboardAccessor keyboardAccessor;
    private final List<VROverlay> preparedOverlays = new ArrayList<VROverlay>();

    public void tick() {
        for (VROverlay overlay : this.overlaysRegistry.getSortedElements()) {
            if (!overlay.isEnabled()) continue;
            overlay.m_86600_();
        }
    }

    public void prepareOverlaysAndCursor(float partialTicks) {
        this.preparedOverlays.clear();
        for (VROverlay overlay : this.overlaysRegistry.getSortedElements()) {
            RenderTarget target;
            if (!overlay.isVisible() || (target = overlay.getRenderTarget()) == null) continue;
            overlay.updatePose(partialTicks);
            if (!overlay.isInViewDistance()) continue;
            this.preparedOverlays.add(overlay);
        }
        ClientContext.cursorHandler.process();
    }

    public void renderOverlayTextures(ProfilerFiller profiler, GuiGraphics guiGraphics, float partialTicks) {
        if (this.preparedOverlays.isEmpty()) {
            return;
        }
        Matrix4f projection = new Matrix4f();
        int prevOverlayWidth = -1;
        int prevOverlayHeight = -1;
        RenderSystem.backupProjectionMatrix();
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, -11000.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (VROverlay overlay : this.preparedOverlays) {
            RenderTarget target = overlay.getRenderTarget();
            if (target == null) {
                throw new RuntimeException("Tried to render overlay quad with null renderTarget: " + overlay.getId());
            }
            profiler.m_6180_("VROverlay Texture: " + overlay.getId());
            if (overlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
                VisorClientImpl.MC.f_91042_ = target;
                target.m_83954_(Minecraft.f_91002_);
                target.m_83947_(true);
                if (prevOverlayWidth != overlayScreen.f_96543_ || prevOverlayHeight != overlayScreen.f_96544_) {
                    projection.setOrtho(0.0f, (float)overlayScreen.f_96543_, (float)overlayScreen.f_96544_, 0.0f, 1000.0f, 21000.0f);
                    RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.f_276633_);
                    prevOverlayWidth = overlayScreen.f_96543_;
                    prevOverlayHeight = overlayScreen.f_96544_;
                }
                overlayScreen.m_280264_(guiGraphics, overlayScreen.getMouseX(), overlayScreen.getMouseY(), partialTicks);
                guiGraphics.m_280262_();
            } else if (overlay instanceof VROverlayFrameBuffer) {
                VROverlayFrameBuffer overlayFrameBuffer = (VROverlayFrameBuffer)overlay;
                overlayFrameBuffer.render(partialTicks);
            } else {
                throw new RuntimeException("Tried to render overlay of unsupported abstract class: " + overlay.getId());
            }
            profiler.m_7238_();
            GLUtils.checkGLError("post VROverlay texture: " + overlay.getId());
        }
        RenderSystem.restoreProjectionMatrix();
        posestack.m_85849_();
    }

    public void renderOverlays(float partialTicks, PoseStack poseStack) {
        if (this.preparedOverlays.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderPoseHelper.applyDisplayOrientation(VRRenderState.getCurrentVRDisplay(), poseStack);
        ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$resetProjectionMatrix(partialTicks);
        GLUtils.checkGLError("before overlays");
        for (VROverlay overlay : this.preparedOverlays) {
            if (!overlay.isVisible()) continue;
            RenderTarget target = overlay.getRenderTarget();
            if (target == null) {
                throw new RuntimeException("Tried to render overlay quad with null renderTarget: " + overlay.getId());
            }
            RenderGuiHelper.renderOverlayQuad(overlay, poseStack, overlay.getPose().getPosition(), overlay.getPose().getRotation(), !overlay.supportsDepth(), overlay.supportsLight(), overlay.getPose().getScale());
            GLUtils.checkGLError("post VROverlay quad: " + overlay.getId());
        }
        poseStack.m_85849_();
    }

    @Override
    public VROverlay getOverlay(@NotNull String id) {
        return this.overlaysRegistry.getElement(id);
    }

    @Override
    @NotNull
    public OverlayConfigAccessor getOverlayConfigAccessor() {
        return ClientContext.settingsHandler.getOverlayConfigsAccessor();
    }

    @Override
    @NotNull
    public OptionsScreen<?> getOptionsScreenFor(@NotNull OverlayOptionGroup<?> category) {
        if (category instanceof OverlayOptionsMisc) {
            OverlayOptionsMisc type = (OverlayOptionsMisc)category;
            return new OptionsScreenMisc(type);
        }
        if (category instanceof OverlayOptionsPose) {
            OverlayOptionsPose type = (OverlayOptionsPose)category;
            return new OptionsScreenPose(type);
        }
        if (category instanceof OverlayOptionsIdentity) {
            OverlayOptionsIdentity type = (OverlayOptionsIdentity)category;
            return new OptionsScreenIdentity(type);
        }
        if (category instanceof OverlayOptionsGeneral) {
            OverlayOptionsGeneral type = (OverlayOptionsGeneral)category;
            return new OptionsScreenGeneral(type);
        }
        if (category instanceof OverlayOptionsScreenRegion) {
            OverlayOptionsScreenRegion type = (OverlayOptionsScreenRegion)category;
            return new OptionsScreenRegion(type);
        }
        return null;
    }

    public VROverlayRegistry getOverlaysRegistry() {
        return this.overlaysRegistry;
    }

    public VROverlayTemplateRegistry getOverlayTemplatesRegistry() {
        return this.overlayTemplatesRegistry;
    }

    @Override
    public VRKeyboardAccessor getKeyboardAccessor() {
        return this.keyboardAccessor;
    }

    public List<VROverlay> getPreparedOverlays() {
        return this.preparedOverlays;
    }

    @Override
    public void setKeyboardAccessor(VRKeyboardAccessor keyboardAccessor) {
        this.keyboardAccessor = keyboardAccessor;
    }
}

