/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin;

import com.mojang.blaze3d.platform.Window;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayCursorData;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayFrameBuffer;
import me.phoenixra.visor.api.client.input.InputHelper;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseElementImpl;
import me.phoenixra.visor.core.client.gui.VRGuiManagerImpl;
import me.phoenixra.visor.core.client.gui.VROverlayManagerImpl;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import me.phoenixra.visor.modified.client.WindowModified;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayGameScreen
extends VROverlayFrameBuffer {
    public static final String ID = "game_screen";
    private Vector3fc roomPosition = null;
    private Matrix4f roomRotation = null;
    private float overlayScale = 1.0f;

    public VROverlayGameScreen(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.LOW, null, 1.0f);
        this.setEnabled(true);
    }

    @Override
    public void onRender(float partialTicks) {
        this.renderTarget = ClientContext.renderer.guiTarget.getTarget();
    }

    @Override
    protected void onPreTick() {
        this.renderTarget = ClientContext.renderer.guiTarget.getTarget();
    }

    @Override
    protected boolean updateVisibility() {
        return VisorClientImpl.MC.f_91080_ != null;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    public void onScreenChanged(Screen previousGuiScreen, Screen newScreen, boolean releaseKeys) {
        if (releaseKeys) {
            // empty if block
        }
        VROverlayManagerImpl overlayManager = ClientContext.overlayManager;
        VRKeyboardAccessor keyboardAccessor = overlayManager.getKeyboardAccessor();
        if (newScreen == null) {
            this.resetOrient();
            Screen attachedTo = keyboardAccessor.getAttachedTo();
            if (attachedTo != null && attachedTo == previousGuiScreen) {
                keyboardAccessor.setVisible(false);
            }
        } else if (newScreen instanceof ChatScreen && (!keyboardAccessor.isVisible() || keyboardAccessor.getAttachedTo() != null)) {
            keyboardAccessor.showKeyboard(newScreen);
        }
        this.orient(previousGuiScreen, newScreen);
    }

    private void orient(Screen previousGuiScreen, Screen newScreen) {
        boolean mainMenu;
        boolean bl = mainMenu = VisorClientImpl.MC.f_91063_ == null || this.willBeInMenuRoom(newScreen);
        if (mainMenu) {
            this.orientMainMenu();
            return;
        }
        this.overlayScale = 1.0f;
        if (previousGuiScreen == null && newScreen != null || newScreen instanceof ChatScreen || newScreen instanceof BookEditScreen || newScreen instanceof AbstractSignEditScreen || this.roomPosition == null || this.roomRotation == null) {
            PoseElementImpl hmd = ClientContext.player.getPoseData(PoseDataType.ROOM).getHmd();
            Vector3f forwardVec = new Vector3f(0.0f, 0.0f, -2.0f);
            if (newScreen instanceof ChatScreen) {
                forwardVec = new Vector3f(0.0f, 0.5f, -2.0f);
            } else if (newScreen instanceof BookEditScreen || newScreen instanceof AbstractSignEditScreen) {
                forwardVec = new Vector3f(0.0f, 0.25f, -2.0f);
            }
            Vector3fc hmdPos = hmd.getPosition();
            Vector3f offset = hmd.getCustomVector((Vector3fc)forwardVec);
            this.roomPosition = new Vector3f(offset.x / 2.0f + hmdPos.x(), offset.y / 2.0f + hmdPos.y(), offset.z / 2.0f + hmdPos.z());
            Vector3f look = new Vector3f(this.roomPosition.x() - hmdPos.x(), this.roomPosition.y() - hmdPos.y(), this.roomPosition.z() - hmdPos.z());
            float yaw = (float)(Math.PI + Mth.m_14136_((double)look.x, (double)look.z));
            float pitch = (float)Math.asin(look.y / look.length());
            this.roomRotation = new Matrix4f().rotationY(yaw).mul((Matrix4fc)new Matrix4f().rotationX(pitch));
        }
        ClientContext.overlayManager.getKeyboardAccessor().resetPose();
    }

    private void orientMainMenu() {
        ClientContext.player.setRotationY(0.0f);
        this.overlayScale = 2.0f;
        Vector2f afloat = ClientUtils.getPlayAreaSize();
        this.roomPosition = new Vector3f(0.02f, 1.3f, -Math.max(afloat.y / 2.0f, 1.5f));
        this.roomRotation = new Matrix4f();
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        if (this.roomPosition == null || this.roomRotation == null) {
            this.orient(null, VisorClientImpl.MC.f_91080_);
        }
        VROverlayHelper.applyRoomPose(this, this.overlayScale, this.roomPosition, this.roomRotation);
    }

    @Override
    public void updateCursorData(boolean activeCursor, float rawX, float rawY) {
        if (!this.isEnabled()) {
            return;
        }
        if (!activeCursor) {
            return;
        }
        if (rawX < 0.0f || rawX > 1.0f || rawY < 0.0f || rawY > 1.0f) {
            return;
        }
        Window mcWindow = VisorClientImpl.MC.m_91268_();
        VRGuiManagerImpl guiManager = ClientContext.guiManager;
        int screenWidth = ((WindowModified)mcWindow).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)mcWindow).visor$getActualScreenHeight();
        int guiScaledWidth = guiManager.getGuiScaledWidth();
        int guiScaledHeight = guiManager.getGuiScaledHeight();
        VROverlayCursorData cursorData = this.activeCursorData;
        cursorData.setRawCursorX(rawX);
        cursorData.setRawCursorY(rawY);
        cursorData.setCursorX((int)((double)rawX * (double)guiScaledWidth));
        cursorData.setCursorY((int)((double)rawY * (double)guiScaledHeight));
        InputHelper.setMousePos((int)((double)rawX * (double)screenWidth), (int)((double)rawY * (double)screenHeight));
    }

    public void resetOrient() {
        this.roomPosition = null;
        this.roomRotation = null;
        this.overlayScale = 1.0f;
    }

    public boolean willBeInMenuRoom(Screen newScreen) {
        return VisorClientImpl.MC.f_91073_ == null || newScreen instanceof WinScreen || newScreen instanceof ReceivingLevelScreen || newScreen instanceof ProgressScreen || newScreen instanceof GenericDirtMessageScreen || VisorClientImpl.MC.m_91265_() != null;
    }

    @Override
    public boolean m_6375_(double x, double y, int buttonType) {
        InputHelper.pressMouse(buttonType);
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonType) {
        InputHelper.releaseMouse(buttonType);
        return true;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (VisorClientImpl.MC.f_91080_ != null) {
            return VisorClientImpl.MC.f_91080_.m_6050_(mouseX, mouseY, scrollDelta);
        }
        return false;
    }

    @Override
    public boolean supportsCursor() {
        return true;
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.m_237115_((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"visor.overlay.%s.description".formatted(this.getId()));
    }
}

