/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.hotbar;

import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.atumvr.api.utils.MathUtils;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.events.AllowClientFeatureVREvent;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.screen.VROverlayRadialSelector;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.eventbus.listener.VREventHandler;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.gui.overlays.builtin.hotbar.HotBarSlice;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.core.client.tasks.TaskHotBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayHotBar
extends VROverlayRadialSelector
implements VREventListener {
    public static final String ID_MAIN = "hotbar_mainhand";
    public static final String ID_OFFHAND = "hotbar_offhand";
    private GuiTexture hotbarSelectedMain0Tex = new GuiTexture(new ResourceLocation("visor", "textures/gui/overlays/hotbar/hotbar_main_selected0.png"));
    private GuiTexture hotbarSelectedMain1Tex = new GuiTexture(new ResourceLocation("visor", "textures/gui/overlays/hotbar/hotbar_main_selected1.png"));
    private GuiTexture hotbarSelectedOffhand0Tex = new GuiTexture(new ResourceLocation("visor", "textures/gui/overlays/hotbar/hotbar_offhand_selected0.png"));
    private GuiTexture hotbarSelectedOffhand1Tex = new GuiTexture(new ResourceLocation("visor", "textures/gui/overlays/hotbar/hotbar_offhand_selected1.png"));
    private final Vector3f orientPosOffset = new Vector3f(0.0f, 0.0f, -0.6f);
    private final Vector3f orientRotationOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f orientPosOffsetRender;

    public VROverlayHotBar(@NotNull VisorAddon owner, @NotNull ControllerHand hand, @NotNull String id) {
        super(owner, hand, id, hand == ControllerHand.MAIN ? ElementPriority.HIGH : ElementPriority.NORMAL, 98, new SelectionBoxHotBar(HotBarSlice.CENTER.getSlot(), 41, 41, new PairRecord<Double, Double>(0.0, 0.0)), new SelectionBoxHotBar(HotBarSlice.TOP_LEFT.getSlot(), 5, 5, new PairRecord<Double, Double>(-2.748893571891069, -1.9634954084936207)), new SelectionBoxHotBar(HotBarSlice.TOP.getSlot(), 41, 5, new PairRecord<Double, Double>(-1.9634954084936207, -1.1780972450961724)), new SelectionBoxHotBar(HotBarSlice.TOP_RIGHT.getSlot(), 77, 5, new PairRecord<Double, Double>(-1.1780972450961724, -0.39269908169872414)), new SelectionBoxHotBar(HotBarSlice.RIGHT.getSlot(), 77, 41, new PairRecord<Double, Double>(-0.39269908169872414, 0.39269908169872414)), new SelectionBoxHotBar(HotBarSlice.BOTTOM_RIGHT.getSlot(), 77, 77, new PairRecord<Double, Double>(0.39269908169872414, 1.1780972450961724)), new SelectionBoxHotBar(HotBarSlice.BOTTOM.getSlot(), 41, 77, new PairRecord<Double, Double>(1.1780972450961724, 1.9634954084936207)), new SelectionBoxHotBar(HotBarSlice.BOTTOM_LEFT.getSlot(), 5, 77, new PairRecord<Double, Double>(1.9634954084936207, 2.748893571891069)), new SelectionBoxHotBar(HotBarSlice.LEFT.getSlot(), 5, 41, new PairRecord<Double, Double>(-1.0, -1.0)));
        VisorAPI.eventBus().registerListener(owner, this);
    }

    @VREventHandler
    public void disableAimEffectsAndMouse(AllowClientFeatureVREvent event) {
        if ((event.getFeature() == ClientFeature.AIM_EFFECTS || event.getFeature() == ClientFeature.INPUT_MOUSE || event.getFeature() == ClientFeature.GUI_CURSOR) && this.isVisible() && ClientContext.player.getActiveHand() == this.getUsedHand()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onRender(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        VROverlayHotBar hotBarOffhand = (VROverlayHotBar)ClientContext.overlayManager.getOverlay(ID_OFFHAND);
        VROverlayHotBar hotBarMainHand = (VROverlayHotBar)ClientContext.overlayManager.getOverlay(ID_MAIN);
        if (hotBarOffhand == this && hotBarMainHand.isEnabled() && hotBarMainHand.getSelectedSlice() == 0 && hotBarOffhand.getSelectedSlice() == 0) {
            hotBarOffhand.setSelectedSlice(1);
        }
        if (hotBarMainHand == this) {
            hotBarOffhand.getDisabledBoxes().clear();
            if (hotBarMainHand.getSelectedSlice() != -1) {
                hotBarOffhand.getDisabledBoxes().add(hotBarMainHand.getSelectedSlice());
            }
            if (!hotBarOffhand.isEnabled()) {
                this.disabledBoxes.clear();
            }
        } else {
            hotBarMainHand.getDisabledBoxes().clear();
            if (hotBarOffhand.getSelectedSlice() != -1) {
                hotBarMainHand.getDisabledBoxes().add(hotBarOffhand.getSelectedSlice());
            }
            if (!hotBarMainHand.isEnabled()) {
                this.disabledBoxes.clear();
            }
        }
        super.onRender(guiGraphics, pMouseX, pMouseY, pPartialTicks);
    }

    @Override
    protected void renderRadialImage(GuiGraphics guiGraphics, float pPartialTicks, int selectedSlice, int x, int y, int size) {
        HotBarSlice.fromSlot(selectedSlice).getBackground().blit(guiGraphics, x, y, size, size);
        Inventory inventory = Minecraft.m_91087_().f_91074_.m_150109_();
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack itemStack = inventory.m_8020_(slot);
            if (itemStack.m_41619_()) continue;
            VROverlayRadialSelector.SelectionBox selectionBox = (VROverlayRadialSelector.SelectionBox)this.selectionBoxes.get(slot);
            int itemX = ((SelectionBoxHotBar)selectionBox).getItemX();
            int itemY = ((SelectionBoxHotBar)selectionBox).getItemY();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280480_(itemStack, x + itemX, y + itemY);
            guiGraphics.m_280302_(this.f_96547_, itemStack, x + itemX, y + itemY, null);
            guiGraphics.m_280168_().m_85849_();
        }
        HotBarSlice slice = TaskHotBar.getCurrentStateMain();
        if (slice == HotBarSlice.NOT_SELECTED) {
            return;
        }
        SelectionBoxHotBar selectionBox = (SelectionBoxHotBar)this.selectionBoxes.get(slice.slot);
        int itemX = selectionBox.getItemX();
        int itemY = selectionBox.getItemY();
        if (slice.slot != 0) {
            this.hotbarSelectedMain0Tex.blit(guiGraphics, x + itemX - 5, y + itemY - 5, 26, 26);
        } else {
            this.hotbarSelectedMain1Tex.blit(guiGraphics, x + itemX - 5, y + itemY - 5, 26, 26);
        }
        slice = TaskHotBar.getCurrentStateOffhand();
        if (slice == HotBarSlice.NOT_SELECTED) {
            return;
        }
        selectionBox = (SelectionBoxHotBar)this.selectionBoxes.get(slice.slot);
        itemX = selectionBox.getItemX();
        itemY = selectionBox.getItemY();
        if (slice.slot != 0) {
            this.hotbarSelectedOffhand0Tex.blit(guiGraphics, x + itemX - 5, y + itemY - 5, 26, 26);
        } else {
            this.hotbarSelectedOffhand1Tex.blit(guiGraphics, x + itemX - 5, y + itemY - 5, 26, 26);
        }
    }

    @Override
    protected void onTick() {
    }

    @Override
    public boolean updateVisibility() {
        return true;
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        Vector3fc camPos = RenderPoseHelper.getCameraPosition(VRDisplay.GUI, ClientContext.player.getPoseData(PoseDataType.RENDER));
        this.getPose().updateOnlyPosition((Vector3fc)new Vector3f(camPos.x() + this.orientPosOffsetRender.x, camPos.y() + this.orientPosOffsetRender.y, camPos.z() + this.orientPosOffsetRender.z));
    }

    @Override
    public void onEnable() {
        PoseAnchor posAnchor = this.getUsedHand() == ControllerHand.OFFHAND ? PoseAnchor.OFFHAND : PoseAnchor.MAIN_HAND;
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        VROverlayHelper.applyPose(this, posAnchor, PoseAnchor.HMD, this.getPose().getScale(), true, (Vector3fc)this.orientPosOffset, (Vector3fc)this.orientRotationOffset);
        this.orientPosOffsetRender = this.getPose().getPosition().sub(renderPose.getHmd().getPosition(), new Vector3f());
        this.disabledBoxes.clear();
    }

    @Override
    public void onDisable() {
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.m_237115_((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"visor.overlay.%s.description".formatted(this.getId()));
    }

    private static class SelectionBoxHotBar
    extends VROverlayRadialSelector.SelectionBox {
        private final PairRecord<Double, Double> selectionAngle;
        private final int itemX;
        private final int itemY;

        public SelectionBoxHotBar(int id, int itemX, int itemY, @NotNull PairRecord<Double, Double> selectionAngle) {
            super(id);
            this.selectionAngle = selectionAngle;
            this.itemX = itemX;
            this.itemY = itemY;
        }

        @Override
        public boolean isInBox(int x, int y) {
            if (this.getId() == HotBarSlice.LEFT.getSlot()) {
                double angle = MathUtils.fastAtan2(y, x);
                return angle <= Math.PI && angle >= 2.748893571891069 || angle >= -Math.PI && angle <= -2.748893571891069;
            }
            if (this.getId() == HotBarSlice.CENTER.getSlot()) {
                return Math.sqrt(x * x + y * y) <= 20.0;
            }
            double angle = MathUtils.fastAtan2(y, x);
            return angle >= this.selectionAngle.first() && angle <= this.selectionAngle.second();
        }

        public PairRecord<Double, Double> getSelectionAngle() {
            return this.selectionAngle;
        }

        public int getItemX() {
            return this.itemX;
        }

        public int getItemY() {
            return this.itemY;
        }
    }
}

