/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.keyboard;

import me.phoenixra.visor.core.client.gui.overlays.builtin.keyboard.VROverlayKeyboard;
import me.phoenixra.visor.core.client.gui.screens.VRKeyboardScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class KeyboardButton
extends Button {
    private VRKeyboardScreen keyboardScreen;
    private final OnRelease onRelease;
    private boolean pressed;
    private boolean usePressTask = true;
    private boolean hoveredSecondary;

    protected KeyboardButton(VRKeyboardScreen keyboardScreen, int x, int y, int width, int height, Component component, Button.OnPress onPress, OnRelease onRelease, Button.CreateNarration createNarration) {
        super(x, y, width, height, component, onPress, createNarration);
        this.keyboardScreen = keyboardScreen;
        this.onRelease = onRelease;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        VROverlayKeyboard overlayKeyboard = this.keyboardScreen.getOverlayKeyboard();
        if (overlayKeyboard.getInactiveCursorData().isInGui()) {
            int mX = overlayKeyboard.getInactiveCursorData().getCursorX();
            int mY = overlayKeyboard.getInactiveCursorData().getCursorY();
            this.hoveredSecondary = mX >= this.m_252754_() && mY >= this.m_252907_() && mX < this.m_252754_() + this.f_93618_ && mY < this.m_252907_() + this.f_93619_;
        } else {
            this.hoveredSecondary = false;
        }
        super.m_87963_(guiGraphics, i, j, f);
    }

    public void m_5691_() {
        if (this.usePressTask) {
            this.keyboardScreen.setPressedTask(() -> super.m_5691_());
            this.keyboardScreen.setPressTick(0);
        }
        super.m_5691_();
        this.pressed = true;
    }

    public void m_7691_(double d, double e) {
        if (this.onRelease != null && this.pressed) {
            this.onRelease.onRelease(this);
        }
        this.pressed = false;
    }

    public boolean m_274382_() {
        return super.m_274382_() || this.hoveredSecondary;
    }

    public static interface OnRelease {
        public void onRelease(Button var1);
    }

    public static class Builder {
        private VRKeyboardScreen keyboardScreen;
        private final Component message;
        private final Button.OnPress onPress;
        private OnRelease onRelease;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private boolean usePressTask = true;

        public Builder(VRKeyboardScreen keyboardScreen, Component component, Button.OnPress onPress) {
            this.keyboardScreen = keyboardScreen;
            this.message = component;
            this.onPress = onPress;
        }

        public Builder usePressTask(boolean flag) {
            this.usePressTask = flag;
            return this;
        }

        public Builder onRelease(OnRelease onRelease) {
            this.onRelease = onRelease;
            return this;
        }

        public Builder pos(int i, int j) {
            this.x = i;
            this.y = j;
            return this;
        }

        public Builder width(int i) {
            this.width = i;
            return this;
        }

        public Builder size(int i, int j) {
            this.width = i;
            this.height = j;
            return this;
        }

        public KeyboardButton build() {
            KeyboardButton button = new KeyboardButton(this.keyboardScreen, this.x, this.y, this.width, this.height, this.message, this.onPress, this.onRelease, f_252438_);
            button.usePressTask = this.usePressTask;
            return button;
        }
    }
}

