/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.keyboard;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.events.AllowClientFeatureVREvent;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.screen.VROverlayScreenInScreen;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.eventbus.listener.VREventHandler;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.screens.VRKeyboardScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayKeyboard
extends VROverlayScreenInScreen<VRKeyboardScreen>
implements VRKeyboardAccessor,
VREventListener {
    public static final String ID = "keyboard";
    private final Vector3f posOffset = new Vector3f(0.0f, -0.5f, -0.6f);
    private final Vector3f rotationOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3fc roomPosition = null;
    private Matrix4f roomRotation = null;
    private boolean shiftPressed = false;
    @Nullable
    private Screen attachedTo;
    private boolean shown;

    public VROverlayKeyboard(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.HIGHER, 0.5f, new VRKeyboardScreen((Component)Component.m_237113_((String)"")));
        ((VRKeyboardScreen)((Object)this.getScreen())).setOverlayKeyboard(this);
        this.setEnabled(true);
        ClientContext.overlayManager.setKeyboardAccessor(this);
        VisorAPI.eventBus().registerListener(owner, this);
    }

    @VREventHandler
    public void disableWorldHands(AllowClientFeatureVREvent event) {
        if ((event.getFeature() == ClientFeature.VR_WORLD_HANDS || event.getFeature() == ClientFeature.AIM_EFFECTS || event.getFeature() == ClientFeature.INPUT_MOVEMENT) && this.isVisible()) {
            event.setCanceled(true);
        }
    }

    @Override
    protected void onPreRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (ClientContext.cursorHandler.getFocusedOverlayScreen() != this) {
            ((VRKeyboardScreen)((Object)this.getScreen())).clearPress();
        }
    }

    @Override
    public void resetPose() {
        VROverlayHelper.applyPose(this, PoseAnchor.HMD, PoseAnchor.HMD, this.getPose().getScale(), true, (Vector3fc)this.posOffset, (Vector3fc)this.rotationOffset);
        this.roomPosition = ClientContext.player.getPoseData(PoseDataType.ROOM).convertPositionFrom(PoseDataType.RENDER, this.getPose().getPosition());
        this.roomRotation = ClientContext.player.getPoseData(PoseDataType.ROOM).convertRotationFrom(PoseDataType.RENDER, this.getPose().getRotation());
    }

    @Override
    public void setVisible(boolean flag) {
        this.setVisible(flag, null);
    }

    @Override
    public void showKeyboard(@NotNull Screen attachTo) {
        this.setVisible(true, attachTo);
    }

    @Override
    public boolean updateVisibility() {
        return this.shown;
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        VROverlayHelper.applyRoomPose(this, this.getPose().getScale(), this.roomPosition, this.roomRotation);
    }

    @Override
    public boolean supportsTwoCursors() {
        return true;
    }

    public void setVisible(boolean flag, @Nullable Screen attachedTo) {
        this.shown = flag;
        if (this.shown) {
            this.orient(attachedTo);
            this.shiftPressed = false;
            this.initAgain = true;
        } else {
            ((VRKeyboardScreen)((Object)this.getScreen())).clearPress();
            this.attachedTo = null;
        }
    }

    public void setShiftPressed(boolean shift) {
        if (shift != this.shiftPressed) {
            this.shiftPressed = shift;
            this.initAgain = true;
        }
    }

    private void orient(@Nullable Screen attachedTo) {
        if (!this.shown) {
            this.attachedTo = null;
            return;
        }
        this.attachedTo = attachedTo;
        VROverlayHelper.applyPose(this, PoseAnchor.HMD, PoseAnchor.HMD, this.getPose().getScale(), true, (Vector3fc)this.posOffset, (Vector3fc)this.rotationOffset);
        this.roomPosition = ClientContext.player.getPoseData(PoseDataType.ROOM).convertPositionFrom(PoseDataType.RENDER, this.getPose().getPosition());
        this.roomRotation = ClientContext.player.getPoseData(PoseDataType.ROOM).convertRotationFrom(PoseDataType.RENDER, this.getPose().getRotation());
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.m_237115_((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"visor.overlay.%s.description".formatted(this.getId()));
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    @Override
    @Nullable
    public Screen getAttachedTo() {
        return this.attachedTo;
    }

    public boolean isShown() {
        return this.shown;
    }
}

