/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings;

import com.mojang.blaze3d.pipeline.RenderTarget;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsMisc;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayDemo
extends VROverlayScreen {
    public static final String ID = "demo";
    private static final int EDGE_LINE_SIZE = 2;
    private final Vector3f movingPosOffset = new Vector3f(0.0f, 0.0f, -0.3f);
    private final Vector3f movingRotationOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private VROverlay target;
    private OverlayOptionsPose targetPoseOptions;
    private OverlayOptionsMisc targetOptionsGlobal;
    private boolean appliedPose;
    private boolean emulatingPose;
    @Nullable
    private PoseAnchor movingByAnchor;
    private float overlayScale = 1.0f;

    public VROverlayDemo(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.HIGHEST, 1.0f);
    }

    @Override
    protected void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int startX = 0;
        int startY = 0;
        int width = this.f_96543_;
        int height = this.f_96544_;
        this.renderOutline(guiGraphics, startX, startY, width, height, AtumColor.RED.toInt());
        startX = this.cursorBoundsX;
        startY = this.cursorBoundsY;
        width = this.cursorBoundsWidth;
        height = this.cursorBoundsHeight;
        if (startX == -1 || startY == -1 || width == -1 || height == -1) {
            return;
        }
        if (startX == 0 && startY == 0 && width == this.f_96543_ && height == this.f_96544_) {
            return;
        }
        this.renderOutline(guiGraphics, startX, startY, width, height, AtumColor.GREEN.toInt());
    }

    @Override
    protected void onTick() {
        if (this.target == null) {
            return;
        }
        VROverlay vROverlay = this.target;
        if (vROverlay instanceof VROverlayScreen) {
            VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
            this.cursorBoundsX = overlayScreen.getCursorBoundsX();
            this.cursorBoundsY = overlayScreen.getCursorBoundsY();
            this.cursorBoundsWidth = overlayScreen.getCursorBoundsWidth();
            this.cursorBoundsHeight = overlayScreen.getCursorBoundsHeight();
        } else {
            this.cursorBoundsX = -1;
            this.cursorBoundsY = -1;
            this.cursorBoundsWidth = -1;
            this.cursorBoundsHeight = -1;
        }
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        if (!this.target.isVisible() && this.targetOptionsGlobal != null && this.targetOptionsGlobal.getOptionsUpdaterType() == OverlayOptionsMisc.OptionsUpdaterType.FRAME) {
            this.target.getOptions().forEach(it -> it.update(false));
        }
        this.overlayScale = this.targetPoseOptions.getScale();
        if (this.movingByAnchor != null) {
            VROverlayHelper.applyPose(this, this.movingByAnchor, this.movingByAnchor, this.overlayScale, false, (Vector3fc)this.movingPosOffset, (Vector3fc)this.movingRotationOffset);
        } else if (this.targetPoseOptions.isTickPose()) {
            if (!this.emulatingPose) {
                return;
            }
            VROverlayHelper.applyPose(this, this.targetPoseOptions.getPositionAnchor(), this.targetPoseOptions.getRotationAnchor(), this.targetPoseOptions.getScale(), this.targetPoseOptions.isAimedRotation(), (Vector3fc)this.targetPoseOptions.getPositionOffset(), (Vector3fc)this.targetPoseOptions.getRotationOffset());
        } else if (!this.appliedPose) {
            VROverlayHelper.applyPose(this, this.targetPoseOptions.getPositionAnchor(), this.targetPoseOptions.getRotationAnchor(), this.targetPoseOptions.getScale(), this.targetPoseOptions.isAimedRotation(), (Vector3fc)this.targetPoseOptions.getPositionOffset(), (Vector3fc)this.targetPoseOptions.getRotationOffset());
            this.appliedPose = true;
        }
    }

    @Override
    public void onDisable() {
        this.target = null;
        this.targetPoseOptions = null;
        this.appliedPose = false;
    }

    public void showDemo(@NotNull VROverlay overlay) {
        this.setEnabled(false);
        this.target = overlay;
        this.targetPoseOptions = this.target.getOption("pose", OverlayOptionsPose.class);
        this.targetOptionsGlobal = this.target.getOption("misc", OverlayOptionsMisc.class);
        this.overlayScale = this.target.getPose().getScale();
        this.setEnabled(this.targetPoseOptions != null);
    }

    public void teleportToHMD() {
        if (!this.isEnabled()) {
            return;
        }
        VROverlayHelper.applyPose(this, PoseAnchor.HMD, PoseAnchor.HMD, this.overlayScale, true, (Vector3fc)new Vector3f(0.0f, -0.5f, -0.6f), (Vector3fc)new Vector3f());
        this.appliedPose = true;
    }

    public void startMovingByAnchor() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.movingByAnchor != null) {
            return;
        }
        PoseAnchor posAnchor = this.targetPoseOptions.getPositionAnchor();
        this.emulatingPose = false;
        this.movingByAnchor = posAnchor == PoseAnchor.MAIN_HAND ? PoseAnchor.OFFHAND : PoseAnchor.MAIN_HAND;
        this.target.setForcedAnchor(this.movingByAnchor);
        ClientContext.cursorHandler.setCursorHand(this.movingByAnchor == PoseAnchor.OFFHAND ? ControllerHand.OFFHAND : ControllerHand.MAIN);
    }

    public void stopMovingByAnchor() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.movingByAnchor == null) {
            return;
        }
        this.applyNewOffset();
        this.movingByAnchor = null;
        this.target.setForcedAnchor(null);
    }

    public void applyNewOffset() {
        if (!this.isEnabled()) {
            return;
        }
        this.emulatingPose = true;
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        PoseAnchor posAnchor = this.targetPoseOptions.getPositionAnchor();
        PoseElement elementAnchorPos = posAnchor.getSupplier().apply(renderPose);
        Vector3fc anchorPosition = elementAnchorPos.getPosition();
        Vector3f offsetPos = elementAnchorPos.reverseCustomVector((Vector3fc)this.getPose().getPosition().sub(anchorPosition, new Vector3f())).div(renderPose.getWorldScale());
        this.targetPoseOptions.setPositionOffset(offsetPos);
        if (this.targetPoseOptions.isAimedRotation()) {
            this.targetPoseOptions.setRotationOffset(0.0f, 0.0f, 0.0f);
            this.targetPoseOptions.update(true);
            return;
        }
        PoseAnchor rotationAnchor = this.targetPoseOptions.getRotationAnchor();
        PoseElement elementAnchorRot = rotationAnchor.getSupplier().apply(renderPose);
        Matrix4fc anchorRotation = elementAnchorRot.getRotation();
        Vector3f rotationOffset = rotationAnchor.reverseAnchoredRotation(anchorRotation, this.getPose().getRotation());
        this.targetPoseOptions.setRotationOffset(rotationOffset);
        this.targetPoseOptions.update(true);
    }

    private void renderOutline(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        int endX = x + width;
        int endY = y + height;
        guiGraphics.m_280509_(x, y, endX, y + 2, color);
        guiGraphics.m_280509_(x, endY - 2, endX, endY, color);
        guiGraphics.m_280509_(x, y + 2, x + 2, endY - 2, color);
        guiGraphics.m_280509_(endX - 2, y + 2, endX, endY - 2, color);
    }

    public boolean isMovingByAnchor() {
        return this.movingByAnchor != null;
    }

    @Override
    public boolean supportsCursor() {
        return this.movingByAnchor != null;
    }

    @Override
    public boolean updateVisibility() {
        return true;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonType) {
        if (this.movingByAnchor == null) {
            return true;
        }
        this.stopMovingByAnchor();
        return true;
    }

    @Override
    public int getRequestedWidth() {
        if (this.target == null) {
            return super.getRequestedWidth();
        }
        RenderTarget renderTarget = this.target.getRenderTarget();
        if (renderTarget == null) {
            return super.getRequestedWidth();
        }
        return renderTarget.f_83915_;
    }

    @Override
    public int getRequestedHeight() {
        if (this.target == null) {
            return super.getRequestedHeight();
        }
        RenderTarget renderTarget = this.target.getRenderTarget();
        if (renderTarget == null) {
            return super.getRequestedHeight();
        }
        return renderTarget.f_83916_;
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.m_237115_((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"visor.overlay.%s.description".formatted(this.getId()));
    }

    public boolean isEmulatingPose() {
        return this.emulatingPose;
    }

    public void setEmulatingPose(boolean emulatingPose) {
        this.emulatingPose = emulatingPose;
    }

    @Nullable
    public PoseAnchor getMovingByAnchor() {
        return this.movingByAnchor;
    }
}

