/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings;

import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.lists.TexturedSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.sets.FilterListBinaryWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.SearchableListWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.WidgetSet;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.api.common.eventbus.listener.VREventListener;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.SettingsTextures;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlayDemo;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlayOptionsMenu;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.CreateOverlayWidgetSet;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.OverlaysWidgetSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlaySettings
extends VROverlayScreen
implements VREventListener {
    public static final String ID = "settings";
    public static final AtumColor TEXT_COLOR = AtumColor.WHITE.blend(AtumColor.BLACK, 0.2f);
    public static final Component TEXT_FIND = Component.m_237115_((String)"visor.overlay.options.find");
    private static final ResourceLocation BACKGROUND_OVERLAYS = new ResourceLocation("visor:textures/gui/overlays/settings/bg_main_1.png");
    private static final ResourceLocation BACKGROUND_CREATE = new ResourceLocation("visor:textures/gui/overlays/settings/bg_main_2.png");
    private static final ResourceLocation BACKGROUND_EXTRA = new ResourceLocation("visor:textures/gui/overlays/settings/bg_main_extra_1.png");
    private static final ResourceLocation BACKGROUND_EXTRA_EXTENDED = new ResourceLocation("visor:textures/gui/overlays/settings/bg_main_extra_2.png");
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final Component TITLE_CREATE_OVERLAY = Component.m_237115_((String)"visor.overlay.options.main.create_overlay");
    private static final Component TITLE_OVERLAYS = Component.m_237115_((String)"visor.overlay.options.main.overlays");
    private final Vector3f posOffset = new Vector3f(0.0f, 0.0f, -0.75f);
    private final Vector3f rotationOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3fc roomPosition = null;
    private Matrix4f roomRotation = null;
    private SettingsTab settingsTab = SettingsTab.OVERLAYS;
    private WidgetSet widgetSet;
    private boolean backgroundExtended = false;
    private int menuBoundsX;
    private int menuBoundsY;
    private int menuBoundsWidth;
    private int menuBoundsHeight;
    private int cursorBoundsOffsetX;
    private int cursorBoundsOffsetY;
    private int cursorBoundsOffsetWidth;
    private int cursorBoundsOffsetHeight;
    private ButtonImaged tabButton;
    private ButtonImaged closeButton;
    private ButtonImaged dragButton;
    private final OverlaysWidgetSet overlaysWidgetSet;
    private final CreateOverlayWidgetSet createOverlayWidgetSet;

    public VROverlaySettings(@NotNull VisorAddon owner, @NotNull String id) {
        super(owner, id, ElementPriority.NORMAL, 0.6f);
        VisorAPI.eventBus().registerListener(owner, this);
        this.overlaysWidgetSet = new OverlaysWidgetSet(this, this::repopulateWidgets);
        this.createOverlayWidgetSet = new CreateOverlayWidgetSet(this, this::repopulateWidgets);
    }

    protected void m_7856_() {
        this.m_169413_();
        this.setDragged(false);
        this.backgroundExtended = false;
        this.menuBoundsX = (this.f_96543_ - 256 + 10) / 2;
        this.menuBoundsY = (this.f_96544_ - 256) / 2;
        this.menuBoundsWidth = 266;
        this.menuBoundsHeight = 256;
        this.updateCursorEdges();
        GuiTexture tabTexture = this.settingsTab == SettingsTab.OVERLAYS ? SettingsTextures.BUTTON_TAB_RIGHT : SettingsTextures.BUTTON_TAB_LEFT;
        WidgetInfoButtonImaged tabInfo = new WidgetInfoButtonImaged().pos(this.menuBoundsX + (this.settingsTab == SettingsTab.OVERLAYS ? 115 : 0), this.menuBoundsY + 6).size(115, 23).setTexture(tabTexture).setTextColor(TEXT_COLOR).setText(this.settingsTab == SettingsTab.OVERLAYS ? TITLE_CREATE_OVERLAY : TITLE_OVERLAYS);
        this.tabButton = new ButtonImaged(tabInfo, it -> this.settingsTab.changeTab(this));
        this.m_142416_((GuiEventListener)this.tabButton);
        this.closeButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.menuBoundsX + 235, this.menuBoundsY + 12).size(19, 19).setTexture(SettingsTextures.BUTTON_CLOSE).setTextureHovered(SettingsTextures.BUTTON_CLOSE_HOVERED), it -> this.setEnabled(false));
        this.m_142416_((GuiEventListener)this.closeButton);
        this.dragButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.menuBoundsX + 235, this.menuBoundsY + 35).size(19, 19).setTexture(SettingsTextures.BUTTON_DRAG).setTextureHovered(SettingsTextures.BUTTON_DRAG_HOVERED).setTextureSelected(SettingsTextures.BUTTON_DRAG_SELECTED), it -> this.setDragged(true));
        this.m_142416_((GuiEventListener)this.dragButton);
        this.widgetSet = this.settingsTab.widgetSet(this);
        this.widgetSet.initWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
        VROverlayOptionsMenu optionsMenu = (VROverlayOptionsMenu)ClientContext.overlayManager.getOverlay("options_menu");
        assert (optionsMenu != null);
        optionsMenu.setEnabled(false);
    }

    @Override
    public void onPreRender(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partialTicks) {
        guiGraphics.m_280218_(this.settingsTab.background(), this.menuBoundsX, this.menuBoundsY, 0, 0, 256, 256);
        guiGraphics.m_280163_(this.settingsTab.backgroundExtra(this), this.menuBoundsX + 230, this.menuBoundsY + 6, 0.0f, 0.0f, this.backgroundExtended ? 128 : 27, 245, this.backgroundExtended ? 128 : 27, 245);
        Font font = Minecraft.m_91087_().f_91062_;
        Component text = this.settingsTab == SettingsTab.OVERLAYS ? TITLE_OVERLAYS : TITLE_CREATE_OVERLAY;
        GuiHelper.renderScalableText(guiGraphics, font, text.getString(), TEXT_COLOR.toInt(), this.menuBoundsX + (this.settingsTab == SettingsTab.OVERLAYS ? 0 : 115), this.menuBoundsY + 6, 115, 23, true);
        this.widgetSet.onPreRender(guiGraphics, pMouseX, pMouseY, partialTicks);
        this.updateCursorEdges();
    }

    private void updateCursorEdges() {
        this.cursorBoundsX = this.menuBoundsX + this.cursorBoundsOffsetX;
        this.cursorBoundsY = this.menuBoundsY + this.cursorBoundsOffsetY;
        this.cursorBoundsWidth = this.menuBoundsWidth + this.cursorBoundsOffsetWidth;
        this.cursorBoundsHeight = this.menuBoundsHeight + this.cursorBoundsOffsetHeight;
        if (this.backgroundExtended) {
            this.cursorBoundsWidth += 100;
        }
    }

    public void repopulateWidgets() {
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.tabButton);
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.dragButton);
        this.widgetSet.getWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
    }

    public void setSettingsTab(SettingsTab settingsTab) {
        this.settingsTab = settingsTab;
        this.m_7856_();
    }

    public void setOverlaysTab(@NotNull VROverlay select) {
        this.settingsTab = SettingsTab.OVERLAYS;
        this.m_7856_();
        SearchableListWidgetSet overlayListWidget = ((OverlaysWidgetSet)this.widgetSet).getOverlaysList();
        TexturedSelectionList overlaysList = overlayListWidget.getList();
        FilterListBinaryWidgetSet filtersWidget = (FilterListBinaryWidgetSet)overlayListWidget.getFilterWidgetSet();
        filtersWidget.getFiltersWidgetFirst().getList().changeSelectedAll(false);
        filtersWidget.getFiltersWidgetFirst().getList().setSelected("has_options");
        filtersWidget.getFiltersWidgetSecond().getList().changeSelectedAll(true);
        TexturedSelectionList.TexturedEntry overlayEntry = overlaysList.getEntry(select.getId());
        if (overlayEntry != null) {
            overlaysList.setSelected(overlayEntry);
            overlaysList.scrollTo(overlayEntry);
        }
    }

    @Override
    protected void onPreTick() {
        if (!this.isInViewDistance()) {
            this.setEnabled(false);
        }
    }

    @Override
    protected void onTick() {
        this.widgetSet.onTick();
    }

    @Override
    protected void onUpdatePose(float partialTicks) {
        VROverlayHelper.applyRoomPose(this, this.getPose().getScale(), this.roomPosition, this.roomRotation);
    }

    @Override
    protected boolean updateVisibility() {
        return true;
    }

    @Override
    public boolean supportsLight() {
        return false;
    }

    @Override
    public void onEnable() {
        VROverlayHelper.applyPose(this, PoseAnchor.HMD, PoseAnchor.HMD, this.getPose().getScale(), true, (Vector3fc)this.posOffset, (Vector3fc)this.rotationOffset);
        this.roomPosition = ClientContext.player.getPoseData(PoseDataType.ROOM).convertPositionFrom(PoseDataType.RENDER, this.getPose().getPosition());
        this.roomRotation = ClientContext.player.getPoseData(PoseDataType.ROOM).convertRotationFrom(PoseDataType.RENDER, this.getPose().getRotation());
    }

    @Override
    public void onDisable() {
        VROverlayOptionsMenu optionsMenu = (VROverlayOptionsMenu)ClientContext.overlayManager.getOverlay("options_menu");
        assert (optionsMenu != null);
        optionsMenu.setEnabled(false);
        this.setDragged(false);
        this.settingsTab = SettingsTab.OVERLAYS;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonType) {
        if (this.getForcedAnchor() != null) {
            this.setDragged(false);
            return true;
        }
        VROverlayDemo demo = (VROverlayDemo)ClientContext.overlayManager.getOverlay("demo");
        if (demo != null && demo.getMovingByAnchor() != null) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, buttonType);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonType) {
        if (this.getForcedAnchor() != null) {
            this.setDragged(false);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, buttonType);
    }

    @Override
    public void setForcedAnchor(@Nullable PoseAnchor forcedAnchor) {
        if (this.getForcedAnchor() != null && forcedAnchor == null) {
            this.roomPosition = ClientContext.player.getPoseData(PoseDataType.ROOM).convertPositionFrom(PoseDataType.RENDER, this.getPose().getPosition());
            this.roomRotation = ClientContext.player.getPoseData(PoseDataType.ROOM).convertRotationFrom(PoseDataType.RENDER, this.getPose().getRotation());
        }
        super.setForcedAnchor(forcedAnchor);
    }

    private void setDragged(boolean flag) {
        if (this.dragButton != null) {
            this.dragButton.setSelected(flag);
        }
        if (!flag && this.getForcedAnchor() != null) {
            if (ClientContext.cursorHandler.getForceFocused() == this) {
                ClientContext.cursorHandler.setForceFocused(null);
            }
            this.setForcedAnchor(null);
        } else if (flag) {
            ClientContext.cursorHandler.setForceFocused(this);
            PoseAnchor anchor = ClientContext.cursorHandler.getCursorHand() == ControllerHand.MAIN ? PoseAnchor.MAIN_HAND : PoseAnchor.OFFHAND;
            this.setForcedAnchor(anchor);
        }
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.m_237115_((String)"visor.overlay.%s.name".formatted(this.getId()));
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.m_237115_((String)"visor.overlay.%s.description".formatted(this.getId()));
    }

    public SettingsTab getSettingsTab() {
        return this.settingsTab;
    }

    public WidgetSet getWidgetSet() {
        return this.widgetSet;
    }

    public boolean isBackgroundExtended() {
        return this.backgroundExtended;
    }

    public void setBackgroundExtended(boolean backgroundExtended) {
        this.backgroundExtended = backgroundExtended;
    }

    public int getMenuBoundsX() {
        return this.menuBoundsX;
    }

    public int getMenuBoundsY() {
        return this.menuBoundsY;
    }

    public int getMenuBoundsWidth() {
        return this.menuBoundsWidth;
    }

    public int getMenuBoundsHeight() {
        return this.menuBoundsHeight;
    }

    public int getCursorBoundsOffsetX() {
        return this.cursorBoundsOffsetX;
    }

    public int getCursorBoundsOffsetY() {
        return this.cursorBoundsOffsetY;
    }

    public int getCursorBoundsOffsetWidth() {
        return this.cursorBoundsOffsetWidth;
    }

    public int getCursorBoundsOffsetHeight() {
        return this.cursorBoundsOffsetHeight;
    }

    public void setCursorBoundsOffsetX(int cursorBoundsOffsetX) {
        this.cursorBoundsOffsetX = cursorBoundsOffsetX;
    }

    public void setCursorBoundsOffsetY(int cursorBoundsOffsetY) {
        this.cursorBoundsOffsetY = cursorBoundsOffsetY;
    }

    public void setCursorBoundsOffsetWidth(int cursorBoundsOffsetWidth) {
        this.cursorBoundsOffsetWidth = cursorBoundsOffsetWidth;
    }

    public void setCursorBoundsOffsetHeight(int cursorBoundsOffsetHeight) {
        this.cursorBoundsOffsetHeight = cursorBoundsOffsetHeight;
    }

    public static enum SettingsTab {
        OVERLAYS,
        CREATE_OVERLAY;


        public WidgetSet widgetSet(VROverlaySettings settings) {
            return this == OVERLAYS ? settings.overlaysWidgetSet : settings.createOverlayWidgetSet;
        }

        private ResourceLocation background() {
            return this == OVERLAYS ? BACKGROUND_OVERLAYS : BACKGROUND_CREATE;
        }

        private ResourceLocation backgroundExtra(VROverlaySettings settings) {
            return this == OVERLAYS ? BACKGROUND_EXTRA : (settings.isBackgroundExtended() ? BACKGROUND_EXTRA_EXTENDED : BACKGROUND_EXTRA);
        }

        private void changeTab(VROverlaySettings settings) {
            settings.settingsTab = this == OVERLAYS ? CREATE_OVERLAY : OVERLAYS;
            settings.m_7856_();
        }
    }
}

