/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplateRecord;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsIdentity;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.lists.FilterListType;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.FiltersListWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.SearchableListWidgetSet;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.SettingsTextures;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlaySettings;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.identity.SetupIdentityWidgetSet;
import me.phoenixra.visor.core.client.gui.registry.VROverlayRegistry;
import me.phoenixra.visor.core.client.gui.registry.VROverlayTemplateRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CreateOverlayWidgetSet
extends DynamicWidgetSet {
    private final VROverlaySettings owner;
    private SetupIdentityWidgetSet setupIdentity;
    private SearchableListWidgetSet templatesWidget;
    private ButtonImaged createButton;
    private final Map<String, String> addonFiltersName = new LinkedHashMap<String, String>();
    private final Map<String, Function<String, Boolean>> addonFiltersFunc = new LinkedHashMap<String, Function<String, Boolean>>();
    private int filterStartX;
    private int filterStartY;
    private VROverlayTemplateRecord selectedTemplate = null;

    public CreateOverlayWidgetSet(@NotNull VROverlaySettings owner, @NotNull Runnable onWidgetsChanged) {
        super(onWidgetsChanged);
        this.owner = owner;
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        for (VisorAddon addon : VisorAPI.addonManager().getAddons()) {
            String filterId = "addon_" + addon.getAddonId();
            this.addonFiltersName.put(filterId, addon.getAddonName().getString());
            this.addonFiltersFunc.put(filterId, it -> {
                VROverlayTemplateRecord templateRecord = ClientContext.overlayManager.getOverlayTemplatesRegistry().getElement((String)it);
                if (templateRecord == null) {
                    return false;
                }
                return templateRecord.getOwner().getAddonId().equals(addon.getAddonId());
            });
        }
        ArrayList<String> filtersAddons = new ArrayList<String>(this.addonFiltersName.keySet().stream().toList());
        if (this.templatesWidget != null) {
            FiltersListWidgetSet filter = (FiltersListWidgetSet)this.templatesWidget.getFilterWidgetSet();
            filtersAddons.clear();
            filtersAddons.addAll(filter.getActiveFilterIds());
        }
        LinkedHashMap<String, String> templatesMap = new LinkedHashMap<String, String>();
        ClientContext.overlayManager.getOverlayTemplatesRegistry().getAllElements().forEach(it -> templatesMap.put(it.getId(), it.name().getString()));
        this.setupIdentity = new SetupIdentityWidgetSet(this.owner.getMenuBoundsX(), this.owner.getMenuBoundsY(), true);
        this.createButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() + 122, this.owner.getMenuBoundsY() + 230).size(102, 15).setTexture(OptionTextures.BLACK_TEXTURE).setTextureInactive(SettingsTextures.CREATE_BUTTON_WARNING).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT, 0.65f).setText((Component)Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create")).setTextColor(VROverlaySettings.TEXT_COLOR), button -> {
            if (this.isReadyToCreate() != null) {
                return;
            }
            this.create();
        });
        this.filterStartX = this.owner.getMenuBoundsX() + 234;
        this.filterStartY = this.owner.getMenuBoundsY() + 57;
        FiltersListWidgetSet<String> filterWidget = new FiltersListWidgetSet.Builder(FilterListType.AT_LEAST_ONE, new WidgetInfoCheckboxList().pos(this.filterStartX + 7, this.filterStartY + 51).size(103, 133).textures(OptionTextures.BLACK_TEXTURE, SettingsTextures.CHECKBOX_BUTTON, SettingsTextures.CHECKBOX_BUTTON_HOVERED, SettingsTextures.CHECKBOX_BUTTON_SELECTED, SettingsTextures.CHECKBOX_BUTTON_HOVERED_SELECTED).setTextColor(VROverlaySettings.TEXT_COLOR), this.addonFiltersName, this.addonFiltersFunc, () -> filtersAddons).background(new WidgetInfoImage().pos(this.filterStartX, this.filterStartY).size(114, 188).setTexture(SettingsTextures.FILTER_BACKGROUND)).checkboxAll(new WidgetInfoButtonImaged().pos(this.filterStartX + 6, this.filterStartY + 33).size(12, 14).textures(SettingsTextures.CHECKBOX_BUTTON, SettingsTextures.CHECKBOX_BUTTON_HOVERED, SettingsTextures.CHECKBOX_BUTTON_SELECTED, SettingsTextures.CHECKBOX_BUTTON_HOVERED_SELECTED, null).setInactiveOnSelected(false)).searchBox(new WidgetInfoEditBox().pos(this.filterStartX + 22, this.filterStartY + 33).size(86, 14).setTexture(OptionTextures.BLACK_TEXTURE).setTextColor(VROverlaySettings.TEXT_COLOR).setHint(VROverlaySettings.TEXT_FIND)).build();
        this.templatesWidget = new SearchableListWidgetSet.Builder(new WidgetInfoSelectionList().pos(this.owner.getMenuBoundsX() + 125, this.owner.getMenuBoundsY() + 68).size(96, 154).setEntryButton(new WidgetInfoButtonImaged().setTexture(OptionTextures.GRAY_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT)).setTooltip(id -> {
            VROverlayTemplateRegistry registry = ClientContext.overlayManager.getOverlayTemplatesRegistry();
            VROverlayTemplateRecord template = registry.getElement((String)id);
            if (template == null) {
                return Component.m_237119_();
            }
            return Component.m_237110_((String)"visor.overlay.options.main.create_overlay.template_tooltip", (Object[])new Object[]{template.getOwner().getAddonName(), template.id(), template.description()});
        }), templatesMap, selected -> {
            VROverlayTemplateRegistry registry = ClientContext.overlayManager.getOverlayTemplatesRegistry();
            this.selectedTemplate = registry.getElement(selected.getId());
        }, this.onWidgetsChanged).searchBox(new WidgetInfoEditBox().pos(this.owner.getMenuBoundsX() + 125, this.owner.getMenuBoundsY() + 50).size(77, 15).setTexture(OptionTextures.GRAY_TEXTURE).setTextColor(VROverlaySettings.TEXT_COLOR).setHint(VROverlaySettings.TEXT_FIND)).filterButton(new WidgetInfoButtonImaged().pos(this.owner.getMenuBoundsX() + 206, this.owner.getMenuBoundsY() + 50).size(15, 15).textures(SettingsTextures.FILTER_GRAY_BUTTON, SettingsTextures.FILTER_GRAY_BUTTON_HOVERED, SettingsTextures.FILTER_GRAY_BUTTON_SELECTED).setInactiveOnSelected(false), filterWidget).build();
        this.setupIdentity.initWidgets();
        this.templatesWidget.initWidgets();
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.setupIdentity.getWidgets());
        list.addAll(this.templatesWidget.getWidgets());
        list.add((Object)this.createButton);
        return list;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textColor = VROverlaySettings.TEXT_COLOR.toInt();
        boolean filterSelected = this.templatesWidget.getFilterButton().isSelected();
        Component readyFallback = this.isReadyToCreate();
        boolean bl = this.createButton.f_93623_ = readyFallback == null;
        if (readyFallback != null) {
            this.createButton.m_257544_(Tooltip.m_257550_((Component)readyFallback));
        } else {
            this.createButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create.tooltip")));
        }
        this.owner.setBackgroundExtended(filterSelected);
        this.setupIdentity.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        this.templatesWidget.onPreRender(guiGraphics, mouseX, mouseY, partialTicks);
        GuiHelper.renderScalableText(guiGraphics, font, Component.m_237115_((String)"visor.overlay.options.main.create_overlay.select_template").getString(), textColor, this.getOwner().getMenuBoundsX() + 129, this.getOwner().getMenuBoundsY() + 38, 88, 8, true);
        if (filterSelected) {
            GuiHelper.renderScalableText(guiGraphics, font, Component.m_237115_((String)"visor.overlay.options.main.overlays.filters.addons").getString(), textColor, this.filterStartX + 8, this.filterStartY + 6, 98, 11, true);
        }
    }

    @Override
    public void onTick() {
        this.setupIdentity.onTick();
        this.templatesWidget.onTick();
    }

    private Component isReadyToCreate() {
        if (this.setupIdentity.getIdWidget().m_94155_().isBlank()) {
            return Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create.tooltip.id");
        }
        VROverlayRegistry registry = ClientContext.overlayManager.getOverlaysRegistry();
        if (registry.getElement(this.setupIdentity.getIdWidget().m_94155_()) != null) {
            return Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create.tooltip.id.exists");
        }
        if (this.setupIdentity.getNameWidget().m_94155_().isBlank()) {
            return Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create.tooltip.name");
        }
        if (this.selectedTemplate == null) {
            return Component.m_237115_((String)"visor.overlay.options.main.create_overlay.create.tooltip.template");
        }
        return null;
    }

    private void create() {
        String id = this.setupIdentity.getIdWidget().m_94155_();
        String name = this.setupIdentity.getNameWidget().m_94155_();
        String description = this.setupIdentity.getDescriptionWidget().getValue();
        if (description.isBlank()) {
            description = null;
        }
        VROverlayRegistry registry = ClientContext.overlayManager.getOverlaysRegistry();
        try {
            VROverlayTemplate overlay = this.selectedTemplate.constructor().newInstance(ClientContext.coreAddon, id);
            registry.registerElement(overlay);
            OverlayOptionsIdentity identity = overlay.getOption("identity", OverlayOptionsIdentity.class);
            Objects.requireNonNull(identity);
            identity.setName(name);
            identity.setDescription(description);
            ResourceLocation iconResource = this.setupIdentity.getSetupIconWidget().getIcon().getResourceLocation();
            String iconPath = iconResource.m_135827_() + ":" + iconResource.m_135815_();
            identity.setIcon(iconPath);
            identity.save();
            overlay.updateIdentity();
            this.owner.setOverlaysTab(overlay);
        }
        catch (Exception e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public VROverlaySettings getOwner() {
        return this.owner;
    }
}

