/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.TextBoxEditable;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoTextBoxEditable;
import me.phoenixra.visor.api.client.gui.widgets.lists.TexturedSelectionList;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.SettingsTextures;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlaySettings;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.OverlaysWidgetSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class SetupOverlayWidgetSet
extends DynamicWidgetSet {
    private final OverlaysWidgetSet owner;
    private final VROverlay overlay;
    private final int startX;
    private final int startY;
    private final boolean hasSettings;
    private final boolean isCustom;
    private final VROverlayTemplate asTemplate;
    private TextBoxEditable descriptionWidget;
    private TexturedSelectionList optionsListWidget;
    private ButtonImaged loadDefaultsWidget;
    private ButtonImaged saveButtonWidget;
    private ButtonImaged removeButtonWidget;
    private boolean confirmRemove;
    private ButtonImaged confirmRemoveWidget;
    private ButtonImaged cancelRemoveWidget;
    private ButtonImaged copyButtonWidget;
    private ButtonImaged pasteButtonWidget;
    private ButtonImaged loadFromFileButtonWidget;
    private HashMap<String, OverlayOptionGroup<?>> optionsMap;

    public SetupOverlayWidgetSet(@NotNull OverlaysWidgetSet owner, @NotNull VROverlay overlay, @NotNull Runnable onWidgetsChanged, int startX, int startY) {
        super(onWidgetsChanged);
        this.owner = owner;
        this.overlay = overlay;
        this.startX = startX;
        this.startY = startY;
        this.hasSettings = !overlay.getOptions().isEmpty();
        this.isCustom = overlay.isCustom();
        this.asTemplate = overlay.asTemplate();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        this.descriptionWidget = new TextBoxEditable(new WidgetInfoTextBoxEditable().pos(this.startX + 5, this.startY + 39).size(92, 54).setText(this.overlay.getDescription()).setTextColor(VROverlaySettings.TEXT_COLOR).setTextScale(0.6f).setBackground(OptionTextures.GRAY_TEXTURE));
        this.descriptionWidget.setReadOnly(true);
        if (!this.hasSettings) {
            return this.getWidgets();
        }
        this.copyButtonWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 112, this.startY + 99).size(17, 17).textures(SettingsTextures.COPY_BUTTON, SettingsTextures.COPY_BUTTON_HOVERED, null, null, SettingsTextures.COPY_BUTTON_INACTIVE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.copy_options.tooltip"))), button -> {
            TexturedSelectionList.TexturedEntry selectedEntry = (TexturedSelectionList.TexturedEntry)this.optionsListWidget.m_93511_();
            OverlayOptionGroup<?> options = this.optionsMap.get(selectedEntry.getId());
            if (options == null) {
                return;
            }
            if (!options.canCopy()) {
                return;
            }
            this.owner.setCopiedOptionGroup(options);
            this.widgetsChanged();
        });
        this.pasteButtonWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 112, this.startY + 124).size(17, 17).textures(SettingsTextures.PASTE_BUTTON, SettingsTextures.PASTE_BUTTON_HOVERED, null, null, SettingsTextures.PASTE_BUTTON_INACTIVE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.paste_options.tooltip"))), button -> {
            OverlayOptionGroup<?> optionsToCopy = this.owner.getCopiedOptionGroup();
            TexturedSelectionList.TexturedEntry selectedEntry = (TexturedSelectionList.TexturedEntry)this.optionsListWidget.m_93511_();
            OverlayOptionGroup<?> optionsTarget = this.optionsMap.get(selectedEntry.getId());
            if (optionsToCopy == null) {
                return;
            }
            if (optionsTarget == null || !optionsTarget.canCopyFrom(optionsToCopy)) {
                return;
            }
            optionsTarget.loadFromOther(optionsToCopy);
            this.owner.setCopiedOptionGroup(null);
            this.widgetsChanged();
        });
        this.loadFromFileButtonWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 112, this.startY + 156).size(17, 17).setTexture(SettingsTextures.BUTTON_LOAD).setTextureHovered(SettingsTextures.BUTTON_LOAD_HOVERED).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.load.tooltip"))), button -> this.overlay.reloadOptions());
        LinkedHashMap<String, String> rawEntries = new LinkedHashMap<String, String>();
        this.optionsMap = new HashMap();
        for (OverlayOptionGroup<?> entry : this.overlay.getOptions()) {
            rawEntries.put(entry.getId(), entry.getDisplayName().getString());
            this.optionsMap.put(entry.getId(), entry);
        }
        this.optionsListWidget = new TexturedSelectionList(new WidgetInfoSelectionList().pos(this.startX + 5, this.startY + 110).size(93, 58).setEntryButton(new WidgetInfoButtonImaged().setTexture(OptionTextures.GRAY_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT)).setTextureScrollBarActive(OptionTextures.SCROLL_BAR_ACTIVE).setTextColor(VROverlaySettings.TEXT_COLOR).setSupportDeselection(true), rawEntries, it -> {
            if (it == null) {
                this.owner.setOptionsMenu(null);
                return;
            }
            OverlayOptionGroup<?> options = this.optionsMap.get(it.getId());
            if (options == null) {
                return;
            }
            this.owner.setOptionsMenu(options);
        });
        this.loadDefaultsWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX, this.startY + 176).size(102, 15).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setTextColor(VROverlaySettings.TEXT_COLOR).setText((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.load_defaults")), it -> this.loadDefaults());
        this.saveButtonWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.isCustom ? this.startX : this.startX + 9, this.startY + 195).size(83, 15).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setTextColor(VROverlaySettings.TEXT_COLOR).setText((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.save")), it -> this.saveChanges());
        if (!this.isCustom) {
            return this.getWidgets();
        }
        this.removeButtonWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 87, this.startY + 195).size(15, 15).setTexture(SettingsTextures.REMOVE_BUTTON).setTextureHovered(SettingsTextures.REMOVE_BUTTON_HOVERED), it -> {
            this.confirmRemove = true;
            this.widgetsChanged();
        });
        this.confirmRemoveWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX, this.startY + 195).size(83, 15).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setTextColor(VROverlaySettings.TEXT_COLOR).setText((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.confirm_remove")), it -> {
            this.confirmRemove = false;
            this.owner.removeOverlay(this.overlay);
        });
        this.cancelRemoveWidget = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 87, this.startY + 195).size(15, 15).setTexture(SettingsTextures.CANCEL_BUTTON).setTextureHovered(SettingsTextures.CANCEL_BUTTON_HOVERED), it -> {
            this.confirmRemove = false;
            this.widgetsChanged();
        });
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add((Object)this.descriptionWidget);
        if (!this.hasSettings) {
            return list;
        }
        list.add((Object)this.copyButtonWidget);
        if (this.owner.getCopiedOptionGroup() != null) {
            list.add((Object)this.pasteButtonWidget);
        }
        list.add((Object)this.loadFromFileButtonWidget);
        list.add((Object)this.optionsListWidget);
        list.add((Object)this.loadDefaultsWidget);
        if (this.isCustom) {
            if (this.confirmRemove) {
                list.add((Object)this.confirmRemoveWidget);
                list.add((Object)this.cancelRemoveWidget);
            } else {
                list.add((Object)this.removeButtonWidget);
                list.add((Object)this.saveButtonWidget);
            }
        } else {
            list.add((Object)this.saveButtonWidget);
        }
        return list;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hasSettings) {
            TexturedSelectionList.TexturedEntry selectedEntry = (TexturedSelectionList.TexturedEntry)this.optionsListWidget.m_93511_();
            OverlayOptionGroup<?> options = null;
            if (selectedEntry != null) {
                options = this.optionsMap.get(selectedEntry.getId());
            }
            this.copyButtonWidget.f_93624_ = options != null;
            boolean bl = this.copyButtonWidget.f_93623_ = options != null && options.canCopy();
            if (this.owner.getCopiedOptionGroup() != null) {
                boolean bl2 = this.pasteButtonWidget.f_93623_ = options != null && options.canCopyFrom(this.owner.getCopiedOptionGroup());
            }
            if (!this.confirmRemove) {
                boolean changesNotSaved = false;
                for (OverlayOptionGroup<?> optionGroup : this.optionsMap.values()) {
                    if (!optionGroup.isChangesNotSaved()) continue;
                    changesNotSaved = true;
                    break;
                }
                WidgetInfoButtonImaged widgetInfo = this.saveButtonWidget.getWidgetInfo();
                if (changesNotSaved) {
                    widgetInfo.getTextPosOffset().x = 13;
                    widgetInfo.getTextSizeOffset().x = -26;
                    widgetInfo.setTexture(SettingsTextures.BUTTON_SAVE_WARNING);
                    this.saveButtonWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.save.tooltip_not_saved")));
                    this.copyButtonWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.copy.tooltip_not_saved")));
                    this.pasteButtonWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.overlays.paste.tooltip_not_saved")));
                } else {
                    widgetInfo.getTextSizeOffset().x = 0;
                    widgetInfo.getTextPosOffset().x = 0;
                    widgetInfo.setTexture(OptionTextures.BLACK_TEXTURE);
                    this.saveButtonWidget.m_257544_(null);
                    this.copyButtonWidget.m_257544_(null);
                    this.pasteButtonWidget.m_257544_(null);
                }
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int textColor = VROverlaySettings.TEXT_COLOR.toInt();
        GuiTexture icon = this.overlay.getIcon();
        GuiTexture labelTexture = this.isCustom ? SettingsTextures.LABEL_CUSTOM : SettingsTextures.LABEL_BUILT_IN;
        MutableComponent addonText = Component.m_237110_((String)"visor.overlay.options.main.overlays.addon", (Object[])new Object[]{this.overlay.getOwner().getAddonName()});
        MutableComponent idText = Component.m_237110_((String)"visor.overlay.options.main.overlays.id", (Object[])new Object[]{this.overlay.getId()});
        icon.blit(guiGraphics, this.startX + 5, this.startY + 3, 19, 19);
        GuiHelper.renderScalableText(guiGraphics, font, this.overlay.getName().getString(), textColor, this.startX + 33, this.startY + 4, 66, 6, true);
        GuiHelper.renderScalableText(guiGraphics, font, addonText.getString(), textColor, this.startX + 33, this.startY + 13, 66, 5, false);
        GuiHelper.renderScalableText(guiGraphics, font, idText.getString(), textColor, this.startX + 33, this.startY + 19, 66, 5, false);
        this.descriptionWidget.setValue(this.overlay.getDescription().getString());
        labelTexture.blit(guiGraphics, this.startX + 5, this.startY + 25, 10, 10);
        if (this.isCustom) {
            MutableComponent templateText = Component.m_237110_((String)"visor.overlay.options.main.overlays.template", (Object[])new Object[]{this.asTemplate.getTemplateName().getString()});
            OptionTextures.GRAY_TEXTURE.blit(guiGraphics, this.startX + 24, this.startY + 25, 75, 10);
            GuiHelper.renderScalableText(guiGraphics, font, templateText.getString(), textColor, this.startX + 24 + 2, this.startY + 25 + 2, 73, 8, false);
        }
        if (!this.hasSettings) {
            OptionTextures.BLACK_TEXTURE.blit(guiGraphics, this.startX, this.startY + 99, 102, 111);
            GuiHelper.renderScalableText(guiGraphics, font, Component.m_237115_((String)"visor.overlay.options.main.overlays.options_not_found").getString(), textColor, this.startX + 15, this.startY + 152, 72, 8, true);
        } else {
            OptionTextures.BLACK_TEXTURE.blit(guiGraphics, this.startX, this.startY + 99, 102, 73);
            GuiHelper.renderScalableText(guiGraphics, font, Component.m_237115_((String)"visor.overlay.options.main.overlays.select_options").getString(), textColor, this.startX + 9, this.startY + 102, 84, 8, true);
        }
    }

    @Override
    public void onTick() {
    }

    private void loadDefaults() {
        TexturedSelectionList.TexturedEntry entry = (TexturedSelectionList.TexturedEntry)this.optionsListWidget.m_93511_();
        if (entry == null) {
            for (OverlayOptionGroup<?> options : this.optionsMap.values()) {
                options.loadDefaults();
            }
            return;
        }
        OverlayOptionGroup<?> options = this.optionsMap.get(entry.getId());
        if (options == null) {
            return;
        }
        options.loadDefaults();
        this.owner.setOptionsMenu(options);
    }

    private void saveChanges() {
        for (OverlayOptionGroup<?> options : this.optionsMap.values()) {
            options.save();
        }
    }
}

