/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.overlays.builtin.settings.widgets.identity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.sets.WidgetSet;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.gui.overlays.builtin.settings.VROverlaySettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class SetupIconWidgetSet
implements WidgetSet {
    private final int startX;
    private final int startY;
    private GuiTexture icon = VisorAddon.MISSING_ICON;
    private GuiTexture preIcon = null;
    private EditBoxImage editorTexturePath;
    private Consumer<String> responder;

    public SetupIconWidgetSet(int startX, int startY) {
        this.startX = startX;
        this.startY = startY;
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        this.editorTexturePath = new EditBoxImage(new WidgetInfoEditBox().pos(this.startX + 4, this.startY + 71).size(100, 13).setTexture(OptionTextures.GRAY_TEXTURE).setTextColor(VROverlaySettings.TEXT_COLOR).setHint((Component)Component.m_237115_((String)"visor.overlay.options.main.create_overlay.type_icon_path")).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.main.create_overlay.type_icon_path.tooltip"))));
        this.editorTexturePath.m_94151_(it -> this.tryLoadPreIcon());
        this.editorTexturePath.m_94199_(80);
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<EditBoxImage> list = new ArrayList<EditBoxImage>();
        list.add(this.editorTexturePath);
        return list;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean iconUpdate = false;
        try {
            if (this.preIcon != null) {
                this.preIcon.blit(guiGraphics, this.startX + 19, this.startY + 18, 40, 40);
                this.preIcon.blit(guiGraphics, this.startX + 70, this.startY + 28, 19, 19);
                this.icon = this.preIcon;
                this.preIcon = null;
                iconUpdate = true;
            }
        }
        catch (Exception e) {
            this.icon = VisorAddon.MISSING_ICON;
            this.preIcon = null;
        }
        this.icon.blit(guiGraphics, this.startX + 19, this.startY + 18, 40, 40);
        this.icon.blit(guiGraphics, this.startX + 70, this.startY + 28, 19, 19);
        GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"visor.overlay.options.main.create_overlay.load_icon").getString(), VROverlaySettings.TEXT_COLOR.toInt(), this.startX + 10, this.startY + 5, 88, 8, true);
        if (iconUpdate && this.responder != null) {
            this.responder.accept(this.editorTexturePath.m_94155_());
        }
    }

    @Override
    public void onTick() {
        this.editorTexturePath.m_94120_();
    }

    public void setIconPath(String path) {
        this.editorTexturePath.m_94144_(path);
        this.tryLoadPreIcon();
    }

    private void tryLoadPreIcon() {
        this.icon = VisorAddon.MISSING_ICON;
        if (this.editorTexturePath.m_94155_().isEmpty()) {
            return;
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            String path = this.editorTexturePath.m_94155_();
            if (!path.endsWith(".png")) {
                return;
            }
            ResourceLocation resourceLoc = new ResourceLocation(path);
            Optional resource = resourceManager.m_213713_(resourceLoc);
            if (resource.isEmpty()) {
                return;
            }
            this.preIcon = new GuiTexture(resourceLoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GuiTexture getIcon() {
        return this.icon;
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }
}

