/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens;

import java.util.List;
import java.util.Objects;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.exceptions.VisorException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class VRErrorReportScreen
extends Screen {
    private final String discordUrl = Component.m_237115_((String)"visor.messages.discord_link").getString();
    private final String logsFolderUrl;
    private final Component summary;
    private List<FormattedCharSequence> summaryLines;

    public VRErrorReportScreen(Component title, Throwable t) {
        super(title);
        this.logsFolderUrl = Minecraft.m_91087_().f_91069_.toPath().resolve("logs").toUri().toString();
        this.summary = Component.m_237115_((String)"visor.messages.error.summary");
    }

    protected void m_7856_() {
        int maxWidth = this.f_96543_ - 40;
        this.summaryLines = this.f_96547_.m_92923_((FormattedText)this.summary, maxWidth);
        int btnW = 100;
        int btnH = 20;
        int gap = 10;
        int rowCnt = 3;
        int bottomY = this.f_96544_ - 32;
        int totalW = 320;
        int startX = (this.f_96543_ - totalW) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> Minecraft.m_91087_().m_91152_((Screen)new TitleScreen())).m_253046_(100, 20).m_252794_(startX, bottomY).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"visor.button.open_logs"), b -> Util.m_137581_().m_137646_(this.logsFolderUrl)).m_253046_(100, 20).m_252794_(startX + 110, bottomY).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"visor.button.discord"), b -> Util.m_137581_().m_137646_(this.discordUrl)).m_253046_(100, 20).m_252794_(startX + 220, bottomY).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics gfx, int mx, int my, float pt) {
        this.m_280273_(gfx);
        gfx.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFF5555);
        int y = 40;
        for (FormattedCharSequence line : this.summaryLines) {
            int lineWidth = this.f_96547_.m_92724_(line);
            int x = (this.f_96543_ - lineWidth) / 2;
            gfx.m_280649_(this.f_96547_, line, x, y, 0xFFFFFF, false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
        super.m_88315_(gfx, mx, my, pt);
    }

    public static void catchError(Throwable t, boolean log) {
        MutableComponent mutableComponent;
        if (log) {
            LoggerUtils.printError(t);
        }
        if (t instanceof VisorException) {
            VisorException vx = (VisorException)t;
            mutableComponent = vx.getTitle();
        } else {
            mutableComponent = Component.m_237115_((String)"visor.messages.error.generic");
        }
        MutableComponent title = mutableComponent;
        Minecraft.m_91087_().m_6937_(() -> VRErrorReportScreen.lambda$catchError$3((Component)title, t));
    }

    private static /* synthetic */ void lambda$catchError$3(Component title, Throwable t) {
        Minecraft.m_91087_().m_91152_((Screen)new VRErrorReportScreen(title, t));
    }
}

