/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.overlayoptions;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsScreenRegion;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoValueDrag;
import me.phoenixra.visor.api.client.gui.widgets.sets.ValueEditorInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class OptionsScreenRegion
extends OptionsScreen<OverlayOptionsScreenRegion> {
    private static final int FIELD_HEIGHT = 15;
    private static final int ROW2_Y = 60;
    private static final int IN_GROUP_GAP = 10;
    private static final int BETWEEN_GROUPS_GAP = 20;
    private static final int PREVIEW_MARGIN = 8;
    private static final int KNOB_SIZE = 8;
    private static final int KNOB_HALF = 4;
    private static final int EDGE_GRAB_SLOP = 4;
    private static final int MIN_INNER_MOVE_PX = 8;
    private int previewX;
    private int previewY;
    private int previewW;
    private int previewH;
    private double previewScale;
    private DragHandle activeHandle = DragHandle.NONE;
    private int dragStartMouseX;
    private int dragStartMouseY;
    private int startRegionX;
    private int startRegionY;
    private int startRegionW;
    private int startRegionH;
    private int previewRegionStartY;
    private ValueEditorInt editorRegionX;
    private ValueEditorInt editorRegionY;
    private ValueEditorInt editorRegionWidth;
    private ValueEditorInt editorRegionHeight;
    private int lastX = 0;
    private int lastY = 0;
    private int lastWidth = 0;
    private int lastHeight = 0;

    public OptionsScreenRegion(@NotNull OverlayOptionsScreenRegion optionsGroup) {
        super(optionsGroup, OptionsScreen.Background.VERTICAL_WIDER);
    }

    @Override
    protected void onInit() {
        int fieldWidth = (this.cursorBoundsWidth - 30) / 2;
        int fieldX = this.cursorBoundsX + (this.cursorBoundsWidth - fieldWidth) / 2;
        int yStart = this.cursorBoundsY + 20;
        int yRegionY = yStart + 15 + 10;
        int yRegionWidth = yRegionY + 15 + 20;
        int yRegionHeight = yRegionWidth + 15 + 10;
        this.previewRegionStartY = yRegionHeight + 15;
        this.editorRegionX = new ValueEditorInt.Builder(((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX(), fieldX, yStart, fieldWidth, 15).range(0, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth()).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.GRAY_TEXTURE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.screen_region.x")))).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).setResponder(newRegionX -> {
            int maxWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth();
            int currentWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth();
            int clamped = Mth.m_14045_((int)currentWidth, (int)0, (int)(maxWidth - newRegionX));
            if (clamped != currentWidth) {
                this.editorRegionWidth.setValue(clamped, true);
                ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionWidth(clamped);
            }
            ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionX((int)newRegionX);
        }).build();
        this.editorRegionY = new ValueEditorInt.Builder(((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY(), fieldX, yRegionY, fieldWidth, 15).range(0, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight()).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.GRAY_TEXTURE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.screen_region.y")))).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).setResponder(newRegionY -> {
            int maxHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight();
            int currentHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight();
            int clamped = Mth.m_14045_((int)currentHeight, (int)0, (int)(maxHeight - newRegionY));
            if (clamped != currentHeight) {
                this.editorRegionHeight.setValue(clamped, true);
                ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionHeight(clamped);
            }
            ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionY((int)newRegionY);
        }).build();
        this.editorRegionWidth = new ValueEditorInt.Builder(((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth(), fieldX, yRegionWidth, fieldWidth, 15).range(0, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth()).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.GRAY_TEXTURE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.screen_region.width")))).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).setResponder(newRegionWidth -> {
            int maxWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth();
            int regionX = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX();
            int clamped = Mth.m_14045_((int)newRegionWidth, (int)1, (int)(maxWidth - regionX));
            if (clamped != newRegionWidth) {
                this.editorRegionWidth.setValue(clamped, true);
            }
            ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionWidth(clamped);
        }).build();
        this.editorRegionHeight = new ValueEditorInt.Builder(((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight(), fieldX, yRegionHeight, fieldWidth, 15).range(0, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight()).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.GRAY_TEXTURE).setTooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"visor.overlay.options.screen_region.height")))).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_GRAY_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT)).setResponder(newRegionHeight -> {
            int maxHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight();
            int regionY = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY();
            int clamped = Mth.m_14045_((int)newRegionHeight, (int)1, (int)(maxHeight - regionY));
            if (clamped != newRegionHeight) {
                this.editorRegionHeight.setValue(clamped, true);
            }
            ((OverlayOptionsScreenRegion)this.optionsGroup).setRegionHeight(clamped);
        }).build();
        this.lastX = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX();
        this.lastY = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY();
        this.lastWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth();
        this.lastHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight();
        this.editorRegionX.initWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
        this.editorRegionY.initWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
        this.editorRegionWidth.initWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
        this.editorRegionHeight.initWidgets().forEach(x$0 -> this.m_142416_((GuiEventListener)x$0));
    }

    public void m_86600_() {
        int regionX = this.editorRegionX.getValue();
        int regionY = this.editorRegionY.getValue();
        int regionWidth = this.editorRegionWidth.getValue();
        int regionHeight = this.editorRegionHeight.getValue();
        if (this.lastX != regionX || this.lastY != regionY || this.lastWidth != regionWidth || this.lastHeight != regionHeight) {
            OverlayOptionsPose pose = ((OverlayOptionsScreenRegion)this.optionsGroup).getOwner().getOption("pose", OverlayOptionsPose.class);
            if (pose != null) {
                float factor = (float)Math.sqrt((double)regionWidth / (double)this.lastWidth * ((double)regionHeight / (double)this.lastHeight));
                pose.setScale(pose.getScale() * factor);
            }
            this.lastX = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX();
            this.lastY = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY();
            this.lastWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth();
            this.lastHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight();
        }
        this.editorRegionX.onTick();
        this.editorRegionY.onTick();
        this.editorRegionWidth.onTick();
        this.editorRegionHeight.onTick();
    }

    @Override
    protected void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int editBoxWidth = (this.cursorBoundsWidth - 30) / 2;
        int startPosX = this.cursorBoundsX + (this.cursorBoundsWidth - editBoxWidth) / 2;
        int textHeight = 8;
        int fieldWidth = (this.cursorBoundsWidth - 30) / 2;
        int xFieldPosY = this.cursorBoundsY + 12;
        int yFieldPosY = xFieldPosY + 15 + 10;
        int widthFieldPosY = yFieldPosY + 15 + 20;
        int heightFieldPosY = widthFieldPosY + 15 + 10;
        GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "x", AtumColor.LIGHT_GRAY.toInt(), startPosX, xFieldPosY, fieldWidth, textHeight, true);
        GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "y", AtumColor.LIGHT_GRAY.toInt(), startPosX, yFieldPosY, fieldWidth, textHeight, true);
        GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "w", AtumColor.LIGHT_GRAY.toInt(), startPosX, widthFieldPosY, fieldWidth, textHeight, true);
        GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "h", AtumColor.LIGHT_GRAY.toInt(), startPosX, heightFieldPosY, fieldWidth, textHeight, true);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.computePreviewArea();
        this.drawFramebufferPreview(guiGraphics);
        this.drawInteractiveRegionOverlay(guiGraphics);
    }

    private void computePreviewArea() {
        int left = this.background != OptionsScreen.Background.EMPTY && this.background.getTexture() != null ? this.cursorBoundsX + 8 : 8;
        int right = this.background != OptionsScreen.Background.EMPTY && this.background.getTexture() != null ? this.cursorBoundsX + this.cursorBoundsWidth - 8 : this.f_96543_ - 8;
        int bgTop = this.background != OptionsScreen.Background.EMPTY && this.background.getTexture() != null ? this.cursorBoundsY + 8 : 8;
        int top = Math.max(bgTop, this.previewRegionStartY + 8);
        int bottom = this.background != OptionsScreen.Background.EMPTY && this.background.getTexture() != null ? this.cursorBoundsY + this.cursorBoundsHeight - 8 : this.f_96544_ - 8;
        int availW = Math.max(1, right - left);
        int availH = Math.max(1, bottom - top);
        int fbW = Math.max(1, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth());
        int fbH = Math.max(1, ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight());
        double scale = Math.min((double)availW / (double)fbW, (double)availH / (double)fbH);
        int dw = Math.max(1, (int)Math.floor((double)fbW * scale));
        int dh = Math.max(1, (int)Math.floor((double)fbH * scale));
        int px = left + (availW - dw) / 2;
        int py = top + (availH - dh) / 2;
        this.previewX = px;
        this.previewY = py;
        this.previewW = dw;
        this.previewH = dh;
        this.previewScale = scale;
    }

    private void drawFramebufferPreview(GuiGraphics gui) {
        RenderTarget target = ((OverlayOptionsScreenRegion)this.optionsGroup).getTargetSupplier().get();
        if (target == null || target.m_83975_() <= 0) {
            gui.m_280509_(this.previewX, this.previewY, this.previewX + this.previewW, this.previewY + this.previewH, -14671840);
            gui.m_280637_(this.previewX, this.previewY, this.previewW, this.previewH, 0x55FFFFFF);
            return;
        }
        gui.m_280262_();
        RenderSystem.setShaderTexture((int)0, (int)target.m_83975_());
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float uMax = (float)target.f_83917_ / (float)target.f_83915_;
        float vMax = (float)target.f_83918_ / (float)target.f_83916_;
        Matrix4f pose = gui.m_280168_().m_85850_().m_252922_();
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buf.m_252986_(pose, (float)this.previewX, (float)(this.previewY + this.previewH), 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buf.m_252986_(pose, (float)(this.previewX + this.previewW), (float)(this.previewY + this.previewH), 0.0f).m_7421_(uMax, 0.0f).m_5752_();
        buf.m_252986_(pose, (float)(this.previewX + this.previewW), (float)this.previewY, 0.0f).m_7421_(uMax, vMax).m_5752_();
        buf.m_252986_(pose, (float)this.previewX, (float)this.previewY, 0.0f).m_7421_(0.0f, vMax).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        gui.m_280637_(this.previewX, this.previewY, this.previewW, this.previewH, -2130706433);
    }

    private void drawInteractiveRegionOverlay(GuiGraphics gui) {
        int rx = this.previewX + (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX() * this.previewScale);
        int ry = this.previewY + (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY() * this.previewScale);
        int rw = Math.max(1, (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth() * this.previewScale));
        int rh = Math.max(1, (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight() * this.previewScale));
        if (rx < this.previewX) {
            rx = this.previewX;
        }
        if (ry < this.previewY) {
            ry = this.previewY;
        }
        if (rx + rw > this.previewX + this.previewW) {
            rw = this.previewX + this.previewW - rx;
        }
        if (ry + rh > this.previewY + this.previewH) {
            rh = this.previewY + this.previewH - ry;
        }
        int dark = Integer.MIN_VALUE;
        gui.m_280509_(this.previewX, this.previewY, this.previewX + this.previewW, ry, dark);
        gui.m_280509_(this.previewX, ry + rh, this.previewX + this.previewW, this.previewY + this.previewH, dark);
        gui.m_280509_(this.previewX, ry, rx, ry + rh, dark);
        gui.m_280509_(rx + rw, ry, this.previewX + this.previewW, ry + rh, dark);
        int border = -1;
        gui.m_280509_(rx, ry, rx + rw, ry + 1, border);
        gui.m_280509_(rx, ry + rh - 1, rx + rw, ry + rh, border);
        gui.m_280509_(rx, ry, rx + 1, ry + rh, border);
        gui.m_280509_(rx + rw - 1, ry, rx + rw, ry + rh, border);
        this.drawKnob(gui, rx, ry);
        this.drawKnob(gui, rx + rw, ry);
        this.drawKnob(gui, rx, ry + rh);
        this.drawKnob(gui, rx + rw, ry + rh);
    }

    private void drawKnob(GuiGraphics gui, int cx, int cy) {
        int x1 = cx - 4;
        int y1 = cy - 4;
        int x2 = x1 + 8;
        int y2 = y1 + 8;
        gui.m_280509_(x1 - 1, y1 - 1, x2 + 1, y1, -16777216);
        gui.m_280509_(x1 - 1, y2, x2 + 1, y2 + 1, -16777216);
        gui.m_280509_(x1 - 1, y1, x1, y2, -16777216);
        gui.m_280509_(x2, y1, x2 + 1, y2, -16777216);
        gui.m_280509_(x1, y1, x2, y2, -1);
    }

    private DragHandle handleAt(int mouseX, int mouseY) {
        int rx = this.previewX + (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX() * this.previewScale);
        int ry = this.previewY + (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY() * this.previewScale);
        int rw = Math.max(1, (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth() * this.previewScale));
        int rh = Math.max(1, (int)Math.round((double)((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight() * this.previewScale));
        int tlx = rx;
        int tly = ry;
        int trx = rx + rw;
        int try_ = ry;
        int blx = rx;
        int bly = ry + rh;
        int brx = rx + rw;
        int bry = ry + rh;
        if (this.inKnob(mouseX, mouseY, tlx, tly)) {
            return DragHandle.TOP_LEFT;
        }
        if (this.inKnob(mouseX, mouseY, trx, try_)) {
            return DragHandle.TOP_RIGHT;
        }
        if (this.inKnob(mouseX, mouseY, blx, bly)) {
            return DragHandle.BOTTOM_LEFT;
        }
        if (this.inKnob(mouseX, mouseY, brx, bry)) {
            return DragHandle.BOTTOM_RIGHT;
        }
        if (this.inHorizontalEdge(mouseX, mouseY, rx, rx + rw, ry)) {
            return DragHandle.TOP;
        }
        if (this.inHorizontalEdge(mouseX, mouseY, rx, rx + rw, ry + rh)) {
            return DragHandle.BOTTOM;
        }
        if (this.inVerticalEdge(mouseX, mouseY, ry, ry + rh, rx)) {
            return DragHandle.LEFT;
        }
        if (this.inVerticalEdge(mouseX, mouseY, ry, ry + rh, rx + rw)) {
            return DragHandle.RIGHT;
        }
        if (this.canMoveRegion(rw, rh) && this.inInnerArea(mouseX, mouseY, rx, ry, rw, rh)) {
            return DragHandle.MOVE_WHOLE;
        }
        return DragHandle.NONE;
    }

    private boolean inKnob(int mx, int my, int cx, int cy) {
        int x1 = cx - 4;
        int y1 = cy - 4;
        int x2 = x1 + 8;
        int y2 = y1 + 8;
        return mx >= x1 && mx <= x2 && my >= y1 && my <= y2;
    }

    private boolean inHorizontalEdge(int mx, int my, int x1, int x2, int y) {
        return mx >= x1 - 4 && mx <= x2 + 4 && Math.abs(my - y) <= 4;
    }

    private boolean inVerticalEdge(int mx, int my, int y1, int y2, int x) {
        return my >= y1 - 4 && my <= y2 + 4 && Math.abs(mx - x) <= 4;
    }

    private boolean inInnerArea(int mx, int my, int rx, int ry, int rw, int rh) {
        return mx > rx + 4 && mx < rx + rw - 4 && my > ry + 4 && my < ry + rh - 4;
    }

    private boolean canMoveRegion(int rw, int rh) {
        int innerW = rw - 8;
        int innerH = rh - 8;
        return innerW >= 8 && innerH >= 8;
    }

    private boolean inPreview(int mx, int my) {
        return mx >= this.previewX && mx <= this.previewX + this.previewW && my >= this.previewY && my <= this.previewY + this.previewH;
    }

    private void setRegionProperties(int x, int y, int w, int h) {
        int screenWidth = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth();
        int screenHeight = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight();
        int newX = Math.max(0, Math.min(screenWidth, x));
        int newY = Math.max(0, Math.min(screenHeight, y));
        int newWidth = Math.max(1, Math.min(screenWidth - newX, w));
        int newHeight = Math.max(1, Math.min(screenHeight - newY, h));
        this.editorRegionX.setValue(newX, true);
        this.editorRegionY.setValue(newY, true);
        this.editorRegionWidth.setValue(newWidth, true);
        this.editorRegionHeight.setValue(newHeight, true);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean base = super.m_6375_(mouseX, mouseY, button);
        if (button != 0) {
            return base;
        }
        if (!this.inPreview((int)mouseX, (int)mouseY)) {
            return base;
        }
        DragHandle handle = this.handleAt((int)mouseX, (int)mouseY);
        if (handle == DragHandle.NONE) {
            return base;
        }
        this.activeHandle = handle;
        this.dragStartMouseX = (int)mouseX;
        this.dragStartMouseY = (int)mouseY;
        this.startRegionX = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionX();
        this.startRegionY = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionY();
        this.startRegionW = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionWidth();
        this.startRegionH = ((OverlayOptionsScreenRegion)this.optionsGroup).getRegionHeight();
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragDX, double dragDY) {
        if (this.activeHandle == DragHandle.NONE) {
            return super.m_7979_(mouseX, mouseY, button, dragDX, dragDY);
        }
        if (button != 0) {
            return super.m_7979_(mouseX, mouseY, button, dragDX, dragDY);
        }
        int dxPx = (int)Math.round((mouseX - (double)this.dragStartMouseX) / Math.max(1.0E-5, this.previewScale));
        int dyPx = (int)Math.round((mouseY - (double)this.dragStartMouseY) / Math.max(1.0E-5, this.previewScale));
        int newX = this.startRegionX;
        int newY = this.startRegionY;
        int newW = this.startRegionW;
        int newH = this.startRegionH;
        switch (this.activeHandle.ordinal()) {
            case 1: {
                newX = this.startRegionX + dxPx;
                newY = this.startRegionY + dyPx;
                newW = this.startRegionW - (newX - this.startRegionX);
                newH = this.startRegionH - (newY - this.startRegionY);
                break;
            }
            case 2: {
                newY = this.startRegionY + dyPx;
                newW = this.startRegionW + dxPx;
                newH = this.startRegionH - (newY - this.startRegionY);
                break;
            }
            case 3: {
                newX = this.startRegionX + dxPx;
                newW = this.startRegionW - (newX - this.startRegionX);
                newH = this.startRegionH + dyPx;
                break;
            }
            case 4: {
                newW = this.startRegionW + dxPx;
                newH = this.startRegionH + dyPx;
                break;
            }
            case 5: {
                newY = this.startRegionY + dyPx;
                newH = this.startRegionH - (newY - this.startRegionY);
                break;
            }
            case 6: {
                newH = this.startRegionH + dyPx;
                break;
            }
            case 7: {
                newX = this.startRegionX + dxPx;
                newW = this.startRegionW - (newX - this.startRegionX);
                break;
            }
            case 8: {
                newW = this.startRegionW + dxPx;
                break;
            }
            case 9: {
                int sw = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenWidth();
                int sh = ((OverlayOptionsScreenRegion)this.optionsGroup).getScreenHeight();
                int targetX = this.startRegionX + dxPx;
                int targetY = this.startRegionY + dyPx;
                targetX = Math.max(0, Math.min(sw - this.startRegionW, targetX));
                targetY = Math.max(0, Math.min(sh - this.startRegionH, targetY));
                newX = targetX;
                newY = targetY;
                newW = this.startRegionW;
                newH = this.startRegionH;
                break;
            }
        }
        this.setRegionProperties(newX, newY, newW, newH);
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean base = super.m_6348_(mouseX, mouseY, button);
        if (button == 0) {
            this.activeHandle = DragHandle.NONE;
        }
        return base;
    }

    private static enum DragHandle {
        NONE,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        MOVE_WHOLE;

    }
}

