/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.overlayoptions.pose;

import java.util.ArrayList;
import java.util.List;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoValueDrag;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import me.phoenixra.visor.api.client.gui.widgets.sets.ValueEditorFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class PoseEditorWidgetSet
extends DynamicWidgetSet {
    private OverlayOptionsPose optionsPose;
    private int startX;
    private int startY;
    private GuiTexture BACKGROUND = TexturesHelper.getColorGuiTexture(AtumColor.immutable(75, 75, 75, 255));
    private ButtonImaged positionButton;
    private ButtonImaged rotationButton;
    private ButtonImaged scaleButton;
    private ValueEditorFloat xPositionEditor;
    private ValueEditorFloat yPositionEditor;
    private ValueEditorFloat zPositionEditor;
    private ValueEditorFloat xRotationEditor;
    private ValueEditorFloat yRotationEditor;
    private ValueEditorFloat zRotationEditor;
    private ValueEditorFloat scaleEditor;
    private EditorType editorType = EditorType.POSITION;

    public PoseEditorWidgetSet(int startX, int startY, @NotNull OverlayOptionsPose optionsPose, @NotNull Runnable onWidgetsChanged) {
        super(onWidgetsChanged);
        this.optionsPose = optionsPose;
        this.startX = startX;
        this.startY = startY;
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> initWidgets() {
        this.positionButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 3, this.startY + 3).size(40, 13).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setHighlightThickness(0.9f).setText((Component)Component.m_237115_((String)"visor.overlay.options.pose.position")).setScaleText(true), it -> this.selectEditor(EditorType.POSITION));
        this.positionButton.setSelected(true);
        this.rotationButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 53, this.startY + 3).size(40, 13).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setText((Component)Component.m_237115_((String)"visor.overlay.options.pose.rotation")).setScaleText(true), it -> this.selectEditor(EditorType.ROTATION));
        this.scaleButton = new ButtonImaged(new WidgetInfoButtonImaged().pos(this.startX + 104, this.startY + 3).size(40, 13).setTexture(OptionTextures.BLACK_TEXTURE).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.SELECTED_HIGHLIGHT).setText((Component)Component.m_237115_((String)"visor.overlay.options.pose.scale")).setScaleText(true), it -> this.selectEditor(EditorType.SCALE));
        this.xPositionEditor = new ValueEditorFloat.Builder(this.optionsPose.getPositionOffset().x, this.startX + 24, this.startY + 31, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setPositionOffsetX).build();
        this.xPositionEditor.initWidgets();
        this.yPositionEditor = new ValueEditorFloat.Builder(this.optionsPose.getPositionOffset().y, this.startX + 24, this.startY + 55, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setPositionOffsetY).build();
        this.yPositionEditor.initWidgets();
        this.zPositionEditor = new ValueEditorFloat.Builder(this.optionsPose.getPositionOffset().z, this.startX + 24, this.startY + 79, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setPositionOffsetZ).build();
        this.zPositionEditor.initWidgets();
        this.xRotationEditor = new ValueEditorFloat.Builder(this.optionsPose.getRotationOffset().x, this.startX + 24, this.startY + 31, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setRotationOffsetX).build();
        this.xRotationEditor.initWidgets();
        this.yRotationEditor = new ValueEditorFloat.Builder(this.optionsPose.getRotationOffset().y, this.startX + 24, this.startY + 55, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setRotationOffsetY).build();
        this.yRotationEditor.initWidgets();
        this.zRotationEditor = new ValueEditorFloat.Builder(this.optionsPose.getRotationOffset().z, this.startX + 24, this.startY + 79, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setRotationOffsetZ).build();
        this.zRotationEditor.initWidgets();
        this.scaleEditor = new ValueEditorFloat.Builder(this.optionsPose.getScale(), this.startX + 24, this.startY + 55, 93, 13).editBox(new WidgetInfoEditBox().setTexture(OptionTextures.BLACK_TEXTURE)).leftArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_LEFT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).rightArrow(new WidgetInfoValueDrag().setTexture(OptionTextures.ARROW_BLACK_RIGHT).highlight(OptionTextures.HOVERED_HIGHLIGHT, OptionTextures.HOVERED_HIGHLIGHT).setStep(0.002)).setResponder(this.optionsPose::setScale).build();
        this.scaleEditor.initWidgets();
        return this.getWidgets();
    }

    @Override
    public <T extends GuiEventListener & Renderable> List<T> getWidgets() {
        ArrayList<ButtonImaged> widgets = new ArrayList<ButtonImaged>();
        widgets.add(this.positionButton);
        widgets.add(this.rotationButton);
        widgets.add(this.scaleButton);
        switch (this.editorType.ordinal()) {
            case 0: {
                widgets.addAll(this.xPositionEditor.getWidgets());
                widgets.addAll(this.yPositionEditor.getWidgets());
                widgets.addAll(this.zPositionEditor.getWidgets());
                break;
            }
            case 1: {
                widgets.addAll(this.xRotationEditor.getWidgets());
                widgets.addAll(this.yRotationEditor.getWidgets());
                widgets.addAll(this.zRotationEditor.getWidgets());
                break;
            }
            case 2: {
                widgets.addAll(this.scaleEditor.getWidgets());
            }
        }
        return widgets;
    }

    @Override
    public void onPreRender(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.BACKGROUND.blit(guiGraphics, this.startX, this.startY, 147, 101);
        if (this.editorType != EditorType.SCALE) {
            GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "X", AtumColor.LIGHT_GRAY.toInt(), this.startX + 24, this.startY + 23, 93, 8, true);
            GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "Y", AtumColor.LIGHT_GRAY.toInt(), this.startX + 24, this.startY + 47, 93, 8, true);
            GuiHelper.renderScalableText(guiGraphics, Minecraft.m_91087_().f_91062_, "Z", AtumColor.LIGHT_GRAY.toInt(), this.startX + 24, this.startY + 71, 93, 8, true);
        }
    }

    @Override
    public void onTick() {
        switch (this.editorType.ordinal()) {
            case 0: {
                this.xPositionEditor.onTick();
                this.yPositionEditor.onTick();
                this.zPositionEditor.onTick();
                break;
            }
            case 1: {
                this.xRotationEditor.onTick();
                this.yRotationEditor.onTick();
                this.zRotationEditor.onTick();
                break;
            }
            case 2: {
                this.scaleEditor.onTick();
            }
        }
    }

    public void selectEditor(@NotNull EditorType type) {
        switch (type.ordinal()) {
            case 0: {
                this.positionButton.setSelected(true);
                this.rotationButton.setSelected(false);
                this.scaleButton.setSelected(false);
                break;
            }
            case 1: {
                this.positionButton.setSelected(false);
                this.rotationButton.setSelected(true);
                this.scaleButton.setSelected(false);
                break;
            }
            case 2: {
                this.positionButton.setSelected(false);
                this.rotationButton.setSelected(false);
                this.scaleButton.setSelected(true);
            }
        }
        this.editorType = type;
        this.widgetsChanged();
    }

    public ValueEditorFloat getXPositionEditor() {
        return this.xPositionEditor;
    }

    public ValueEditorFloat getYPositionEditor() {
        return this.yPositionEditor;
    }

    public ValueEditorFloat getZPositionEditor() {
        return this.zPositionEditor;
    }

    public ValueEditorFloat getXRotationEditor() {
        return this.xRotationEditor;
    }

    public ValueEditorFloat getYRotationEditor() {
        return this.yRotationEditor;
    }

    public ValueEditorFloat getZRotationEditor() {
        return this.zRotationEditor;
    }

    public ValueEditorFloat getScaleEditor() {
        return this.scaleEditor;
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public static enum EditorType {
        POSITION,
        ROTATION,
        SCALE;


        public Component getName() {
            return Component.m_237115_((String)("visor.overlay.options.pose.enum.ModificationType." + this.name()));
        }
    }
}

