/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.gui.screens.settings.OptionWidgetEntry;
import me.phoenixra.visor.core.client.gui.screens.settings.OptionWidgetPosition;
import me.phoenixra.visor.core.client.settings.VROptionCategory;
import me.phoenixra.visor.core.client.settings.VROptionWidgetType;
import me.phoenixra.visor.core.client.utils.LangHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public abstract class VROptionsBaseScreen
extends Screen {
    protected final VROptionCategory category;
    protected final Screen previousScreen;
    private final Map<AbstractWidget, VROptionWidgetType> optionWidgets = new HashMap<AbstractWidget, VROptionWidgetType>();
    private int nextButtonIndex = 0;
    protected boolean initAgain;

    public VROptionsBaseScreen(VROptionCategory category, Screen previousScreen) {
        super((Component)Component.m_237115_((String)("visor.options." + category.getKey())));
        this.category = category;
        this.previousScreen = previousScreen;
    }

    protected abstract VROptionWidgetType[] getOptionTypes();

    protected abstract OptionWidgetEntry[] getOptionEntries();

    protected void m_7856_() {
        VROptionWidgetType[] types;
        OptionWidgetEntry[] entries = this.getOptionEntries();
        if (entries != null && entries.length > 0) {
            this.initOptionEntries(entries, true);
        }
        if ((types = this.getOptionTypes()) == null || types.length < 1) {
            return;
        }
        this.initOptionTypes(types, entries == null || entries.length < 1);
    }

    protected void initOptionEntries(OptionWidgetEntry[] entries, boolean clear) {
        if (clear) {
            this.m_169413_();
        }
        for (OptionWidgetEntry entry : entries) {
            AbstractWidget widget = entry.createWidget(this);
            this.m_142416_((GuiEventListener)widget);
            this.optionWidgets.put(widget, entry.getOptionType());
        }
        if (clear) {
            this.addDefaultButtons();
        }
    }

    protected void initOptionTypes(VROptionWidgetType[] options, boolean clear) {
        if (clear) {
            this.m_169413_();
            this.nextButtonIndex = 0;
        }
        ArrayList<OptionWidgetEntry> result = new ArrayList<OptionWidgetEntry>();
        int i = this.nextButtonIndex;
        for (VROptionWidgetType option : options) {
            OptionWidgetPosition optionPos;
            OptionWidgetPosition optionWidgetPosition = optionPos = i % 2 == 0 ? OptionWidgetPosition.LEFT : OptionWidgetPosition.RIGHT;
            if (option != VROptionWidgetType.EMPTY) {
                result.add(new OptionWidgetEntry(option, optionPos, (int)Math.floor((float)i / 2.0f), null));
            }
            ++i;
        }
        this.nextButtonIndex = i;
        this.initOptionEntries(result.toArray(new OptionWidgetEntry[0]), false);
        if (clear) {
            this.addDefaultButtons();
        }
    }

    protected void m_169413_() {
        super.m_169413_();
        this.optionWidgets.clear();
    }

    public VROptionWidgetType getTypeFromWidget(AbstractWidget widget) {
        return this.optionWidgets.get(widget);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.m_280273_(guiGraphics);
        if (this.initAgain) {
            this.initAgain = false;
            this.m_7856_();
        }
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        this.renderTooltip(guiGraphics, pMouseX, pMouseY);
    }

    private void renderTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        AbstractWidget hovered = null;
        VROptionWidgetType hoveredOption = null;
        for (GuiEventListener child : this.m_6702_()) {
            AbstractWidget widget;
            if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, pMouseX, pMouseY)) continue;
            hovered = widget;
            hoveredOption = this.getTypeFromWidget(widget);
            break;
        }
        if (hoveredOption == null) {
            return;
        }
        String tooltipLang = "visor.options." + hoveredOption.getKey() + ".tooltip";
        if (!LangHelper.existsLangKey(tooltipLang)) {
            return;
        }
        Object tooltip = LangHelper.getText(tooltipLang, new Object[]{null});
        if (((String)tooltip).isEmpty()) {
            return;
        }
        tooltip = ((String)tooltip).replace("\n", "\u00a7r\n");
        List textToCheckSize = this.f_96547_.m_92865_().m_92432_((String)tooltip, 310, Style.f_131099_);
        tooltip = (String)tooltip + " ".repeat((310 - (textToCheckSize.isEmpty() ? 0 : this.f_96547_.m_92852_((FormattedText)textToCheckSize.get(textToCheckSize.size() - 1)))) / this.f_96547_.m_92895_(" "));
        int n = hovered.m_252907_() + hovered.m_93694_();
        int n2 = textToCheckSize.size();
        Objects.requireNonNull(this.f_96547_);
        if (n + n2 * (9 + 1) + 14 < this.f_96544_) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308), this.f_96543_ / 2 - 166, hovered.m_252907_() + hovered.m_93694_() + 14);
        } else {
            List list = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)tooltip), 308);
            int n3 = this.f_96543_ / 2 - 166;
            int n4 = hovered.m_252907_();
            int n5 = textToCheckSize.size();
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280245_(this.f_96547_, list, n3, n4 - n5 * (9 + 1) + 9);
        }
    }

    protected void addDefaultButtons() {
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"gui.back"), button -> {
            ClientContext.settingsHandler.saveOptions();
            this.f_96541_.m_91152_(this.previousScreen);
        }).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"visor.button.load_defaults"), button -> {
            this.loadDefaultSettings();
            ClientContext.settingsHandler.saveOptions();
            this.initAgain = true;
        }).m_252794_(this.f_96543_ / 2 - 155, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
    }

    protected void loadDefaultSettings() {
        for (GuiEventListener child : this.m_6702_()) {
            AbstractWidget widget;
            VROptionWidgetType optionType;
            if (!(child instanceof AbstractWidget) || (optionType = this.getTypeFromWidget(widget = (AbstractWidget)child)) == null) continue;
            ClientContext.settingsHandler.loadDefaultOptionValue(optionType.getKey());
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            ClientContext.settingsHandler.saveOptions();
            this.f_96541_.m_91152_(this.previousScreen);
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private boolean isMouseOver(AbstractWidget widget, double x, double y) {
        return widget.f_93624_ && x >= (double)widget.m_252754_() && y >= (double)widget.m_252907_() && x < (double)(widget.m_252754_() + widget.m_5711_()) && y < (double)(widget.m_252907_() + widget.m_93694_());
    }
}

