/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.settings.categories.controls;

import java.util.List;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorAction;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.screens.settings.categories.controls.VRActionsScreen;
import me.phoenixra.visor.core.client.provider.openxr.XrInputHandler;
import me.phoenixra.visor.core.client.provider.openxr.XrProvider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindingPathScreen
extends Screen {
    private final VRActionsScreen parent;
    private final XRInteractionProfile profile;
    private final VisorAction action;
    private final BindingPath oldPath;
    private final boolean leftHanded;
    private PathList list;
    private Button confirmButton;
    private String selectedPath;
    private Checkbox touchFilter;
    private Checkbox forceFilter;
    private List<String> availablePaths;
    private Mode mode = Mode.PICK_PATH;
    private boolean capturing = false;
    private long captureStart = 0L;

    public BindingPathScreen(VRActionsScreen parent, XRInteractionProfile profile, VisorAction action, BindingPath currentPath, boolean leftHanded) {
        super((Component)action.getName().m_6881_().m_130946_("\u00a77 (").m_7220_((Component)Component.m_237115_((String)("visor.text." + (leftHanded ? "leftHanded" : "rightHanded"))).m_130946_("\u00a77)")));
        this.parent = parent;
        this.profile = profile;
        this.action = action;
        this.oldPath = currentPath;
        this.selectedPath = currentPath.getPath(leftHanded);
        this.leftHanded = leftHanded;
        this.availablePaths = action.getSelectableBindings(profile).stream().filter(it -> !it.contains(".touch") && !it.contains(".force")).toList();
    }

    protected void m_7856_() {
        this.m_169413_();
        XrProvider provider = (XrProvider)ClientContext.visor.getVrProvider();
        XrInputHandler inputHandler = provider.getInputHandler();
        inputHandler.setActionListener(null);
        int pad = 10;
        int titleY = 15;
        int btnH = 20;
        int modeBtnY = titleY + 10;
        int halfWidth = (this.f_96543_ - pad * 3) / 2;
        int listTop = modeBtnY + btnH + pad;
        int listBottom = this.f_96544_ - 50;
        Button pickBtn = Button.m_253074_((Component)Component.m_237115_((String)"visor.action_binds.pick_path"), b -> {
            this.mode = Mode.PICK_PATH;
            this.m_7856_();
        }).m_252987_(pad, modeBtnY, halfWidth, btnH).m_253136_();
        pickBtn.f_93623_ = this.mode != Mode.PICK_PATH;
        this.m_142416_((GuiEventListener)pickBtn);
        Button capBtn = Button.m_253074_((Component)Component.m_237115_((String)"visor.action_binds.capture_input"), b -> {
            this.mode = Mode.CAPTURE_INPUT;
            this.m_7856_();
        }).m_252987_(pad * 2 + halfWidth, modeBtnY, halfWidth, btnH).m_253136_();
        capBtn.f_93623_ = this.mode != Mode.CAPTURE_INPUT;
        this.m_142416_((GuiEventListener)capBtn);
        if (this.mode == Mode.PICK_PATH) {
            this.list = new PathList(this.f_96543_, this.f_96544_, listTop, listBottom, 20);
            this.availablePaths.forEach(this.list::addEntry);
            this.list.m_93496_(false);
            this.list.m_93488_(false);
            this.m_142416_((GuiEventListener)this.list);
        } else {
            int w = 100;
            int x = (this.f_96543_ - w) / 2;
            int y = listTop + (listBottom - listTop) / 2 - btnH / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.capturing ? "visor.action_binds.capture_input.listening" : "visor.button.start")), b -> {
                this.capturing = true;
                this.captureStart = System.currentTimeMillis();
                this.m_7856_();
                inputHandler.setActionListener(it -> {
                    if (inputHandler.getActionListener() == null) {
                        return;
                    }
                    if (this.captureStart + 500L > System.currentTimeMillis()) {
                        return;
                    }
                    if (!this.availablePaths.contains(it)) {
                        return;
                    }
                    this.selectedPath = it;
                    this.capturing = false;
                    this.m_7856_();
                    ClientContext.inputManager.setPausedActionsTicks(2L);
                });
            }).m_252987_(x, y, w, btnH).m_253136_());
        }
        int radioY = this.f_96544_ - 25;
        int gap = 20;
        MutableComponent touchLabel = Component.m_237115_((String)"visor.action_binds.touch_filter");
        MutableComponent forceLabel = Component.m_237115_((String)"visor.action_binds.force_filter");
        int touchTextW = this.f_96547_.m_92852_((FormattedText)touchLabel);
        int forceTextW = this.f_96547_.m_92852_((FormattedText)forceLabel);
        int touchW = touchTextW + 12 + 4;
        int forceW = forceTextW + 12 + 4;
        int totalW = touchW + forceW + gap;
        int startX = (this.f_96543_ - totalW) / 2;
        this.touchFilter = new FilterCheckBox(startX, radioY, touchW, btnH, (Component)touchLabel, this.touchFilter != null && this.touchFilter.m_93840_());
        this.m_142416_((GuiEventListener)this.touchFilter);
        this.forceFilter = new FilterCheckBox(startX + touchW + gap, radioY, forceW, btnH, (Component)forceLabel, this.forceFilter != null && this.forceFilter.m_93840_());
        this.m_142416_((GuiEventListener)this.forceFilter);
        int footerY = this.f_96544_ - 27;
        int btnW = 80;
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"visor.button.confirm"), b -> {
            if (!this.selectedPath.isEmpty()) {
                BindingPath newBinding = new BindingPath(this.oldPath.getRightHandedPath(), this.oldPath.getLeftHandedPath());
                newBinding.setPath(this.selectedPath, this.leftHanded);
                this.parent.getNewBinds().put(this.action, newBinding);
                VisorClientImpl.MC.m_91152_((Screen)this.parent);
            }
        }).m_252987_(pad, footerY, btnW, btnH).m_253136_();
        this.confirmButton.f_93623_ = !this.oldPath.getPath(this.leftHanded).equals(this.selectedPath);
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> VisorClientImpl.MC.m_91152_((Screen)this.parent)).m_252987_(this.f_96543_ - pad - btnW, footerY, btnW, btnH).m_253136_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            VisorClientImpl.MC.m_91152_((Screen)this.parent);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        if (this.mode == Mode.CAPTURE_INPUT) {
            int pad = 10;
            int titleY = 15;
            int btnH = 20;
            int modeBtnY = titleY + 10;
            int listTop = modeBtnY + btnH + pad;
            int listBottom = this.f_96544_ - 50;
            int y = listTop + (listBottom - listTop) / 2 - btnH / 2 - 40;
            gui.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"visor.action_binds.capture_input.guide"), this.f_96543_ / 2, y, 0xFFFFFF);
        }
        gui.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"visor.action_binds.selected_path", (Object[])new Object[]{this.selectedPath}), this.f_96543_ / 2, this.f_96544_ - 40, 0xAAAAAA);
        if (this.mode == Mode.PICK_PATH) {
            this.list.m_7733_(gui);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    private static enum Mode {
        PICK_PATH,
        CAPTURE_INPUT;

    }

    private class PathList
    extends ObjectSelectionList<Entry> {
        public PathList(int width, int height, int top, int bottom, int itemHeight) {
            super(VisorClientImpl.MC, width, height, top, bottom, itemHeight);
        }

        protected void m_7733_(GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, AtumColor.BLACK.withAlpha(0.5f).toInt());
        }

        protected int m_5756_() {
            return this.f_93388_ - 6;
        }

        public int m_5759_() {
            return this.f_93388_ - 40;
        }

        public void addEntry(String path) {
            Entry entry = new Entry(path);
            this.m_7085_((AbstractSelectionList.Entry)entry);
            if (BindingPathScreen.this.selectedPath.equals(path)) {
                this.m_7522_((GuiEventListener)entry);
            }
        }

        public void setSelected(@Nullable Entry entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (entry != null) {
                BindingPathScreen.this.selectedPath = entry.path;
                if (BindingPathScreen.this.confirmButton != null) {
                    BindingPathScreen.this.confirmButton.f_93623_ = !BindingPathScreen.this.oldPath.getPath(BindingPathScreen.this.leftHanded).equals(BindingPathScreen.this.selectedPath);
                }
            }
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final String path;

            public Entry(String path) {
                this.path = path;
            }

            public void m_6311_(GuiGraphics gui, int index, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                gui.m_280488_(BindingPathScreen.this.f_96547_, this.path, left + 5, top + 2, hovered ? 0xFFFFA0 : 0xFFFFFF);
            }

            public boolean m_6375_(double d, double e, int i) {
                return this.m_5953_(d, e);
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    private class FilterCheckBox
    extends Checkbox {
        public FilterCheckBox(int i, int j, int k, int l, Component component, boolean bl) {
            super(i, j, k, l, component, bl);
        }

        public void m_5691_() {
            super.m_5691_();
            BindingPathScreen.this.availablePaths = BindingPathScreen.this.action.getSelectableBindings(BindingPathScreen.this.profile).stream().filter(it -> !(!BindingPathScreen.this.touchFilter.m_93840_() && it.contains(".touch") || !BindingPathScreen.this.forceFilter.m_93840_() && it.contains(".force"))).toList();
            BindingPathScreen.this.m_7856_();
        }
    }
}

