/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.gui.screens.settings.categories.controls;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorAction;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.screens.settings.categories.controls.BindingPathScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class VRActionsScreen
extends Screen {
    private static final int MARGIN = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int HEADER_H = 20;
    private static final int FOOTER_H = 45;
    private static final int ENTRY_H = 30;
    private static final int GAP = 5;
    private static final float ACTION_RATIO = 0.3f;
    private static final float BIND_RATIO = 0.35f;
    private final Screen previousScreen;
    private final VisorActionSet actionSet;
    private final XRInteractionProfile activeProfile;
    private XRInteractionProfile currentProfile;
    private final Map<XRInteractionProfile, Map<VisorAction, BindingPath>> newBindings;
    private Button applyButton;
    private ActionList bindingList;
    private double scrollSaved = -1.0;

    protected VRActionsScreen(VisorActionSet actionSet, Screen previous) {
        super(actionSet.getName());
        this.previousScreen = previous;
        this.actionSet = actionSet;
        this.activeProfile = ClientContext.inputManager.getActiveProfile();
        this.currentProfile = this.activeProfile != null ? this.activeProfile : XRInteractionProfile.VALVE_INDEX;
        this.newBindings = new EnumMap<XRInteractionProfile, Map<VisorAction, BindingPath>>(XRInteractionProfile.class);
        this.resetNewBinds();
    }

    protected void m_7856_() {
        this.m_169413_();
        Objects.requireNonNull(this.f_96547_);
        int selY = 20 + 9 + 5;
        int headerY = selY + 20 + 5;
        int listTop = headerY + 20 + 5;
        int listBottom = this.f_96544_ - 20 - 45;
        this.bindingList = new ActionList(VisorClientImpl.MC, this.f_96543_, listBottom - listTop, listTop, listBottom, 30);
        this.bindingList.m_93488_(false);
        this.bindingList.m_93496_(false);
        this.bindingList.refreshEntries();
        this.m_142416_((GuiEventListener)this.bindingList);
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(p -> Component.m_237113_((String)("\u00a7" + (this.activeProfile == this.currentProfile ? "a" + p.name() : "f" + p.name())))).m_232502_(this.getProfiles()).m_168948_((Object)this.currentProfile).m_168936_(15, headerY - 5 - 20, 150, 20, (Component)Component.m_237115_((String)"visor.button.input_profile"), (btn, prof) -> {
            this.currentProfile = prof;
            this.m_7856_();
        }));
        int buttonY = listBottom + 5;
        int totalWidth = 260;
        int startX = (this.f_96543_ - totalWidth) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"visor.button.load_defaults"), b -> {
            this.actionSet.loadDefaults(this.currentProfile);
            this.resetNewBinds();
            this.m_7856_();
        }).m_253046_(120, 20).m_252794_(startX, buttonY).m_253136_());
        this.applyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"visor.button.apply_changes"), b -> {
            this.getNewBinds().forEach((a, p) -> a.setBinding(this.currentProfile, (BindingPath)p));
            this.actionSet.saveBindings();
            this.m_7856_();
        }).m_253046_(120, 20).m_252794_(startX + 120 + 20, buttonY).m_253136_());
        this.updateApplyButton();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> {
            ClientContext.settingsHandler.saveOptions();
            VisorClientImpl.MC.m_91152_(this.previousScreen);
        }).m_253046_(80, 20).m_252794_(this.f_96543_ / 2 - 40, this.f_96544_ - 20).m_253136_());
    }

    private List<XRInteractionProfile> getProfiles() {
        return XRInteractionProfile.getSupported((OpenXRProvider)ClientContext.visor.getVrProvider());
    }

    private void updateApplyButton() {
        boolean hasChanges = this.getNewBinds().keySet().stream().anyMatch(a -> !Objects.equals(a.getBindingOrEmpty(this.currentProfile), this.getNewBinds().get(a)));
        boolean collision = this.hasBindingCollision();
        this.applyButton.f_93623_ = hasChanges && !collision;
    }

    private boolean hasCollision(String path, boolean leftHanded) {
        Map<String, Long> counts = this.getNewBinds().values().stream().map(b -> b.getPath(leftHanded)).filter(p -> p.equals(path)).filter(p -> !p.startsWith("vec2")).collect(Collectors.groupingBy(p -> p, Collectors.counting()));
        return counts.values().stream().anyMatch(c -> c > 1L);
    }

    private boolean hasBindingCollision() {
        for (boolean left : new boolean[]{false, true}) {
            Map<String, Long> counts = this.getNewBinds().values().stream().map(b -> b.getPath(left)).filter(p -> !p.equals("null")).filter(p -> !p.startsWith("vec2")).collect(Collectors.groupingBy(p -> p, Collectors.counting()));
            if (!counts.values().stream().anyMatch(c -> c > 1L)) continue;
            return true;
        }
        return false;
    }

    private void resetNewBinds() {
        this.newBindings.clear();
        for (XRInteractionProfile profile : XRInteractionProfile.values()) {
            HashMap map = new HashMap();
            this.actionSet.getActions().forEach(a -> map.put(a, a.getBindingOrEmpty(profile)));
            this.newBindings.put(profile, map);
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollSaved != -1.0) {
            this.bindingList.m_93410_(this.scrollSaved);
            this.scrollSaved = -1.0;
        }
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        Objects.requireNonNull(this.f_96547_);
        int selY = 20 + 9 + 5;
        int headerY = selY + 20 + 5;
        int listBottom = this.f_96544_ - 20 - 45;
        int listLeft = 20;
        int listWidth = this.f_96543_ - 40;
        guiGraphics.m_280509_(listLeft - 5, headerY - 5, listLeft + listWidth + 5, listBottom + 5, Integer.MIN_VALUE);
        AtumColorImmutable activeColor = AtumColor.GREEN.blend(AtumColor.BLACK, 0.2f);
        boolean leftHanded = ClientContext.inputManager.isLeftHanded();
        int actionColumn = (int)((float)listWidth * 0.3f);
        int bindColumn = (int)((float)listWidth * 0.35f);
        Objects.requireNonNull(this.f_96547_);
        int headerTextY = headerY + (20 - 9) / 2;
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"visor.options.controls.action"), listLeft + 5, headerTextY, AtumColor.GRAY.toInt());
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"visor.options.controls.left_handed"), listLeft + actionColumn + 5, headerTextY, !leftHanded ? AtumColor.GRAY.toInt() : activeColor.toInt());
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"visor.options.controls.right_handed"), listLeft + actionColumn + bindColumn + 5, headerTextY, !leftHanded ? activeColor.toInt() : AtumColor.GRAY.toInt());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int key, int sc, int mods) {
        if (key == 256) {
            VisorClientImpl.MC.m_91152_(this.previousScreen);
            return true;
        }
        return super.m_7933_(key, sc, mods);
    }

    public Map<VisorAction, BindingPath> getNewBinds() {
        return this.newBindings.get((Object)this.currentProfile);
    }

    public ActionList getBindingList() {
        return this.bindingList;
    }

    public class ActionList
    extends ContainerObjectSelectionList<BindingEntry> {
        public ActionList(Minecraft mc, int w, int h, int top, int bottom, int itemH) {
            super(mc, w, h, top, bottom, itemH);
        }

        public void refreshEntries() {
            this.m_93516_();
            VRActionsScreen.this.actionSet.getActions().forEach(a -> this.m_7085_((AbstractSelectionList.Entry)new BindingEntry((VisorAction)a)));
        }

        protected int m_5756_() {
            return this.f_93388_ - 20 - 3;
        }

        public int m_5759_() {
            return this.f_93388_ - 40;
        }
    }

    private class BindingEntry
    extends ContainerObjectSelectionList.Entry<BindingEntry> {
        private final VisorAction action;
        private final Button leftButton;
        private final Button rightButton;

        public BindingEntry(VisorAction action) {
            this.action = action;
            this.leftButton = Button.m_253074_((Component)Component.m_237113_((String)""), b -> {
                VRActionsScreen.this.scrollSaved = VRActionsScreen.this.bindingList.m_93517_();
                VisorClientImpl.MC.m_91152_((Screen)new BindingPathScreen(VRActionsScreen.this, VRActionsScreen.this.currentProfile, action, VRActionsScreen.this.getNewBinds().get(action), true));
            }).m_253046_(0, 20).m_253136_();
            this.rightButton = Button.m_253074_((Component)Component.m_237113_((String)""), b -> {
                VRActionsScreen.this.scrollSaved = VRActionsScreen.this.bindingList.m_93517_();
                VisorClientImpl.MC.m_91152_((Screen)new BindingPathScreen(VRActionsScreen.this, VRActionsScreen.this.currentProfile, action, VRActionsScreen.this.getNewBinds().get(action), false));
            }).m_253046_(0, 20).m_253136_();
        }

        public void m_6311_(GuiGraphics guiGraphics, int idx, int y, int x, int w, int h, int mouseX, int mouseY, boolean hover, float pt) {
            if (hover) {
                guiGraphics.m_280509_(x, y, x + w, y + h, 0x30FFFFFF);
            }
            int actionColumn = (int)((float)w * 0.3f) - 3;
            int bindColumn = (int)((float)w * 0.35f);
            String leftPath = VRActionsScreen.this.getNewBinds().get(this.action).getPath(true);
            String rightPath = VRActionsScreen.this.getNewBinds().get(this.action).getPath(false);
            Font font = VRActionsScreen.this.f_96547_;
            Component component = this.action.getName();
            Objects.requireNonNull(VRActionsScreen.this.f_96547_);
            guiGraphics.m_280614_(font, component, x + 5 - 3, y + (h - 9) / 2, 0xFFFFFF, false);
            if (VRActionsScreen.this.hasCollision(leftPath, true)) {
                this.leftButton.m_93666_((Component)Component.m_237113_((String)("\u00a7c" + leftPath)));
            } else {
                this.leftButton.m_93666_((Component)Component.m_237113_((String)leftPath));
            }
            this.leftButton.m_93674_(bindColumn - 10);
            this.leftButton.m_252865_(x + actionColumn + 5);
            this.leftButton.m_253211_(y + (h - 20) / 2);
            this.leftButton.m_88315_(guiGraphics, mouseX, mouseY, pt);
            if (VRActionsScreen.this.hasCollision(rightPath, false)) {
                this.rightButton.m_93666_((Component)Component.m_237113_((String)("\u00a7c" + rightPath)));
            } else {
                this.rightButton.m_93666_((Component)Component.m_237113_((String)rightPath));
            }
            this.rightButton.m_93674_(bindColumn - 10);
            this.rightButton.m_252865_(x + actionColumn + bindColumn + 5);
            this.rightButton.m_253211_(this.leftButton.m_252907_());
            this.rightButton.m_88315_(guiGraphics, mouseX, mouseY, pt);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.leftButton, this.rightButton);
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }
}

