/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.input.action.RegisterActionSet;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSetRegistry
implements VisorRegistry<VisorActionSet> {
    private static final String REGISTRY_NAME = "Visor Action Sets";
    private static final String ELEMENT_NAME = "VisorActionSet";
    private static final String ANNOTATION_NAME = "@RegisterActionSet";
    private final Map<String, VisorActionSet> elementsMap = new LinkedHashMap<String, VisorActionSet>();
    private final List<VisorActionSet> sortedElements = new ArrayList<VisorActionSet>();
    private final Collection<VisorActionSet> allElements = Collections.unmodifiableCollection(this.elementsMap.values());

    public List<VisorActionSet> getSortedElements() {
        return Collections.unmodifiableList(this.sortedElements);
    }

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterActionSet.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VisorActionSet.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(VisorAddon.class);
                VisorActionSet element = (VisorActionSet)constructor.newInstance(addon);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
    }

    @Override
    public void registerElement(@NotNull VisorActionSet element) {
        VisorActionSet previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
            this.sortedElements.remove(previous);
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
        this.sortedElements.add(element);
        Collections.sort(this.sortedElements);
    }

    @Override
    @Nullable
    public VisorActionSet unregisterElement(@NotNull String id) {
        VisorActionSet removed = this.elementsMap.remove(id);
        if (removed != null) {
            this.sortedElements.remove(removed);
            Collections.sort(this.sortedElements);
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VisorActionSet getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    @Override
    public Collection<VisorActionSet> getAllElements() {
        return this.allElements;
    }
}

