/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input;

import java.util.List;
import me.phoenixra.atumvr.api.input.device.VRDeviceController;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.profileset.ProfileSetHolder;
import me.phoenixra.visor.api.client.input.InputManager;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.input.ActionSetRegistry;
import me.phoenixra.visor.core.client.provider.openxr.XrProvider;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputManagerImpl
implements InputManager {
    private final ActionSetRegistry actionSetRegistry = new ActionSetRegistry();
    private VisorActionSet activeSet;
    private long pausedActionsTicks = -1L;

    public void preTick() {
        boolean canUpdate;
        VisorActionSet newActiveSet = null;
        for (VisorActionSet entry : this.actionSetRegistry.getSortedElements()) {
            if (!entry.isEnabledAndCanActivate()) continue;
            newActiveSet = entry;
            break;
        }
        if (this.activeSet != null && this.activeSet != newActiveSet) {
            this.activeSet.clear();
        }
        this.activeSet = newActiveSet;
        XrProvider provider = (XrProvider)ClientContext.visor.getVrProvider();
        boolean bl = canUpdate = this.pausedActionsTicks <= 0L && provider.getInputHandler().getActionListener() == null;
        if (canUpdate && this.activeSet != null) {
            this.activeSet.preTick();
        }
        if (this.pausedActionsTicks > 0L) {
            --this.pausedActionsTicks;
        }
    }

    public void update() {
        boolean canUpdate;
        if (this.activeSet == null) {
            return;
        }
        XrProvider provider = (XrProvider)ClientContext.visor.getVrProvider();
        OpenXRProfileSet currentProfile = provider.getInputHandler().getProfileSetHolder().getActiveProfileSet();
        boolean bl = canUpdate = this.pausedActionsTicks <= 0L && provider.getInputHandler().getActionListener() == null;
        if (!canUpdate || currentProfile == null) {
            return;
        }
        this.activeSet.updateState(currentProfile, this.isLeftHanded());
    }

    @Override
    public boolean isLeftHanded() {
        return VRClientSettings.isLeftHanded();
    }

    @Override
    @NotNull
    public ProfileSetHolder getProfileSetHolder() {
        return ((XrProvider)ClientContext.visor.getVrProvider()).getInputHandler().getProfileSetHolder();
    }

    @Override
    @Nullable
    public XRInteractionProfile getActiveProfile() {
        XrProvider provider = (XrProvider)ClientContext.visor.getVrProvider();
        OpenXRProfileSet profileSet = provider.getInputHandler().getProfileSetHolder().getActiveProfileSet();
        if (profileSet == null) {
            return null;
        }
        return profileSet.getType();
    }

    @Override
    public void triggerHapticPulse(@NotNull ControllerHand hand, float frequency, float amplitude, long durationNanoSec) {
        if (VisorState.getState().isNotActive()) {
            return;
        }
        String controllerId = VRDeviceController.getDefaultId(hand.getType(this.isLeftHanded()));
        ClientContext.visor.getVrProvider().getInputHandler().getDevice(controllerId, VRDeviceController.class).triggerHapticPulse(frequency, amplitude, durationNanoSec);
    }

    public List<VisorRegistry<?>> getElementRegistries() {
        return List.of(this.actionSetRegistry);
    }

    public ActionSetRegistry getActionSetRegistry() {
        return this.actionSetRegistry;
    }

    @Override
    public VisorActionSet getActiveSet() {
        return this.activeSet;
    }

    public void setPausedActionsTicks(long pausedActionsTicks) {
        this.pausedActionsTicks = pausedActionsTicks;
    }
}

