/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.actions;

import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.input.InputHelper;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionButton;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import org.jetbrains.annotations.NotNull;

public class ActionRightMouse
extends VisorActionButton {
    public static final String ID = "mouse_right";
    private static final int BUTTON_TYPE = 1;
    private VROverlay previousFocus;
    private boolean wasPressed;

    public ActionRightMouse(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    public void preTick() {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null && this.previousFocus == null && InputHelper.isMousePressed(1)) {
            InputHelper.releaseMouse(1);
        } else if (focusedOverlay == null && this.previousFocus != null && this.wasPressed) {
            this.previousFocus.m_6348_(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 1);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        } else if (focusedOverlay != null && this.previousFocus != null && focusedOverlay != this.previousFocus && this.wasPressed) {
            this.previousFocus.m_6348_(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 1);
            VROverlay vROverlay = this.previousFocus;
            if (vROverlay instanceof VROverlayScreen) {
                VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                overlayScreen.finishDragMouse();
            }
            this.wasPressed = false;
        }
        this.previousFocus = focusedOverlay;
        super.preTick();
    }

    @Override
    protected void onPress() {
        this.process(true);
    }

    @Override
    protected void onRelease() {
        this.process(false);
    }

    @Override
    protected void onClear() {
        InputHelper.releaseMouse(1);
        if (this.previousFocus != null && this.wasPressed) {
            this.previousFocus.m_6348_(this.previousFocus.getMouseX(), this.previousFocus.getMouseY(), 1);
        }
        this.previousFocus = null;
        this.wasPressed = false;
    }

    private void process(boolean press) {
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay != null) {
            this.processOverlay(focusedOverlay, press);
            return;
        }
        if (VisorClientImpl.MC.f_91080_ != null) {
            return;
        }
        if (VisorClientImpl.MC.f_91074_ != null) {
            this.processGame(press);
        }
    }

    private void processOverlay(VROverlay overlay, boolean press) {
        if (press) {
            overlay.m_6375_(overlay.getMouseX(), overlay.getMouseY(), 1);
            this.wasPressed = true;
        } else if (this.wasPressed) {
            overlay.m_6348_(overlay.getMouseX(), overlay.getMouseY(), 1);
            this.wasPressed = false;
        }
    }

    private void processGame(boolean press) {
        if (press) {
            InputHelper.pressMouse(1);
        } else {
            InputHelper.releaseMouse(1);
        }
    }

    @Override
    protected VRActionDataButton getButtonData(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        boolean mainHand;
        if (!ClientContext.cursorHandler.isCursorHandFocused() && VisorClientImpl.MC.f_91080_ == null && VisorClientImpl.MC.f_91074_ != null) {
            mainHand = ClientContext.player.getActiveHand() == ControllerHand.MAIN;
        } else {
            ControllerHand cursorHand = ClientContext.cursorHandler.getCursorHand();
            boolean bl = mainHand = cursorHand == ControllerHand.MAIN;
        }
        if (leftHanded) {
            return bindingPath.getButton(currentProfile, mainHand);
        }
        return bindingPath.getButton(currentProfile, !mainHand);
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("button.b.right", "button.b.left"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("button.a", "button.x"));
    }
}

