/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.actions;

import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionVec2;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class ActionScrollMouse
extends VisorActionVec2 {
    public static final String ID = "mouse_scroll";
    private double deltaSaved;

    public ActionScrollMouse(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    public void preTick() {
        this.onStateChanged(this.getState());
    }

    @Override
    protected void onStateChanged(Vector2f newState) {
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.INPUT_MOUSE)) {
            return;
        }
        float scrollPos = newState.y;
        if (Math.abs(scrollPos) < 1.0f) {
            if (this.deltaSaved > 0.0 && scrollPos < 0.0f || this.deltaSaved < 0.0 && scrollPos > 0.0f) {
                this.deltaSaved = 0.0;
            }
            this.deltaSaved += (double)scrollPos;
            if (Math.abs(this.deltaSaved) < 1.0) {
                return;
            }
            this.doScroll(this.deltaSaved);
            this.deltaSaved = 0.0;
            return;
        }
        this.deltaSaved = 0.0;
        this.doScroll(scrollPos);
    }

    private void doScroll(double scrollOffset) {
        double wheelSensitivity;
        VROverlay focusedOverlay = ClientContext.cursorHandler.getFocusedOverlay();
        if (focusedOverlay == null) {
            return;
        }
        boolean discrete = (Boolean)VisorClientImpl.MC.f_91066_.m_231821_().m_231551_();
        double scrollDelta = (discrete ? Math.signum(scrollOffset) : scrollOffset) * (wheelSensitivity = ((Double)VisorClientImpl.MC.f_91066_.m_232122_().m_231551_()).doubleValue());
        if (scrollDelta == 0.0) {
            return;
        }
        focusedOverlay.m_6050_(focusedOverlay.getMouseX(), focusedOverlay.getMouseY(), scrollDelta);
    }

    @Override
    protected VRActionDataVec2 getVec2Data(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        boolean mainHand;
        if (!ClientContext.cursorHandler.isCursorHandFocused() && VisorClientImpl.MC.f_91080_ == null && VisorClientImpl.MC.f_91074_ != null) {
            mainHand = ClientContext.player.getActiveHand() == ControllerHand.MAIN;
        } else {
            ControllerHand cursorHand = ClientContext.cursorHandler.getCursorHand();
            boolean bl = mainHand = cursorHand == ControllerHand.MAIN;
        }
        if (leftHanded) {
            return bindingPath.getVec2(currentProfile, mainHand);
        }
        return bindingPath.getVec2(currentProfile, !mainHand);
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("vec2.thumbstick.right", "vec2.thumbstick.left"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("vec2.thumbstick.right", "vec2.thumbstick.left"));
    }
}

