/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.input.actionset.game;

import java.util.Map;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import me.phoenixra.visor.api.client.input.action.framework.VisorActionVec2;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class GameActionInputMovement
extends VisorActionVec2 {
    public static final String ID = "input_movement";
    private boolean wasMovement;
    private boolean wasAutoSprinting;

    public GameActionInputMovement(VisorActionSet actionSet) {
        super(actionSet, ID);
    }

    @Override
    public void preTick() {
        super.preTick();
        if (ClientContext.cursorHandler.isHandFocused(ControllerHand.OFFHAND)) {
            this.onClear();
            return;
        }
        Vector2f rawMove = this.getState();
        Vector2f movement = ClientContext.player.getMovement();
        boolean climbing = false;
        boolean moving = ClientContext.player.isMoving();
        float forward = 0.0f;
        if (!climbing) {
            movement.zero();
            movement.x = this.applyDeadzone(rawMove.x, 0.05f);
            movement.y = this.applyDeadzone(rawMove.y, 0.05f);
            moving = movement.x != 0.0f || movement.y != 0.0f;
            forward = movement.y;
            movement.set((Vector2fc)this.toDigital(movement, 0.5f));
            if (moving) {
                ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92085_, movement.y > 0.0f);
                ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92087_, movement.y < 0.0f);
                ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92088_, movement.x > 0.0f);
                ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92086_, movement.x < 0.0f);
                if (!VisorClientImpl.MC.f_91074_.m_108635_()) {
                    if (forward >= VRClientSettings.getSprintThreshold()) {
                        VisorClientImpl.MC.f_91074_.m_6858_(true);
                        this.wasAutoSprinting = true;
                        movement.y = 1.0f;
                    } else if (movement.y > 0.0f) {
                        movement.y /= VRClientSettings.getSprintThreshold();
                    }
                }
            }
        }
        if (!moving && this.wasMovement) {
            ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92085_, false);
            ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92087_, false);
            ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92086_, false);
            ClientUtils.updateKeyMappingState(VisorClientImpl.MC.f_91066_.f_92088_, false);
        }
        this.wasMovement = moving;
        ClientContext.player.setMoving(moving);
        if (this.wasAutoSprinting && forward < VRClientSettings.getSprintThreshold()) {
            VisorClientImpl.MC.f_91074_.m_6858_(false);
            this.wasAutoSprinting = false;
        }
    }

    @Override
    protected void onStateChanged(Vector2f newState) {
    }

    @Override
    protected void onClear() {
        Vector2f input = ClientContext.player.getMovement();
        input.x = 0.0f;
        input.y = 0.0f;
        ClientContext.player.setMoving(false);
    }

    @Override
    protected Map<XRInteractionProfile, BindingPath> loadDefaults() {
        return Map.of(XRInteractionProfile.VALVE_INDEX, new BindingPath("vec2.thumbstick.left", "vec2.thumbstick.right"), XRInteractionProfile.OCULUS_TOUCH, new BindingPath("vec2.thumbstick.left", "vec2.thumbstick.right"));
    }

    private float applyDeadzone(float axis, float deadzone) {
        if (Math.abs(axis) > deadzone) {
            float scalar = 1.0f / (1.0f - deadzone);
            return (Math.abs(axis) - deadzone) * scalar * Math.signum(axis);
        }
        return 0.0f;
    }

    private Vector2f toDigital(Vector2f value, float deadzone) {
        Vector2f digital = new Vector2f();
        if (value.length() > deadzone) {
            float angle = (float)Math.atan2(value.x, value.y);
            float angleAbs = Math.abs(angle);
            float PI_8TH = 0.3926991f;
            if (angleAbs >= 0.3926991f && angleAbs <= 2.7488937f) {
                digital.x = Math.signum(angle);
            }
            if (angleAbs < 1.1780972f) {
                digital.y = 1.0f;
            } else if (angleAbs > 1.9634955f) {
                digital.y = -1.0f;
            }
        }
        return digital;
    }
}

