/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.network;

import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.common.network.buffer.PlayerPoseBuffer;
import me.phoenixra.visor.api.common.network.toserver.VisorPayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.HeightPayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.VRPosePayloadToServer;
import me.phoenixra.visor.api.common.network.toserver.vrstate.WorldScalePayloadToServer;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ClientNetworking {
    public static boolean SERVER_HAS_VISOR = false;
    private static float heightLastSent = 0.0f;
    private static float worldScaleLastSent = 1.0f;

    public static void sendVRPacket(VisorPayloadToServer payload) {
        if (VisorClientImpl.MC.m_91403_() == null) {
            return;
        }
        if (!SERVER_HAS_VISOR) {
            return;
        }
        VisorClientImpl.MC.m_91403_().m_104955_(ClientNetworking.createVRPacket(payload));
    }

    public static Packet<?> createVRPacket(VisorPayloadToServer payload) {
        return ModLoader.get().createPacketToServer(payload);
    }

    public static void sendLookPacket(Player player, Vec3 view) {
        float pitch = (float)Math.toDegrees(Math.asin(-view.f_82480_ / view.m_82553_()));
        float yaw = (float)Math.toDegrees(Mth.m_14136_((double)(-view.f_82479_), (double)view.f_82481_));
        ((LocalPlayer)player).f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(yaw, pitch, player.m_20096_()));
    }

    public static void sendVRPlayerPose() {
        float worldScale;
        ClientPacketListener connection = VisorClientImpl.MC.m_91403_();
        if (connection == null) {
            return;
        }
        float playerHeight = VRClientSettings.getPlayerHeight();
        if (playerHeight != heightLastSent) {
            ClientNetworking.sendVRPacket(new HeightPayloadToServer(playerHeight / 1.52f));
            heightLastSent = playerHeight;
        }
        if ((worldScale = ClientContext.player.getWorldScale()) != worldScaleLastSent) {
            ClientNetworking.sendVRPacket(new WorldScalePayloadToServer(worldScale));
            worldScaleLastSent = worldScale;
        }
        PlayerPoseBuffer vrPlayerState = PlayerPoseBuffer.create(ClientContext.player, VRClientSettings.isLeftHanded());
        ClientNetworking.sendVRPacket(new VRPosePayloadToServer(vrPlayerState));
        VRRemotePlayers.getInstance().applyPlayer(VisorClientImpl.MC.f_91074_.m_20148_(), vrPlayerState, worldScale, playerHeight / 1.52f, true);
    }

    public static void resetServerSettings() {
        heightLastSent = 0.0f;
        VRRemotePlayers.clear();
    }
}

