/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.network;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.network.toclient.HandshakePayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.SettingsPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.UnknownPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.vrstate.VRActivePayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.vrstate.VRStatePayloadToClient;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.network.ClientNetworking;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.server.ServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ClientPacketHandler {
    public static boolean displayedServerStatusMsg = false;

    public static void handlePacket(VisorPayloadToClient payloadClient) {
        if (payloadClient instanceof UnknownPayloadToClient) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        switch (payloadClient.payloadId()) {
            case HANDSHAKE: {
                HandshakePayloadToClient payload = (HandshakePayloadToClient)payloadClient;
                if (!displayedServerStatusMsg && !Minecraft.m_91087_().m_91090_()) {
                    displayedServerStatusMsg = true;
                    mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"visor.messages.server_mod", (Object[])new Object[]{payload.networkVersion()}));
                }
                if (VisorState.getState().isActive() && VRClientSettings.getPlayerHeight() == -1.0f) {
                    mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"visor.messages.calibrate_height"));
                }
                ClientNetworking.SERVER_HAS_VISOR = true;
                break;
            }
            case SETTINGS: {
                SettingsPayloadToClient payload = (SettingsPayloadToClient)payloadClient;
                ServerConfig.updateServerSettings(VisorAPI.client().getConfigManager(), payload.config());
                break;
            }
            case PLAYER_VR_ACTIVE: {
                VRActivePayloadToClient payload = (VRActivePayloadToClient)payloadClient;
                if (payload.hasVr()) break;
                VRRemotePlayers.getInstance().removePlayer(payload.playerUUID());
                break;
            }
            case PLAYER_VR_STATE: {
                VRStatePayloadToClient payload = (VRStatePayloadToClient)payloadClient;
                VRRemotePlayers.getInstance().applyPlayer(payload.playerUUID(), payload.pose(), payload.worldScale(), payload.heightScale());
            }
        }
    }
}

