/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRRenderer;
import me.phoenixra.atumvr.api.rendering.VRScene;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.VRShaders;
import me.phoenixra.visor.core.client.render.context.RenderContext;
import me.phoenixra.visor.core.client.render.helpers.MirrorHelper;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class VisorScene
implements VRScene {
    private VRRenderer vrRenderer;

    public VisorScene(VRRenderer vrRenderer) {
        this.vrRenderer = vrRenderer;
    }

    @Override
    public void init() {
    }

    @Override
    public void render(@NotNull IRenderContext context) {
        RenderContext renderContext = (RenderContext)context;
        ProfilerFiller profiler = renderContext.profiler();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.applyModelViewMatrix();
        profiler.m_6180_("prepare VROverlays and cursor");
        ClientContext.overlayManager.prepareOverlaysAndCursor(context.partialTicks());
        profiler.m_7238_();
        profiler.m_6180_("VROverlay texturing");
        GuiGraphics guiGraphics = new GuiGraphics(VisorClientImpl.MC, VisorClientImpl.MC.m_91269_().m_110104_());
        ClientContext.overlayManager.renderOverlayTextures(VisorClientImpl.MC.m_91307_(), guiGraphics, renderContext.partialTicks());
        profiler.m_7238_();
        GLUtils.checkGLError("post VR Overlays texturing");
        for (VRDisplay display : VRRenderState.getVRWorldDisplays()) {
            profiler.m_6180_("VR world display: " + display.name());
            this.renderVRDisplay(display, renderContext);
            GLUtils.checkGLError("post VR world display render: " + display.name());
            if (ClientContext.renderer.isAskedForScreenShot()) {
                this.takeScreenshot(display);
            }
            profiler.m_7238_();
        }
        profiler.m_6180_("VR mirror");
        VRRenderState.startVRMirrorPhase();
        VisorClientImpl.MC.f_91042_.m_83947_(true);
        MirrorHelper.drawMirror();
        profiler.m_7238_();
        GLUtils.checkGLError("post mirror");
    }

    private void takeScreenshot(VRDisplay currentStage) {
        boolean flag;
        if (currentStage == VRDisplay.FIRST_PERSON) {
            flag = true;
        } else {
            boolean bl = VRClientSettings.getMirrorEye() == EyeType.LEFT ? currentStage == VRDisplay.EYE_LEFT : (flag = currentStage == VRDisplay.EYE_RIGHT);
        }
        if (flag) {
            RenderTarget rendertarget = VisorClientImpl.MC.f_91042_;
            VisorClientImpl.MC.f_91042_.m_83970_();
            ClientUtils.takeScreenshot(rendertarget);
            VisorClientImpl.MC.m_91268_().m_85435_();
            ClientContext.renderer.setAskedForScreenShot(false);
        }
    }

    @Override
    public void destroy() {
    }

    private void renderVRDisplay(VRDisplay display, RenderContext context) {
        VRRenderState.startVRWorldPhase(display);
        VisorClientImpl.MC.f_91042_.m_83947_(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)Minecraft.f_91002_);
        RenderSystem.enableDepthTest();
        VisorClientImpl.MC.f_91063_.m_109093_(context.partialTicks(), context.nanoTime(), context.renderLevel());
        if (display.isEye()) {
            if (display == VRDisplay.EYE_LEFT) {
                ClientContext.renderer.getTextureLeftEye().getRenderTarget().m_83947_(true);
            } else {
                ClientContext.renderer.getTextureRightEye().getRenderTarget().m_83947_(true);
            }
            VRShaders.getPostProcess().finishEye(display == VRDisplay.EYE_LEFT ? EyeType.LEFT : EyeType.RIGHT, VisorClientImpl.MC.f_91042_, context.partialTicks());
        }
    }

    @Override
    public VRRenderer getVrRenderer() {
        return this.vrRenderer;
    }
}

