/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider.openxr;

import me.phoenixra.atumvr.api.VRLogger;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRRenderer;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.OpenXRState;
import me.phoenixra.atumvr.core.enums.XRSessionStateChange;
import me.phoenixra.atumvr.core.input.OpenXRInputHandler;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.provider.openxr.XrInputHandler;
import me.phoenixra.visor.core.client.provider.openxr.XrRawPoseHandler;
import me.phoenixra.visor.core.client.provider.openxr.render.XrRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XrProvider
extends OpenXRProvider {
    public XrProvider(@NotNull String appName, @NotNull VRLogger logger) {
        super(appName, logger);
        ClientContext.rawPoseHandler = new XrRawPoseHandler(this);
    }

    @Override
    public void initializeVR() throws Throwable {
        super.initializeVR();
        ClientContext.settingsHandler.loadOptions();
        VisorClientImpl.LOGGER.info("OpenXR initialized");
    }

    @Override
    public void preRender(@NotNull IRenderContext context) {
        super.preRender(context);
        ClientContext.rawPoseHandler.updatePose();
    }

    @Override
    @Nullable
    public OpenXRState createStateHandler() {
        return new OpenXRState(this);
    }

    @Override
    @Nullable
    public OpenXRInputHandler createInputHandler() {
        return new XrInputHandler(this);
    }

    @Override
    @NotNull
    public VRRenderer createRenderer() {
        return new XrRenderer(this);
    }

    @Override
    public void onStateChanged(XRSessionStateChange state) {
        if (state == XRSessionStateChange.EXITING) {
            VisorClientImpl.MC.m_91395_();
        }
    }

    @Override
    @NotNull
    public XrInputHandler getInputHandler() {
        return (XrInputHandler)super.getInputHandler();
    }
}

