/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.provider.openxr;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceController;
import me.phoenixra.atumvr.core.input.device.OpenXRDeviceHMD;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.raw.RawPoseHandler;
import me.phoenixra.visor.core.client.provider.openxr.XrProvider;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class XrRawPoseHandler
extends RawPoseHandler {
    private final XrProvider provider;

    public XrRawPoseHandler(XrProvider provider) {
        this.provider = provider;
    }

    @Override
    public void updatePose() {
        OpenXRDeviceHMD hmdDevice = this.provider.getInputHandler().getDevice("hmd", OpenXRDeviceHMD.class);
        this.hmdData.setTracking(hmdDevice.isActive());
        this.hmdData.getDevicePoseMutable().set(hmdDevice.getPose().matrix());
        this.hmdData.getRotationMutable().set(hmdDevice.getPose().orientation());
        this.hmdData.getLeftEyePoseMutable().set(hmdDevice.getEyePose(EyeType.LEFT).matrix());
        this.hmdData.getRightEyePoseMutable().set(hmdDevice.getEyePose(EyeType.RIGHT).matrix());
        Matrix4f hmdRotation = this.hmdData.getRotationMutable();
        Matrix4f hmdPose = this.hmdData.getDevicePoseMutable();
        hmdRotation.set3x3(hmdPose);
        Vector3f headsetPos = this.hmdData.getHeadsetPosition();
        this.hmdData.getPositionHistory().add((Vector3fc)headsetPos);
        Vector3f vector3 = this.hmdData.getRotation().transformDirection(new Vector3f(0.0f, -0.1f, 0.1f));
        this.hmdData.getPivotHistory().add((Vector3fc)new Vector3f(vector3.x() + headsetPos.x, vector3.y() + headsetPos.y, vector3.z() + headsetPos.z));
        this.hmdData.getRotationHistory().add(new Quaternionf().setFromNormalized((Matrix4fc)hmdRotation).rotateY(ClientContext.player.getRotationY()));
        OpenXRDeviceController controllerLeftDevice = this.provider.getInputHandler().getDevice("controller_left", OpenXRDeviceController.class);
        this.controllerLeftData.setTracking(controllerLeftDevice.isActive());
        this.controllerLeftData.getAimPoseMutable().set(controllerLeftDevice.getPose().matrix());
        this.controllerLeftData.getAimRotationMutable().set(controllerLeftDevice.getPose().orientation());
        this.controllerLeftData.getGripPoseMutable().set(controllerLeftDevice.getGripPose().matrix());
        this.controllerLeftData.getGripRotationMutable().set(controllerLeftDevice.getGripPose().orientation());
        this.controllerLeftData.getPositionHistory().add((Vector3fc)this.controllerLeftData.getAimPosition());
        this.controllerLeftData.getForwardHistory().add((Vector3fc)this.controllerLeftData.getAimVector());
        Vector3f upVec = controllerLeftDevice.getPose().orientation().transform(VRMathUtils.UP_VECTOR, new Vector3f());
        this.controllerLeftData.getUpHistory().add((Vector3fc)upVec);
        OpenXRDeviceController controllerRightDevice = this.provider.getInputHandler().getDevice("controller_right", OpenXRDeviceController.class);
        this.controllerRightData.setTracking(controllerRightDevice.isActive());
        this.controllerRightData.getAimPoseMutable().set(controllerRightDevice.getPose().matrix());
        this.controllerRightData.getAimRotationMutable().set(controllerRightDevice.getPose().orientation());
        this.controllerRightData.getGripPoseMutable().set(controllerRightDevice.getGripPose().matrix());
        this.controllerRightData.getGripRotationMutable().set(controllerRightDevice.getGripPose().orientation());
        this.controllerRightData.getPositionHistory().add((Vector3fc)this.controllerRightData.getAimPosition());
        this.controllerRightData.getForwardHistory().add((Vector3fc)this.controllerRightData.getAimVector());
        upVec = controllerRightDevice.getPose().orientation().transform(VRMathUtils.UP_VECTOR, new Vector3f());
        this.controllerRightData.getUpHistory().add((Vector3fc)upVec);
        Vector3f aimVector = this.controllerLeftData.getAimVector().normalize(new Vector3f());
        Vector3f gripVector = this.controllerLeftData.getGripVector().normalize(new Vector3f());
        this.gunAngle = (float)Math.toDegrees(Math.acos(Math.abs(aimVector.dot((Vector3fc)gripVector))));
    }
}

