/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.ArrayList;
import java.util.List;
import me.phoenixra.visor.api.client.render.RenderPhase;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.MirrorMode;
import me.phoenixra.visor.modified.client.WindowModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import org.jetbrains.annotations.NotNull;

public class VRRenderState {
    private static RenderPhase currentPhase = RenderPhase.VANILLA;
    private static VRDisplay currentVRDisplay = null;
    private static MainTarget vanillaTarget = null;

    public static void initVanillaTarget(MainTarget target) {
        if (vanillaTarget != null) {
            throw new RuntimeException("Vanilla target already has been initialized!");
        }
        vanillaTarget = target;
    }

    public static void startVanillaPhase() {
        currentPhase = RenderPhase.VANILLA;
        currentVRDisplay = null;
        VisorClientImpl.MC.f_91042_ = vanillaTarget;
    }

    public static void startVRGuiPhase() {
        currentPhase = RenderPhase.VR_GUI;
        currentVRDisplay = VRDisplay.GUI;
        VisorClientImpl.MC.f_91042_ = VRRenderState.getTargetForDisplay(VRDisplay.GUI);
    }

    public static void startVRWorldPhase(@NotNull VRDisplay display) {
        if (!display.isWorld()) {
            throw new RuntimeException("Tried to start VR_WORLD phase for display not rendering world: " + String.valueOf((Object)display));
        }
        currentPhase = RenderPhase.VR_WORLD;
        currentVRDisplay = display;
        VisorClientImpl.MC.f_91042_ = VRRenderState.getTargetForDisplay(display);
    }

    public static void startVRMirrorPhase() {
        currentPhase = RenderPhase.VR_MIRROR;
        currentVRDisplay = null;
        VisorClientImpl.MC.f_91042_ = ClientContext.renderer.mainTarget.getMirrorTarget();
    }

    public static RenderTarget getTargetForDisplay(VRDisplay display) {
        if (VisorState.getState().isNotInitialized() || display == null) {
            return vanillaTarget;
        }
        return switch (display) {
            default -> throw new IncompatibleClassChangeError();
            case VRDisplay.GUI -> ClientContext.renderer.guiTarget.getTarget();
            case VRDisplay.EYE_LEFT, VRDisplay.EYE_RIGHT -> ClientContext.renderer.mainTarget.getTarget();
            case VRDisplay.FIRST_PERSON -> ClientContext.renderer.firstPersonTarget.getTarget();
            case VRDisplay.THIRD_PERSON -> ClientContext.renderer.thirdPersonTarget.getTarget();
        };
    }

    public static boolean isInMainMenu() {
        if (VisorClientImpl.MC == null) {
            return false;
        }
        return VisorClientImpl.MC.f_91073_ == null || VisorClientImpl.MC.f_91080_ instanceof ReceivingLevelScreen || VisorClientImpl.MC.f_91080_ instanceof ProgressScreen || VisorClientImpl.MC.f_91080_ instanceof GenericDirtMessageScreen || VisorClientImpl.MC.m_91265_() != null;
    }

    public static List<VRDisplay> getVRWorldDisplays() {
        ArrayList<VRDisplay> list = new ArrayList<VRDisplay>();
        list.add(VRDisplay.EYE_LEFT);
        list.add(VRDisplay.EYE_RIGHT);
        WindowModified windowModif = (WindowModified)Minecraft.m_91087_().m_91268_();
        if (windowModif.visor$getActualScreenWidth() > 0 && windowModif.visor$getActualScreenHeight() > 0) {
            MirrorMode mirrorMode = VRClientSettings.getMirrorMode();
            if (mirrorMode == MirrorMode.FIRST_PERSON) {
                list.add(VRDisplay.FIRST_PERSON);
            } else if (mirrorMode == MirrorMode.THIRD_PERSON) {
                list.add(VRDisplay.THIRD_PERSON);
            } else if (mirrorMode == MirrorMode.MIXED_REALITY) {
                if (VRClientSettings.isMixedRealityWithFirstPerson() && VRClientSettings.isMixedRealityAsGrid2x2()) {
                    list.add(VRDisplay.FIRST_PERSON);
                }
                list.add(VRDisplay.THIRD_PERSON);
            }
        }
        return list;
    }

    public static RenderPhase getCurrentPhase() {
        return currentPhase;
    }

    public static VRDisplay getCurrentVRDisplay() {
        return currentVRDisplay;
    }

    public static MainTarget getVanillaTarget() {
        return vanillaTarget;
    }
}

