/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.VRRenderer;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.gui.VRGuiManagerImpl;
import me.phoenixra.visor.core.client.provider.VisorScene;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.VRShaders;
import me.phoenixra.visor.core.client.render.context.RenderContext;
import me.phoenixra.visor.core.client.render.target.types.RenderTargetFirst;
import me.phoenixra.visor.core.client.render.target.types.RenderTargetGUI;
import me.phoenixra.visor.core.client.render.target.types.RenderTargetMain;
import me.phoenixra.visor.core.client.render.target.types.RenderTargetThird;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.MirrorMode;
import me.phoenixra.visor.modified.client.WindowModified;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;

public abstract class VRRendererBase
implements VRRenderer {
    public RenderTargetMain mainTarget;
    public RenderTargetGUI guiTarget;
    public RenderTargetFirst firstPersonTarget;
    public RenderTargetThird thirdPersonTarget;
    private final Matrix4f[] eyeProjection = new Matrix4f[2];
    protected final Map<EyeType, float[]> hiddenArea = new HashMap<EyeType, float[]>();
    protected int resolutionWidth;
    protected int resolutionHeight;
    private int mirrorWidth;
    private int mirrorHeight;
    public float renderScale;
    public long lastWindow = 0L;
    private boolean askedForScreenShot = false;
    protected boolean reinitTargets = true;
    protected boolean resizeTargets = false;

    public VRRendererBase() {
        this.hiddenArea.put(EyeType.LEFT, new float[0]);
        this.hiddenArea.put(EyeType.RIGHT, new float[0]);
        ClientContext.renderer = this;
    }

    protected abstract void setupEyes();

    protected abstract void setupResolution(MemoryStack var1);

    protected abstract void setupHiddenArea(MemoryStack var1);

    public abstract Matrix4f getProjectionMatrix(EyeType var1, float var2, float var3);

    @Override
    public abstract VisorScene getCurrentScene();

    public void render(RenderContext context) {
        this.renderFrame(context);
    }

    public void onGameRenderStart(boolean renderLevel) {
        try {
            GLUtils.checkGLError("pre render setup ");
            ClientContext.renderer.updateState();
            GLUtils.checkGLError("post render setup ");
        }
        catch (Throwable throwable) {
            VisorState.destroyVRWithErrorScreen(throwable);
            return;
        }
        VRRenderState.startVRGuiPhase();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        VisorClientImpl.MC.f_91042_.m_83954_(Minecraft.f_91002_);
        VisorClientImpl.MC.f_91042_.m_83947_(true);
        RenderSystem.getModelViewStack().m_85836_();
        ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$setVRGuiVisible(renderLevel && VisorClientImpl.MC.m_91290_().f_114358_ != null);
    }

    public void updateState() throws Throwable {
        if (VisorClientImpl.MC.m_91268_().m_85439_() != this.lastWindow) {
            this.lastWindow = VisorClientImpl.MC.m_91268_().m_85439_();
            this.prepareReinit("Window Handle Changed");
        }
        if (this.resizeTargets && !this.reinitTargets) {
            this.resizeTargets();
        }
        if (this.reinitTargets) {
            this.createTargets();
        }
    }

    @Override
    public void init() throws Throwable {
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.setupResolution(stack);
            this.setupEyes();
            this.setupHiddenArea(stack);
        }
        this.updateState();
    }

    public void createTargets() throws Throwable {
        this.destroy();
        GLUtils.checkGLError("destroy on create");
        Minecraft minecraft = Minecraft.m_91087_();
        int eyeWidth = this.getResolutionWidth();
        int eyeHeight = this.getResolutionHeight();
        this.renderScale = (float)Math.sqrt(VRClientSettings.getRenderScaleFactor());
        int eyeRenderWidth = (int)Math.ceil((float)eyeWidth * this.renderScale);
        int eyeRenderHeight = (int)Math.ceil((float)eyeHeight * this.renderScale);
        List<VRDisplay> list = VRRenderState.getVRWorldDisplays();
        for (VRDisplay renderStage : list) {
            VisorClientImpl.LOGGER.info("VR Displays: {}", (Object)renderStage.toString());
        }
        this.updateMirrorSize(eyeRenderWidth, eyeRenderHeight);
        this.mainTarget = new RenderTargetMain();
        this.mainTarget.init(eyeRenderWidth, eyeRenderHeight);
        this.firstPersonTarget = new RenderTargetFirst();
        if (list.contains((Object)VRDisplay.FIRST_PERSON) || ShadersHelper.isShaderActive() && this.mirrorWidth > 0 && this.mirrorHeight > 0) {
            this.firstPersonTarget.init(this.mirrorWidth, this.mirrorHeight);
        }
        this.thirdPersonTarget = new RenderTargetThird();
        if (list.contains((Object)VRDisplay.THIRD_PERSON) || ShadersHelper.isShaderActive() && this.mirrorWidth > 0 && this.mirrorHeight > 0) {
            this.thirdPersonTarget.init(this.mirrorWidth, this.mirrorHeight);
        }
        VRGuiManagerImpl guiManager = ClientContext.visor.getGuiManager();
        guiManager.updateResolution();
        this.guiTarget = new RenderTargetGUI();
        this.guiTarget.init(guiManager.getGuiWidth(), guiManager.getGuiHeight());
        ((GameRendererModified)minecraft.f_91063_).visor$setupClipPlanes();
        this.updateProjection();
        try {
            minecraft.f_91042_ = this.mainTarget.getTarget();
            VRShaders.setup();
        }
        catch (Exception exception1) {
            LoggerUtils.printError(exception1);
            System.exit(-1);
        }
        if (minecraft.f_91080_ != null) {
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            minecraft.f_91080_.m_6575_(minecraft, screenWidth, screenHeight);
        }
        WindowModified windowModif = (WindowModified)minecraft.m_91268_();
        long windowPixels = (long)windowModif.visor$getActualScreenWidth() * (long)windowModif.visor$getActualScreenHeight();
        long vrPixels = (long)(eyeRenderWidth * eyeRenderHeight) * 2L;
        if (list.contains((Object)VRDisplay.FIRST_PERSON)) {
            vrPixels += windowPixels;
        }
        VisorClientImpl.LOGGER.info("[Visor] render targets created:\nEye target width: " + eyeWidth + ", height: " + eyeHeight + " [" + String.format("%.1f", Float.valueOf((float)(eyeWidth * eyeHeight) / 1000000.0f)) + " MP]\nRender target width: " + eyeRenderWidth + ", height: " + eyeRenderHeight + " [Render scale: " + Math.round(VRClientSettings.getRenderScaleFactor() * 100.0f) + "%, " + String.format("%.1f", Float.valueOf((float)(eyeRenderWidth * eyeRenderHeight) / 1000000.0f)) + " MP]\nMain window width: " + windowModif.visor$getActualScreenWidth() + ", height: " + windowModif.visor$getActualScreenHeight() + " [" + String.format("%.1f", Float.valueOf((float)windowPixels / 1000000.0f)) + " MP]\nTotal shaded pixels per frame: " + String.format("%.1f", Float.valueOf((float)vrPixels / 1000000.0f)) + " MP (eye stencil not accounted for)");
        minecraft.f_91060_.m_6213_(minecraft.m_91098_());
        this.reinitTargets = false;
    }

    private void resizeTargets() throws Exception {
        VRGuiManagerImpl guiManager;
        this.resizeTargets = false;
        float resolutionScale = 1.0f;
        this.renderScale = (float)Math.sqrt(VRClientSettings.getRenderScaleFactor()) * resolutionScale;
        int eyeRenderWidth = (int)Math.ceil((float)this.getResolutionWidth() * this.renderScale);
        int eyeRenderHeight = (int)Math.ceil((float)this.getResolutionHeight() * this.renderScale);
        this.updateMirrorSize(eyeRenderWidth, eyeRenderHeight);
        this.mainTarget.resize(eyeRenderWidth, eyeRenderHeight);
        if (this.firstPersonTarget != null) {
            this.firstPersonTarget.resize(this.mirrorWidth, this.mirrorHeight);
        }
        if (this.thirdPersonTarget != null) {
            this.thirdPersonTarget.resize(this.mirrorWidth, this.mirrorHeight);
        }
        if ((guiManager = ClientContext.visor.getGuiManager()).updateResolution()) {
            this.guiTarget.resize(guiManager.getGuiWidth(), guiManager.getGuiHeight());
        }
        Minecraft.m_91087_().m_5741_();
    }

    @Override
    public void prepareReinit(@NotNull String cause) {
        if (!this.reinitTargets) {
            VisorClientImpl.LOGGER.info("Reinit Render Buffers: {}", (Object)cause);
        }
        this.reinitTargets = true;
    }

    @Override
    public void prepareResize(@NotNull String cause) {
        if (!this.resizeTargets) {
            VisorClientImpl.LOGGER.info("Resizing Render Buffers: {}", (Object)cause);
        }
        this.resizeTargets = true;
    }

    public Matrix4f getEyeProjection(EyeType eyeType) {
        return this.eyeProjection[eyeType.getIndex()];
    }

    public void updateProjection() {
        float nearClipPlane = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getNearClipPlane();
        float farClipPlane = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getFarClipPlane();
        VRClientSettings.setEyeFovChanged(false);
        this.eyeProjection[0] = this.getProjectionMatrix(EyeType.LEFT, nearClipPlane, farClipPlane);
        this.eyeProjection[1] = this.getProjectionMatrix(EyeType.RIGHT, nearClipPlane, farClipPlane);
    }

    private void updateMirrorSize(int eyeWidth, int eyeHeight) {
        WindowModified windowModif = (WindowModified)Minecraft.m_91087_().m_91268_();
        this.mirrorWidth = Math.max(1, windowModif.visor$getActualScreenWidth());
        this.mirrorHeight = Math.max(1, windowModif.visor$getActualScreenHeight());
        if (VRClientSettings.getMirrorMode() == MirrorMode.MIXED_REALITY) {
            this.mirrorWidth /= 2;
            if (VRClientSettings.isMixedRealityAsGrid2x2()) {
                this.mirrorHeight /= 2;
            }
        }
        if (ShadersHelper.sameSizedBuffers()) {
            this.mirrorWidth = eyeWidth;
            this.mirrorHeight = eyeHeight;
        }
    }

    @Override
    public void destroy() {
        if (this.mainTarget != null) {
            this.mainTarget.destroy();
        }
        if (this.firstPersonTarget != null) {
            this.firstPersonTarget.destroy();
        }
        if (this.thirdPersonTarget != null) {
            this.thirdPersonTarget.destroy();
        }
        if (this.guiTarget != null) {
            this.guiTarget.destroy();
            this.guiTarget = null;
        }
    }

    @Override
    public void updateOverlayTarget(@NotNull VROverlayScreen overlayScreen) {
        if (this.guiTarget == null) {
            return;
        }
        this.guiTarget.updateOverlayTarget(overlayScreen);
    }

    @Override
    public long getWindowHandle() {
        return VisorClientImpl.MC.m_91268_().m_85439_();
    }

    @Override
    public float[] getHiddenAreaVertices(EyeType eyeType) {
        return this.hiddenArea.get((Object)eyeType);
    }

    @Override
    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    @Override
    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public int getMirrorWidth() {
        return this.mirrorWidth;
    }

    public int getMirrorHeight() {
        return this.mirrorHeight;
    }

    public boolean isAskedForScreenShot() {
        return this.askedForScreenShot;
    }

    public void setAskedForScreenShot(boolean askedForScreenShot) {
        this.askedForScreenShot = askedForScreenShot;
    }
}

