/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.render.decoration.VRDecorationRenderer;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.effects.VRGameEffect;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.decoration.hand.VRHandRenderer;
import me.phoenixra.visor.core.client.render.decoration.registry.DecoratorRegistry;
import me.phoenixra.visor.core.client.render.decoration.registry.VRGameEffectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationRendererImpl
implements VRDecorationRenderer {
    private final DecoratorRegistry registry = new DecoratorRegistry();
    private final VRGameEffectRegistry effectsRegistry = new VRGameEffectRegistry();
    private VRDecorator currentDecorator;

    public DecorationRendererImpl() {
        ClientContext.handRenderer = new VRHandRenderer();
    }

    @Override
    public void render(PoseStack poseStack, float partialTicks) {
        if (this.currentDecorator != null) {
            this.currentDecorator.render(poseStack, partialTicks);
            GLUtils.checkGLError("post vr decoration");
        }
    }

    @Override
    public void tick() {
        VRDecorator newScene = null;
        for (VRDecorator entry : this.registry.getSortedElements()) {
            if (!entry.isEnabledAndCanActivate()) continue;
            newScene = entry;
            break;
        }
        if (newScene != null && newScene != this.currentDecorator) {
            this.onDecoratorChanged(newScene);
        }
        if (this.currentDecorator != null) {
            this.currentDecorator.tick();
        }
    }

    private void onDecoratorChanged(@NotNull VRDecorator newScene) {
        if (this.currentDecorator != null) {
            this.currentDecorator.clear();
        }
        newScene.init();
        this.currentDecorator = newScene;
    }

    @Override
    @Nullable
    public VRDecorator getDecorator(@NotNull String id) {
        return this.registry.getElement(id);
    }

    public List<VisorRegistry<?>> getElementRegistries() {
        return List.of(this.registry, this.effectsRegistry, ClientContext.handRenderer.getItemPosesRegistry(), ClientContext.handRenderer.getEffectsRegistry());
    }

    public void renderGameEffects(VRDecorator decorator, PoseStack poseStack, float partialTick) {
        VRDecorator currentDecorator = ClientContext.decorationRenderer.getCurrentDecorator();
        for (VRGameEffect effect : this.effectsRegistry.getElementsMap().values()) {
            if (!effect.isGlobal() && !decorator.gameEffects().contains(effect.getId()) || !effect.isEnabledAndVisible(currentDecorator)) continue;
            effect.render(VRRenderState.getCurrentVRDisplay(), poseStack, partialTick);
        }
    }

    public DecoratorRegistry getRegistry() {
        return this.registry;
    }

    public VRGameEffectRegistry getEffectsRegistry() {
        return this.effectsRegistry;
    }

    @Override
    public VRDecorator getCurrentDecorator() {
        return this.currentDecorator;
    }
}

