/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.effects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRGameEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRGameEffect;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@RegisterVRGameEffect
public class GameEffectOnFire
extends VRGameEffect {
    public static final String ID = "on_fire";
    private static final float FIRE_HALF_WIDTH = 0.3f;
    private static final float FIRE_ALPHA = 0.9f;

    public GameEffectOnFire(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void render(@NotNull VRDisplay display, @NotNull PoseStack stack, float partialTicks) {
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        float fireHeight = (float)((double)renderPose.getHeadPivot().y() - ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getCameraEntityCache().getY());
        TextureAtlasSprite sprite = ModelBakery.f_119220_.m_119204_();
        ResourceLocation atlas = sprite.m_247685_();
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float midU = (uMin + uMax) * 0.5f;
        float midV = (vMin + vMax) * 0.5f;
        float shrink = sprite.m_118417_();
        float u0 = Mth.m_14179_((float)shrink, (float)uMin, (float)midU);
        float u1 = Mth.m_14179_((float)shrink, (float)uMax, (float)midU);
        float v0 = Mth.m_14179_((float)shrink, (float)vMin, (float)midV);
        float v1 = Mth.m_14179_((float)shrink, (float)vMax, (float)midV);
        RenderSystem.depthFunc((int)(display == VRDisplay.THIRD_PERSON ? 515 : 519));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlas);
        stack.m_85836_();
        stack.m_166856_();
        RenderPoseHelper.applyDisplayPose(display, stack);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        for (int i = 0; i < 4; ++i) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252961_((float)i * (float)Math.PI / 2.0f - renderPose.getBodyYaw()));
            stack.m_252880_(0.0f, -fireHeight, 0.0f);
            Matrix4f mat = stack.m_85850_().m_252922_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buf.m_252986_(mat, -0.3f, 0.0f, -0.3f).m_7421_(u1, v1).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            buf.m_252986_(mat, 0.3f, 0.0f, -0.3f).m_7421_(u0, v1).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            buf.m_252986_(mat, 0.3f, fireHeight, -0.3f).m_7421_(u0, v0).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            buf.m_252986_(mat, -0.3f, fireHeight, -0.3f).m_7421_(u1, v0).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            stack.m_85849_();
        }
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        stack.m_85849_();
    }

    @Override
    public boolean isVisible(@NotNull VRDecorator currentDecorator) {
        return ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$isOnFire();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

