/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRGameEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRGameEffect;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.helpers.RenderHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.modified.client.entity.LocalPlayerModified;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL43C;

@RegisterVRGameEffect
public class GameEffectShadow
extends VRGameEffect {
    public static final String ID = "shadow";
    private static final AtumColorImmutable SHADOW_COLOR = new AtumColorImmutable(0, 0, 0, 64);
    private int glCacheBlendSrcA;
    private int glCacheBlendDstA;
    private int glCacheBlendSrcRGB;
    private int glCacheBlendDstRGB;
    private boolean glCacheBlend;
    private boolean glCacheCull;

    public GameEffectShadow(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void render(@NotNull VRDisplay renderDisplay, @NotNull PoseStack poseStack, float partialTicks) {
        AABB box = VisorClientImpl.MC.f_91074_.m_20191_();
        float playerWidth = (float)box.m_82362_();
        float playerLength = (float)box.m_82385_();
        Vec3 camPos = new Vec3((Vector3f)RenderPoseHelper.getCameraPosition(renderDisplay, ClientContext.player.getPoseData(PoseDataType.RENDER)));
        Vec3 worldPlayerPos = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getCameraEntityCache().getInterpolatedPos(partialTicks);
        Vec3 shadowPos = worldPlayerPos.m_82546_(camPos).m_82520_(0.0, 0.005, 0.0);
        RenderSystem.disableCull();
        this.setupPolygonGlState(true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TexturesHelper.getWhiteTexture());
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderPoseHelper.applyDisplayOrientation(renderDisplay, poseStack);
        poseStack.m_85837_(shadowPos.f_82479_, shadowPos.f_82480_, shadowPos.f_82481_);
        RenderHelper.renderFlatQuad(Tesselator.m_85913_().m_85915_(), poseStack.m_85850_().m_252922_(), VRMathUtils.ZERO_VECTOR, playerWidth, playerLength, 0.0f, SHADOW_COLOR);
        RenderSystem.depthFunc((int)515);
        this.setupPolygonGlState(false);
        RenderSystem.enableCull();
        poseStack.m_85849_();
    }

    private void setupPolygonGlState(boolean enable) {
        if (enable) {
            this.glCacheBlendSrcA = GlStateManager.BLEND.f_84580_;
            this.glCacheBlendDstA = GlStateManager.BLEND.f_84581_;
            this.glCacheBlendSrcRGB = GlStateManager.BLEND.f_84578_;
            this.glCacheBlendDstRGB = GlStateManager.BLEND.f_84579_;
            this.glCacheBlend = GL43C.glIsEnabled((int)3042);
            this.glCacheCull = true;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
        } else {
            RenderSystem.blendFuncSeparate((int)this.glCacheBlendSrcRGB, (int)this.glCacheBlendDstRGB, (int)this.glCacheBlendSrcA, (int)this.glCacheBlendDstA);
            if (!this.glCacheBlend) {
                RenderSystem.disableBlend();
            }
            if (this.glCacheCull) {
                RenderSystem.enableCull();
            }
        }
    }

    @Override
    public boolean isVisible(@NotNull VRDecorator currentDecorator) {
        if (VRRenderState.getCurrentVRDisplay() == VRDisplay.THIRD_PERSON) {
            return false;
        }
        if (!VisorClientImpl.MC.f_91074_.m_6084_()) {
            return false;
        }
        if (VisorClientImpl.MC.f_91074_.m_20202_() != null) {
            return false;
        }
        return !(((LocalPlayerModified)VisorClientImpl.MC.f_91074_).visor$getRoomYOffset() < 0.0);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

