/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.effects.hand;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.VRCursorHandlerImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderHelper;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVRHandEffect
public class GlobalHandEffectCursor
extends VRHandEffect {
    public static final String ID = "cursor";
    private static final AtumColorImmutable DEFAULT_COLOR = new AtumColorImmutable(228, 228, 228, 255);
    private static final float BOX_HALF_SIZE = 0.0016f;

    public GlobalHandEffectCursor(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void render(@NotNull ControllerHand hand, @NotNull VRDisplay renderDisplay, @NotNull PoseStack poseStack, boolean simpleHand, float partialTicks) {
        AtumColorImmutable color;
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        float cursorLength = (float)cursorHandler.getCursorLineLength(hand);
        if (cursorLength <= 0.0f) {
            return;
        }
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f end = new Vector3f(0.0f, 0.0f, -cursorLength);
        if (VisorClientImpl.MC.f_91073_ != null) {
            float rawLight = VisorClientImpl.MC.f_91073_.m_46803_(BlockPos.m_274446_((Position)new Vec3((Vector3f)ClientContext.player.getPoseData(PoseDataType.RENDER).getHmd().getPosition())));
            float light = Math.max(rawLight, (float)ShadersHelper.shaderLight());
            float lightPercent = light / (float)VisorClientImpl.MC.f_91073_.m_7469_();
            color = new AtumColorImmutable(Mth.m_14143_((float)((float)DEFAULT_COLOR.getRedInt() * lightPercent)), Mth.m_14143_((float)((float)DEFAULT_COLOR.getGreenInt() * lightPercent)), Mth.m_14143_((float)((float)DEFAULT_COLOR.getBlueInt() * lightPercent)), 255);
        } else {
            color = DEFAULT_COLOR;
        }
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.setShader(GameRenderer::m_172811_);
        if (VisorClientImpl.MC.m_91265_() == null) {
            ResourceLocation whiteTex = TexturesHelper.getWhiteTexture();
            VisorClientImpl.MC.m_91097_().m_174784_(whiteTex);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)whiteTex);
        }
        RenderHelper.renderCuboid(builder, poseStack.m_85850_().m_252922_(), (Vector3fc)start, (Vector3fc)end, -0.0016f, 0.0016f, -0.0016f, 0.0016f, color);
        RenderSystem.depthFunc((int)515);
    }

    @Override
    public boolean isVisible(@NotNull VRDecorator currentDecorator, @NotNull ControllerHand hand, boolean simpleHand) {
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.GUI_CURSOR)) {
            return false;
        }
        if (cursorHandler.isTwoHandedCursor()) {
            return true;
        }
        if (!cursorHandler.isCursorHandFocused()) {
            return false;
        }
        return cursorHandler.getCursorHand() == hand;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public VRHandEffect.RenderStage renderAtStage() {
        return VRHandEffect.RenderStage.BEFORE_HANDS;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

