/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.effects.hand;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVRHandEffect
public class HandEffectCrosshair
extends VRHandEffect {
    public static final String ID = "crosshair";
    private static final ResourceLocation ICONS_LOC = Gui.f_279580_;
    private static final float BASE_SCALE = 0.125f;
    private static final float UV_SIZE = 0.05859375f;
    private static final float LIGHT_OFFSET = -0.01f;
    private static final float FULL_BRIGHTNESS = 1.0f;
    private static final float MISS_BRIGHTNESS = 0.5f;

    public HandEffectCrosshair(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void render(@NotNull ControllerHand hand, @NotNull VRDisplay display, @NotNull PoseStack poseStack, boolean simpleHand, float partialTicks) {
        PoseDataImpl pose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3f rawCross = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getCrossVec().m_252839_();
        Vector3f aim = rawCross.sub(pose.getController(hand).getPosition(), new Vector3f());
        float worldScale = (float)Math.sqrt(pose.getWorldScale());
        float scale = 0.125f * worldScale;
        Vector3f crossPos = rawCross.add((Vector3fc)aim.normalize().mul(-0.01f));
        BlockPos lightPos = BlockPos.m_274446_((Position)new Vec3(crossPos));
        int lightCoords = LevelRenderer.m_109541_((BlockAndTintGetter)VisorClientImpl.MC.f_91073_, (BlockPos)lightPos);
        float brightness = VisorClientImpl.MC.f_91077_ == null || VisorClientImpl.MC.f_91077_.m_6662_() == HitResult.Type.MISS ? 0.5f : 1.0f;
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        VisorClientImpl.MC.f_91063_.m_109154_().m_109896_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS_LOC);
        RenderSystem.setShader(GameRenderer::m_172667_);
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderPoseHelper.applyDisplayOrientation(display, poseStack);
        Vector3f camPos = VisorClientImpl.MC.m_91288_().m_20182_().m_252839_();
        Vector3f translate = crossPos.sub((Vector3fc)camPos);
        poseStack.m_252880_(translate.x, translate.y, translate.z);
        this.applyCrossHairRotation(poseStack, hand, pose);
        poseStack.m_85841_(scale, scale, scale);
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        buf.m_252986_(mat, -1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.05859375f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buf.m_252986_(mat, 1.0f, 1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buf.m_252986_(mat, 1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f, 0.05859375f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buf.m_252986_(mat, -1.0f, -1.0f, 0.0f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.05859375f, 0.05859375f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightCoords).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        poseStack.m_85849_();
    }

    private void applyCrossHairRotation(PoseStack poseStack, ControllerHand hand, PoseData pose) {
        HitResult hitResult = VisorClientImpl.MC.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hitResult;
            switch (bhr.m_82434_()) {
                case DOWN: {
                    this.rotateInDegrees(poseStack, pose.getController(hand).getYaw(), 0.0f, 1.0f, 0.0f);
                    this.rotateInDegrees(poseStack, -90.0f, 1.0f, 0.0f, 0.0f);
                    break;
                }
                case UP: {
                    this.rotateInDegrees(poseStack, -pose.getController(hand).getYaw(), 0.0f, 1.0f, 0.0f);
                    this.rotateInDegrees(poseStack, 90.0f, 1.0f, 0.0f, 0.0f);
                    break;
                }
                case WEST: {
                    this.rotateInDegrees(poseStack, 90.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case EAST: {
                    this.rotateInDegrees(poseStack, -90.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    this.rotateInDegrees(poseStack, 180.0f, 0.0f, 1.0f, 0.0f);
                    break;
                }
            }
        } else {
            this.rotateInDegrees(poseStack, -pose.getController(hand).getYaw(), 0.0f, 1.0f, 0.0f);
            this.rotateInDegrees(poseStack, -pose.getController(hand).getPitch(), 1.0f, 0.0f, 0.0f);
        }
    }

    private void rotateInDegrees(PoseStack pose, float angle, float x, float y, float z) {
        pose.m_252781_(new Quaternionf(new AxisAngle4f(angle * ((float)Math.PI / 180), x, y, z)));
    }

    @Override
    public boolean isVisible(@NotNull VRDecorator currentDecorator, @NotNull ControllerHand hand, boolean simpleHand) {
        boolean insideBlock;
        if (simpleHand) {
            return false;
        }
        if (hand != ClientContext.player.getActiveHand()) {
            return false;
        }
        boolean bl = insideBlock = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$isInBlock() > 0.0f;
        if (insideBlock) {
            return false;
        }
        return ClientContext.visor.isFeatureEnabled(ClientFeature.AIM_EFFECTS);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

