/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.hand;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import me.phoenixra.atumvr.api.misc.color.AtumColorImmutable;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.client.render.decoration.VRDecorator;
import me.phoenixra.visor.api.client.render.decoration.effects.VRHandEffect;
import me.phoenixra.visor.api.client.render.decoration.hand.VRHandItemPose;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.compatibility.ShadersHelper;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.VRCursorHandlerImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.decoration.registry.VRHandEffectRegistry;
import me.phoenixra.visor.core.client.render.decoration.registry.VRHandItemPoseRegistry;
import me.phoenixra.visor.core.client.render.helpers.RenderHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.MirrorMode;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRHandRenderer {
    private static final AtumColorImmutable GUI_HANDS_COLOR = new AtumColorImmutable(64, 64, 64, 255);
    private final VRHandItemPoseRegistry itemPosesRegistry = new VRHandItemPoseRegistry();
    private final VRHandEffectRegistry effectsRegistry = new VRHandEffectRegistry();

    public void applyItemHandPose(@NotNull AbstractClientPlayer player, @NotNull ControllerHand hand, @NotNull ItemStack itemStack, @NotNull PoseStack poseStack, float equippedProgress, float partialTicks) {
        for (VRHandItemPose entry : this.itemPosesRegistry.getSortedElements()) {
            if (!entry.isEnabledAndCanApplyPose(player, hand, itemStack)) continue;
            entry.applyPose(poseStack, player, hand, itemStack, equippedProgress, partialTicks);
            return;
        }
    }

    public void renderWorldHands(@NotNull VRDecorator decorator, @NotNull PoseStack poseStack, float partialTicks, boolean renderMain, boolean renderOffhand) {
        this.renderHands(decorator, poseStack, partialTicks, renderMain, renderOffhand, false);
    }

    public void renderGuiHands(@NotNull VRDecorator decorator, @NotNull PoseStack poseStack, float partialTicks, boolean renderMain, boolean renderOffhand) {
        this.renderHands(decorator, poseStack, partialTicks, renderMain, renderOffhand, true);
    }

    public void renderHands(@NotNull VRDecorator decorator, @NotNull PoseStack poseStack, float partialTicks, boolean renderMain, boolean renderOffhand, boolean isGui) {
        boolean isGuiHand;
        boolean isCursorHand;
        if (!ClientContext.visor.isFeatureEnabled(ClientFeature.VR_HANDS)) {
            return;
        }
        if (VRRenderState.getCurrentVRDisplay() == VRDisplay.THIRD_PERSON && VRClientSettings.getMirrorMode() != MirrorMode.MIXED_REALITY) {
            return;
        }
        VRCursorHandlerImpl cursorHandler = ClientContext.cursorHandler;
        RenderSystem.backupProjectionMatrix();
        ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$resetProjectionMatrix(partialTicks);
        VRDisplay display = VRRenderState.getCurrentVRDisplay();
        Collection<VRHandEffect> effects = this.effectsRegistry.getElementsMap().values();
        if (renderMain && this.isControllerTracking(ControllerHand.MAIN)) {
            isCursorHand = cursorHandler.isHandFocused(ControllerHand.MAIN) && (cursorHandler.getCursorHand() == ControllerHand.MAIN || cursorHandler.isTwoHandedCursor());
            isGuiHand = isGui || isCursorHand || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HANDS) || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HAND_MAIN);
            this.renderHand(ControllerHand.MAIN, poseStack, partialTicks, isGuiHand, display, effects, decorator);
        }
        if (renderOffhand && this.isControllerTracking(ControllerHand.OFFHAND)) {
            isCursorHand = cursorHandler.isHandFocused(ControllerHand.OFFHAND) && (cursorHandler.getCursorHand() == ControllerHand.OFFHAND || cursorHandler.isTwoHandedCursor());
            isGuiHand = isGui || isCursorHand || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HANDS) || ClientContext.visor.isFeatureDisabled(ClientFeature.VR_WORLD_HAND_OFFHAND);
            this.renderHand(ControllerHand.OFFHAND, poseStack, partialTicks, isGuiHand, display, effects, decorator);
        }
        RenderSystem.restoreProjectionMatrix();
    }

    private void renderHand(ControllerHand hand, @NotNull PoseStack poseStack, float partialTicks, boolean isGui, VRDisplay display, Collection<VRHandEffect> effects, VRDecorator decorator) {
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderPoseHelper.applyDisplayOrientation(display, poseStack);
        RenderPoseHelper.applyControllerPose(hand, poseStack);
        Map<VRHandEffect.RenderStage, Collection<VRHandEffect>> stageEffects = this.groupEffectsByStage(effects, decorator, hand, isGui);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        this.renderHandEffects(stageEffects.get((Object)VRHandEffect.RenderStage.BEFORE_HANDS), hand, display, poseStack, isGui, partialTicks);
        if (isGui) {
            this.renderGuiHand(poseStack);
        } else {
            this.renderWorldHand(poseStack, hand, partialTicks);
        }
        this.renderHandEffects(stageEffects.get((Object)VRHandEffect.RenderStage.AFTER_HANDS), hand, display, poseStack, isGui, partialTicks);
        poseStack.m_85849_();
    }

    private void renderGuiHand(PoseStack poseStack) {
        AtumColorImmutable color;
        VisorClientImpl.MC.m_91097_().m_174784_(TexturesHelper.getWhiteTexture());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TexturesHelper.getWhiteTexture());
        RenderSystem.depthFunc((int)519);
        Vector3fc dir = VRMathUtils.BACK_VECTOR;
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f end = new Vector3f(start.x - dir.x() * 0.18f, start.y - dir.y() * 0.18f, start.z - dir.z() * 0.18f);
        if (VisorClientImpl.MC.f_91073_ != null) {
            float light = VisorClientImpl.MC.f_91073_.m_46803_(BlockPos.m_274446_((Position)new Vec3((Vector3f)ClientContext.player.getPoseData(PoseDataType.RENDER).getHmd().getPosition())));
            light = Math.max(light, (float)ShadersHelper.shaderLight());
            float lightPercent = light / (float)VisorClientImpl.MC.f_91073_.m_7469_();
            color = new AtumColorImmutable(Mth.m_14143_((float)((float)GUI_HANDS_COLOR.getRedInt() * lightPercent)), Mth.m_14143_((float)((float)GUI_HANDS_COLOR.getGreenInt() * lightPercent)), Mth.m_14143_((float)((float)GUI_HANDS_COLOR.getBlueInt() * lightPercent)), 255);
        } else {
            color = GUI_HANDS_COLOR;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        RenderHelper.renderCuboid(tesselator.m_85915_(), poseStack.m_85850_().m_252922_(), (Vector3fc)start, (Vector3fc)end, -0.02f, 0.02f, -0.0125f, 0.0125f, color);
        RenderSystem.depthFunc((int)515);
    }

    private void renderWorldHand(PoseStack poseStack, ControllerHand hand, float partialTicks) {
        if (VisorClientImpl.MC.f_91074_ == null) {
            return;
        }
        InteractionHand interactionHand = hand.asInteractionHand();
        ItemStack item = VisorClientImpl.MC.f_91074_.m_21120_(interactionHand);
        if (VisorClientImpl.MC.f_91080_ != null) {
            item = ItemStack.f_41583_;
        }
        poseStack.m_85836_();
        VisorClientImpl.MC.f_91063_.m_109154_().m_109896_();
        MultiBufferSource.BufferSource bufferSource = VisorClientImpl.MC.m_91269_().m_110104_();
        VisorClientImpl.MC.f_91063_.f_109055_.m_109371_((AbstractClientPlayer)VisorClientImpl.MC.f_91074_, partialTicks, 0.0f, interactionHand, VisorClientImpl.MC.f_91074_.m_21324_(partialTicks), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, VisorClientImpl.MC.m_91290_().m_114394_((Entity)VisorClientImpl.MC.f_91074_, partialTicks));
        bufferSource.m_109911_();
        VisorClientImpl.MC.f_91063_.m_109154_().m_109891_();
        poseStack.m_85849_();
    }

    private void renderHandEffects(Collection<VRHandEffect> effects, ControllerHand hand, VRDisplay display, PoseStack poseStack, boolean isSimple, float partialTicks) {
        if (effects == null || effects.isEmpty()) {
            return;
        }
        effects.forEach(it -> it.render(hand, display, poseStack, isSimple, partialTicks));
    }

    private Map<VRHandEffect.RenderStage, Collection<VRHandEffect>> groupEffectsByStage(Collection<VRHandEffect> effects, VRDecorator decorator, ControllerHand hand, boolean isSimple) {
        EnumMap<VRHandEffect.RenderStage, Collection<VRHandEffect>> map = new EnumMap<VRHandEffect.RenderStage, Collection<VRHandEffect>>(VRHandEffect.RenderStage.class);
        for (VRHandEffect effect : effects) {
            if (!effect.isGlobal() && !decorator.handEffects().contains(effect.getId()) || !effect.isEnabledAndVisible(decorator, hand, isSimple)) continue;
            map.computeIfAbsent(effect.renderAtStage(), k -> new ArrayList()).add(effect);
        }
        return map;
    }

    private boolean isControllerTracking(ControllerHand hand) {
        return ClientContext.rawPoseHandler.getControllerData(hand).isTracking();
    }

    public VRHandItemPoseRegistry getItemPosesRegistry() {
        return this.itemPosesRegistry;
    }

    public VRHandEffectRegistry getEffectsRegistry() {
        return this.effectsRegistry;
    }
}

