/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.hand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRItemPose;
import me.phoenixra.visor.api.client.render.decoration.hand.VRHandItemPose;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.compatibility.ItemClassifier;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.Util;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@RegisterVRItemPose
public class VRItemPoseDefault
extends VRHandItemPose {
    private static final String ID = "default";

    public VRItemPoseDefault(@NotNull VisorAddon owner) {
        super(owner);
    }

    @Override
    public void applyPose(@NotNull PoseStack stack, @NotNull AbstractClientPlayer player, @NotNull ControllerHand hand, @NotNull ItemStack item, float equipProgress, float partialTicks) {
        InteractionHand mcHand = hand == ControllerHand.MAIN ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        int handDir = hand == ControllerHand.MAIN ? 1 : -1;
        PoseParams params = this.computeParams(item, player, mcHand, handDir, equipProgress, partialTicks);
        stack.m_252781_(params.preRotation);
        stack.m_252880_(params.offsetX, params.offsetY, params.offsetZ);
        stack.m_252781_(params.rotation);
        stack.m_85841_(params.scale, params.scale, params.scale);
    }

    private PoseParams computeParams(ItemStack item, AbstractClientPlayer player, InteractionHand mcHand, int handDir, float equipProgress, float partialTicks) {
        float gunAngle = ClientContext.rawPoseHandler.getGunAngle();
        ControllerHand controllerHand = ControllerHand.fromMcHand(mcHand);
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternionf preRotation = Axis.f_252436_.m_252977_(0.0f);
        Quaternionf rotation = Axis.f_252529_.m_252977_(-110.0f + gunAngle);
        TransformType transformType = VRItemPoseDefault.getTransformType(item, player, VisorClientImpl.MC.m_91291_());
        switch (transformType.ordinal()) {
            case 0: 
            case 3: {
                if (item.m_41720_() instanceof ArrowItem) {
                    preRotation = Axis.f_252403_.m_252977_(-180.0f);
                    rotation = Axis.f_252529_.m_252977_(-gunAngle);
                    break;
                }
                rotation = Axis.f_252403_.m_252977_(180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
                scale = 0.4f;
                translateX += 0.08f;
                translateZ -= 0.08f;
                break;
            }
            case 1: {
                scale = 0.3f;
                translateX += 0.05f;
                translateZ -= 0.1f;
                break;
            }
            case 2: {
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                rotation = Axis.f_252529_.m_252977_(-45.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(gunAngle));
                break;
            }
            case 12: {
                long ticks = player.m_21212_();
                rotation = Axis.f_252403_.m_252977_(180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
                translateZ += 0.006f * Mth.m_14031_((float)ticks) + 0.02f;
                translateX += 0.08f;
                scale = 0.4f;
                break;
            }
            case 11: {
                preRotation = Axis.f_252436_.m_252977_(0.0f);
                rotation = Axis.f_252529_.m_252977_(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case 15: {
                rotation = Axis.f_252436_.m_252977_(90.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(25.0f));
                scale = 0.4f;
                break;
            }
            case 16: {
                rotation = Axis.f_252529_.m_252977_(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case 7: {
                translateX += 0.05f;
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateZ -= 0.15f;
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(40.0f));
                scale = 0.8f;
                break;
            }
            case 13: {
                rotation = Axis.f_252436_.m_252977_(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case 8: {
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case 4: {
                if (VRClientSettings.isLeftHanded()) {
                    handDir *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                translateZ += 0.1f;
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(handDir == 1 ? 105 : 115) - gunAngle));
                translateX += handDir == 1 ? 0.11f : -0.015f;
                if (player.m_6117_() && player.m_7655_() == mcHand) {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(handDir * 5)));
                    rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(-5.0f));
                    translateY -= 0.12f;
                    translateZ -= handDir == 1 ? 0.1f : 0.11f;
                    translateX += handDir == 1 ? 0.04f : 0.19f;
                    rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)handDir * (player.m_21254_() ? 90.0f : (1.0f - equipProgress) * 90.0f)));
                }
                rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)handDir * -90.0f));
                break;
            }
            case 10: {
                rotation.identity();
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                int riptideLevel = 0;
                if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == mcHand) {
                    charging = true;
                    riptideLevel = EnchantmentHelper.m_44932_((ItemStack)item);
                    if ((riptideLevel <= 0 || player.m_20070_()) && (progress = (float)item.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0 && player.m_20070_()) {
                            preRotation = Axis.f_252403_.m_252977_(-rotationProgress * 10.0f * (float)riptideLevel);
                        }
                        if (VisorState.TICK_COUNT % 2 == 0) {
                            ClientContext.inputManager.triggerHapticPulseMicroSec(controllerHand, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(Util.m_137550_());
                    }
                }
                if (player.m_21209_()) {
                    riptideLevel = 5;
                    translateZ -= 0.15f;
                    preRotation = Axis.f_252403_.m_252977_((float)(-VisorState.TICK_COUNT * 10 * riptideLevel % 360) - partialTicks * 10.0f * (float)riptideLevel);
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(gunAngle));
                }
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
            }
        }
        return new PoseParams(preRotation, rotation, translateX, translateY, translateZ, scale);
    }

    public static TransformType getTransformType(ItemStack itemStack, AbstractClientPlayer player, ItemRenderer itemRenderer) {
        TransformType transformType = TransformType.DEFAULT;
        Item item = itemStack.m_41720_();
        if (itemStack.m_41780_() == UseAnim.EAT || itemStack.m_41780_() == UseAnim.DRINK) {
            return TransformType.CONSUMABLE;
        }
        if (item instanceof BlockItem) {
            BakedModel model;
            Block block = ((BlockItem)item).m_40614_();
            transformType = block instanceof TorchBlock ? TransformType.BLOCK_STICK : ((model = itemRenderer.m_174264_(itemStack, (Level)VisorClientImpl.MC.f_91073_, (LivingEntity)VisorClientImpl.MC.f_91074_, 0)).m_7539_() ? TransformType.BLOCK_3D : TransformType.BLOCK_ITEM);
        } else if (item instanceof MapItem) {
            transformType = TransformType.MAP;
        } else if (item instanceof BowItem) {
            transformType = TransformType.BOW;
        } else if (itemStack.m_41780_() == UseAnim.TOOT_HORN) {
            transformType = TransformType.HORN;
        } else if (ItemClassifier.SWORD.is(item)) {
            transformType = TransformType.SWORD;
        } else if (ItemClassifier.SHIELD.is(item)) {
            transformType = TransformType.SHIELD;
        } else if (ItemClassifier.SPEAR.is(item)) {
            transformType = TransformType.SPEAR;
        } else if (item instanceof CrossbowItem) {
            transformType = TransformType.CROSSBOW;
        } else if (item instanceof CompassItem || item == Items.f_42524_) {
            transformType = TransformType.COMPASS;
        } else if (VRItemPoseDefault.isTool(item)) {
            transformType = TransformType.TOOL;
            if (item instanceof FoodOnAStickItem || item instanceof FishingRodItem) {
                transformType = TransformType.FISHING_ROD;
            }
        }
        return transformType;
    }

    public static boolean isTool(Item item) {
        return item instanceof DiggerItem || item instanceof ArrowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item instanceof ShearsItem || item == Items.f_42500_ || item == Items.f_42585_ || item == Items.f_41911_ || item == Items.f_42000_ || item == Items.f_41978_ || item == Items.f_42398_ || item instanceof DebugStickItem || item instanceof FlintAndSteelItem || item instanceof BrushItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof PickaxeItem || item instanceof ShovelItem;
    }

    @Override
    public boolean canApplyPose(@NotNull AbstractClientPlayer player, @NotNull ControllerHand hand, @NotNull ItemStack itemStack) {
        return true;
    }

    @Override
    @NotNull
    public ElementPriority getPriority() {
        return ElementPriority.LOWEST;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private record PoseParams(Quaternionf preRotation, Quaternionf rotation, float offsetX, float offsetY, float offsetZ, float scale) {
    }

    public static enum TransformType {
        DEFAULT,
        BLOCK_3D,
        BLOCK_STICK,
        BLOCK_ITEM,
        SHIELD,
        SWORD,
        TOOL,
        FISHING_ROD,
        BOW,
        BOW_DRAWING,
        SPEAR,
        MAP,
        CONSUMABLE,
        CROSSBOW,
        TELESCOPE,
        COMPASS,
        HORN;

    }
}

