/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.decoration.registry;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.client.render.decoration.annotations.RegisterVRItemPose;
import me.phoenixra.visor.api.client.render.decoration.hand.VRHandItemPose;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VRHandItemPoseRegistry
implements VisorRegistry<VRHandItemPose> {
    private static final String REGISTRY_NAME = "VR Hand Item Poses";
    private static final String ELEMENT_NAME = "VRHandItemPose";
    private static final String ANNOTATION_NAME = "@RegisterVRItemPose";
    private final HashMap<String, VRHandItemPose> elementsMap = new HashMap();
    private final List<VRHandItemPose> sortedElements = new ArrayList<VRHandItemPose>();
    private final Collection<VRHandItemPose> allElements = Collections.unmodifiableCollection(this.elementsMap.values());

    public List<VRHandItemPose> getSortedElements() {
        return Collections.unmodifiableList(this.sortedElements);
    }

    @Override
    public void registerAddonPath(@NotNull VisorAddon addon) {
        String path = addon.getAddonPackagePath();
        if (path == null) {
            return;
        }
        List<Class<?>> annotated = ModLoader.get().getClassesAnnotated(RegisterVRItemPose.class, addon.getModId(), path);
        Narrator.LOGGER.info("Found {} {} to register in addon: '{}'", new Object[]{annotated.size(), ELEMENT_NAME, addon.getAddonId()});
        for (Class<?> clazz : annotated) {
            if (!VRHandItemPose.class.isAssignableFrom(clazz)) {
                Narrator.LOGGER.warn("{} is annotated with {} but does not implement {}", new Object[]{clazz.getName(), ANNOTATION_NAME, ELEMENT_NAME});
                continue;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(VisorAddon.class);
                VRHandItemPose element = (VRHandItemPose)constructor.newInstance(addon);
                this.registerElement(element);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to register {} from class: {}", (Object)ELEMENT_NAME, (Object)clazz.getName());
                LoggerUtils.printError(e);
            }
        }
    }

    @Override
    public void registerElement(@NotNull VRHandItemPose element) {
        VRHandItemPose previous = this.elementsMap.put(element.getId(), element);
        if (previous != null) {
            Narrator.LOGGER.info("Overriding existing {}: '{}' from addon '{}'", new Object[]{ELEMENT_NAME, previous.getId(), previous.getOwner().getAddonId()});
            this.sortedElements.remove(previous);
        } else {
            Narrator.LOGGER.info("Registered {}: '{}'", (Object)ELEMENT_NAME, (Object)element.getId());
        }
        this.sortedElements.add(element);
        Collections.sort(this.sortedElements);
    }

    @Override
    public VRHandItemPose unregisterElement(@NotNull String id) {
        VRHandItemPose removed = this.elementsMap.remove(id);
        if (removed != null) {
            this.sortedElements.remove(removed);
            Collections.sort(this.sortedElements);
            Narrator.LOGGER.info("Unregistered {}: '{}'", (Object)ELEMENT_NAME, (Object)removed.getId());
        }
        return removed;
    }

    @Override
    @Nullable
    public VRHandItemPose getElement(@NotNull String id) {
        return this.elementsMap.get(id);
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return REGISTRY_NAME;
    }

    public HashMap<String, VRHandItemPose> getElementsMap() {
        return this.elementsMap;
    }

    @Override
    public Collection<VRHandItemPose> getAllElements() {
        return this.allElements;
    }
}

