/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.List;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.VRShaders;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.utils.ClientUtils;
import me.phoenixra.visor.modified.client.WindowModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;

public class MirrorHelper {
    private MirrorHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void drawMirror() {
        switch (VRClientSettings.getMirrorMode()) {
            case OFF: {
                MirrorHelper.drawTextMirror("Mirror is OFF", true);
                break;
            }
            case GUI: {
                MirrorHelper.drawGuiMirror();
                break;
            }
            case CROPPED: {
                MirrorHelper.drawCroppedMirror();
                break;
            }
            case SINGLE: {
                MirrorHelper.drawSingleMirror();
                break;
            }
            case DUAL: {
                MirrorHelper.drawDualMirror();
                break;
            }
            case FIRST_PERSON: {
                MirrorHelper.drawFirstPersonMirror();
                break;
            }
            case THIRD_PERSON: {
                MirrorHelper.drawThirdPersonMirror();
                break;
            }
            case MIXED_REALITY: {
                VRShaders.getMixedReality().drawMirror();
            }
        }
    }

    private static void drawGuiMirror() {
        RenderTarget source = ClientContext.renderer.guiTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawCroppedMirror() {
        RenderTarget source = VRClientSettings.getMirrorEye() == EyeType.LEFT ? ClientContext.renderer.getTextureLeftEye().getRenderTarget() : ClientContext.renderer.getTextureRightEye().getRenderTarget();
        float xCrop = VRClientSettings.getMirrorCrop();
        float yCrop = VRClientSettings.getMirrorCrop();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blitCropped(source, 0, 0, screenWidth, screenHeight, xCrop, yCrop, true);
    }

    private static void drawSingleMirror() {
        RenderTarget source = VRClientSettings.getMirrorEye() == EyeType.LEFT ? ClientContext.renderer.getTextureLeftEye().getRenderTarget() : ClientContext.renderer.getTextureRightEye().getRenderTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawFirstPersonMirror() {
        RenderTarget source = ClientContext.renderer.firstPersonTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawThirdPersonMirror() {
        RenderTarget source = ClientContext.renderer.thirdPersonTarget.getTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth();
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blit(source, 0, 0, screenWidth, screenHeight);
    }

    private static void drawDualMirror() {
        RenderTarget leftEye = ClientContext.renderer.getTextureLeftEye().getRenderTarget();
        RenderTarget rightEye = ClientContext.renderer.getTextureRightEye().getRenderTarget();
        int screenWidth = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenWidth() / 2;
        int screenHeight = ((WindowModified)VisorClientImpl.MC.m_91268_()).visor$getActualScreenHeight();
        MirrorHelper.blit(leftEye, 0, 0, screenWidth, screenHeight);
        MirrorHelper.blit(rightEye, screenWidth, 0, VisorClientImpl.MC.f_91042_.f_83915_, screenHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawTextMirror(String text, boolean clearBackground) {
        int CLEAR_DEPTH_FLAG = 256;
        int CLEAR_COLOR_FLAG = 16384;
        int TEXT_COLOR = 0xFFFFFF;
        int CHAR_WIDTH = 22;
        int LINE_HEIGHT = 5;
        boolean TEXT_X_OFFSET = true;
        float NEAR_PLANE = 1000.0f;
        float FAR_PLANE = 3000.0f;
        float CAMERA_Z = 2000.0f;
        float TEXT_SCALE = 2.0f;
        WindowModified window = (WindowModified)VisorClientImpl.MC.m_91268_();
        int vrWidth = window.visor$getActualScreenWidth();
        int vrHeight = window.visor$getActualScreenHeight();
        RenderSystem.viewport((int)0, (int)0, (int)vrWidth, (int)vrHeight);
        Matrix4f proj = new Matrix4f().setOrtho(0.0f, (float)vrWidth, (float)vrHeight, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)proj, (VertexSorting)VertexSorting.f_276633_);
        PoseStack mv = RenderSystem.getModelViewStack();
        mv.m_85836_();
        try {
            mv.m_166856_();
            mv.m_252880_(0.0f, 0.0f, -2000.0f);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            int flags = 0x100 | (clearBackground ? 16384 : 0);
            RenderSystem.clear((int)flags, (boolean)Minecraft.f_91002_);
            if (clearBackground) {
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            }
            GuiGraphics gui = new GuiGraphics(VisorClientImpl.MC, VisorClientImpl.MC.m_91269_().m_110104_());
            gui.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
            int wrapWidth = vrWidth / 22;
            List<String> lines = text == null ? List.of() : ClientUtils.wrapText(text, wrapWidth);
            int y = 5;
            for (String line : lines) {
                gui.m_280488_(VisorClientImpl.MC.f_91062_, line, 1, y, 0xFFFFFF);
                y += 5;
            }
            gui.m_280262_();
        }
        finally {
            mv.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void blit(RenderTarget source, int left, int top, int right, int bottom) {
        GlStateManager._glBindFramebuffer((int)36008, (int)source.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)source.f_83915_, (int)source.f_83916_, (int)left, (int)top, (int)right, (int)bottom, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public static void blitCropped(RenderTarget source, int left, int top, int right, int bottom, float xCropFactor, float yCropFactor, boolean keepAspect) {
        if (keepAspect) {
            float targetAspect = (float)VisorClientImpl.MC.f_91042_.f_83915_ / (float)VisorClientImpl.MC.f_91042_.f_83916_;
            float sourceAspect = (float)source.f_83917_ / (float)source.f_83918_;
            if (targetAspect > sourceAspect) {
                yCropFactor = 0.5f - sourceAspect / targetAspect * (0.5f - yCropFactor);
            } else {
                xCropFactor = 0.5f - targetAspect / sourceAspect * (0.5f - xCropFactor);
            }
        }
        int xMin = (int)(xCropFactor * (float)source.f_83915_);
        int yMin = (int)(yCropFactor * (float)source.f_83916_);
        int xMax = source.f_83915_ - xMin;
        int yMax = source.f_83916_ - yMin;
        GlStateManager._glBindFramebuffer((int)36008, (int)source.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)xMin, (int)yMin, (int)xMax, (int)yMax, (int)left, (int)top, (int)right, (int)bottom, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }
}

