/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.helpers.VREffectsHelper;
import me.phoenixra.visor.mixin.client.accessors.RenderSystemAccessor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHelper {
    private RenderHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static boolean isInSolidBlock(Vector3fc in) {
        if (VisorClientImpl.MC.f_91073_ == null) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)new Vec3((Vector3f)in));
        return VisorClientImpl.MC.f_91073_.m_8055_(blockpos).m_60804_((BlockGetter)VisorClientImpl.MC.f_91073_, blockpos);
    }

    public static void renderCuboid(BufferBuilder bufferBuilder, Matrix4f poseMatrix, Vector3fc start, Vector3fc end, float innerWidth, float outerWidth, float innerHeight, float outerHeight, AtumColor color) {
        Vector3f forward = end.sub(start, new Vector3f()).normalize();
        Vector3f right = forward.cross(VRMathUtils.UP_VECTOR, new Vector3f()).normalize();
        Vector3f up = right.cross((Vector3fc)forward, new Vector3f()).normalize();
        Vector3f r0 = right.mul(innerWidth, new Vector3f());
        Vector3f r1 = right.mul(outerWidth, new Vector3f());
        Vector3f u0 = up.mul(innerHeight, new Vector3f());
        Vector3f u1 = up.mul(outerHeight, new Vector3f());
        Vector3fc[][] corners = new Vector3fc[][]{{start, r0, u0}, {start, r1, u0}, {start, r1, u1}, {start, r0, u1}, {end, r0, u0}, {end, r1, u0}, {end, r1, u1}, {end, r0, u1}};
        int[][] faceIndices = new int[][]{{0, 3, 2, 1}, {4, 5, 6, 7}, {1, 2, 6, 5}, {0, 4, 7, 3}, {3, 7, 6, 2}, {0, 1, 5, 4}};
        Vector3f[] faceNormals = new Vector3f[]{forward, forward.mul(-1.0f, new Vector3f()).normalize(), right, right.mul(-1.0f, new Vector3f()).normalize(), up, up.mul(-1.0f, new Vector3f()).normalize()};
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        for (int f = 0; f < faceIndices.length; ++f) {
            Vector3f normal = faceNormals[f];
            for (int idx : faceIndices[f]) {
                Vector3fc base = corners[idx][0];
                Vector3fc xOff = corners[idx][1];
                Vector3fc yOff = corners[idx][2];
                Vector3f pos = base.add(xOff, new Vector3f()).add(yOff);
                RenderHelper.addVertex(bufferBuilder, poseMatrix, (Vector3fc)pos, color, (Vector3fc)normal);
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void renderFlatQuad(BufferBuilder bufferBuilder, Matrix4f poseMatrix, Vector3fc pos, float width, float height, float yaw, AtumColor color) {
        float halfW = width * 0.5f;
        float halfH = height * 0.5f;
        Vector3f off = new Vector3f(halfW, 0.0f, halfH).rotateY((float)Math.toRadians(-yaw));
        Vector3fc normal = VRMathUtils.UP_VECTOR;
        float xOff = off.x;
        float zOff = off.z;
        float r = color.getRed();
        float g = color.getGreen();
        float b = color.getBlue();
        float a = color.getAlpha();
        float[][] vertices = new float[][]{{pos.x() + xOff, pos.y(), pos.z() + zOff}, {pos.x() + xOff, pos.y(), pos.z() - zOff}, {pos.x() - xOff, pos.y(), pos.z() - zOff}, {pos.x() - xOff, pos.y(), pos.z() + zOff}};
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        for (float[] vertex : vertices) {
            bufferBuilder.m_252986_(poseMatrix, vertex[0], vertex[1], vertex[2]).m_85950_(r, g, b, a).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void renderDisplayQuad(Matrix4f poseMatrix, AtumColor color, float displayWidth, float displayHeight, float size) {
        float aspect = displayHeight / displayWidth;
        float halfSize = size * 0.5f;
        float halfHeight = halfSize * aspect;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float r = color.getRed();
        float g = color.getGreen();
        float b = color.getBlue();
        float a = color.getAlpha();
        float[][] vertices = new float[][]{{-halfSize, -halfHeight, 0.0f, u0, v0}, {halfSize, -halfHeight, 0.0f, u1, v0}, {halfSize, halfHeight, 0.0f, u1, v1}, {-halfSize, halfHeight, 0.0f, u0, v1}};
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (float[] vertex : vertices) {
            buf.m_252986_(poseMatrix, vertex[0], vertex[1], vertex[2]).m_7421_(vertex[3], vertex[4]).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderDisplayQuadWithLight(Matrix4f poseMatrix, AtumColor color, float displayWidth, float displayHeight, float size, int light, boolean flipY) {
        RenderHelper.renderDisplayQuadWithLight(poseMatrix, color, GameRenderer::m_172667_, displayWidth, displayHeight, size, light, flipY);
    }

    public static void renderDisplayQuadWithLight(Matrix4f poseMatrix, AtumColor color, Supplier<ShaderInstance> shader, float displayWidth, float displayHeight, float size, int light, boolean flipY) {
        float red = color.getRed();
        float green = color.getGreen();
        float blue = color.getBlue();
        float alpha = color.getAlpha();
        float aspect = displayHeight / displayWidth;
        float halfSize = size * 0.5f;
        float halfHeight = halfSize * aspect;
        float uMin = 0.0f;
        float uMax = 1.0f;
        float vMin = flipY ? 1.0f : 0.0f;
        float vMax = flipY ? 0.0f : 1.0f;
        float[][] pos = new float[][]{{-halfSize, -halfHeight}, {halfSize, -halfHeight}, {halfSize, halfHeight}, {-halfSize, halfHeight}};
        float[][] uv = new float[][]{{uMin, vMin}, {uMax, vMin}, {uMax, vMax}, {uMin, vMax}};
        RenderSystem.setShader(shader);
        VisorClientImpl.MC.f_91063_.m_109154_().m_109896_();
        VisorClientImpl.MC.f_91063_.m_109155_().m_118087_();
        Vector3f[] oldLights = RenderSystemAccessor.getShaderLightDirections();
        Vector3f old0 = oldLights[0];
        Vector3f old1 = oldLights[1];
        Vector3f forward = (Vector3f)VRMathUtils.FORWARD_VECTOR;
        RenderSystem.setShaderLights((Vector3f)forward, (Vector3f)forward);
        RenderSystem.setupShaderLights((ShaderInstance)RenderSystem.getShader());
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        for (int i = 0; i < 4; ++i) {
            float x = pos[i][0];
            float y = pos[i][1];
            float u = uv[i][0];
            float v = uv[i][1];
            buf.m_252986_(poseMatrix, x, y, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        VisorClientImpl.MC.f_91063_.m_109154_().m_109891_();
        if (old0 != null && old1 != null) {
            RenderSystem.setShaderLights((Vector3f)old0, (Vector3f)old1);
            RenderSystem.setupShaderLights((ShaderInstance)RenderSystem.getShader());
        }
    }

    public static Optional<VREffectsHelper.NearestOpaqueBlock> findNearestSolidBlock(Vec3 origin, double radius) {
        ClientLevel level = VisorClientImpl.MC.f_91073_;
        if (level == null) {
            return Optional.empty();
        }
        AABB box = new AABB(origin.m_82492_(radius, radius, radius), origin.m_82520_(radius, radius, radius));
        return BlockPos.m_121921_((AABB)box).filter(pos -> level.m_8055_(pos).m_60804_((BlockGetter)level, pos)).map(pos -> {
            float dist = (float)Vec3.m_82512_((Vec3i)pos).m_82554_(origin);
            return new VREffectsHelper.NearestOpaqueBlock(dist, level.m_8055_(pos), (BlockPos)pos);
        }).min(Comparator.comparingDouble(VREffectsHelper.NearestOpaqueBlock::distance));
    }

    private static void addVertex(BufferBuilder buff, Matrix4f mat, Vector3fc pos, AtumColor color, Vector3fc normal) {
        buff.m_252986_(mat, pos.x(), pos.y(), pos.z()).m_6122_(color.getRedInt(), color.getGreenInt(), color.getBlueInt(), (int)((byte)color.getAlphaInt())).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }
}

