/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.vertex.PoseStack;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderPoseHelper {
    private RenderPoseHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void applyDisplayPose(VRDisplay vrDisplay, PoseStack poseStack) {
        RenderPoseHelper.applyDisplayOrientation(vrDisplay, poseStack);
        RenderPoseHelper.applyDisplayTranslation(vrDisplay, poseStack);
    }

    public static void applyDisplayOrientation(VRDisplay vrDisplay, PoseStack poseStack) {
        float mirrorSmooth = VRClientSettings.getMirrorSmooth();
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        boolean smooth = vrDisplay == VRDisplay.FIRST_PERSON && mirrorSmooth > 0.0f;
        Matrix4f rotationMatrix = smooth ? new Matrix4f().rotation((Quaternionfc)ClientContext.rawPoseHandler.getHmdData().getRotationHistory().averageRotation(mirrorSmooth)) : renderPose.getElementForDisplay(vrDisplay).getRotation().transpose(new Matrix4f());
        poseStack.m_85850_().m_252922_().mul((Matrix4fc)rotationMatrix);
        poseStack.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f((Matrix4fc)rotationMatrix));
    }

    public static void applyDisplayTranslation(VRDisplay vrDisplay, PoseStack poseStack) {
        if (!vrDisplay.isEye()) {
            return;
        }
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3fc eyePos = renderPose.getElementForDisplay(vrDisplay).getPosition();
        Vector3fc hmdOrigin = renderPose.getHmd().getPosition();
        Vector3f offset = eyePos.sub(hmdOrigin, new Vector3f());
        poseStack.m_252880_(-offset.x, -offset.y, -offset.z);
    }

    public static void applyControllerPose(ControllerHand hand, PoseStack poseStack) {
        PoseDataImpl renderPose = ClientContext.player.getPoseData(PoseDataType.RENDER);
        Vector3fc controllerPos = RenderPoseHelper.getControllerPosition(hand);
        Vector3fc cameraPos = RenderPoseHelper.getCameraPosition(VRRenderState.getCurrentVRDisplay(), renderPose);
        Vector3f relative = controllerPos.sub(cameraPos, new Vector3f());
        poseStack.m_252880_(relative.x, relative.y, relative.z);
        Matrix4f invRot = renderPose.getController(hand).getRotation().invert(new Matrix4f()).transpose(new Matrix4f());
        poseStack.m_85850_().m_252922_().mul((Matrix4fc)invRot);
        float s = renderPose.getWorldScale();
        poseStack.m_85841_(s, s, s);
    }

    public static Vector3fc getCameraPosition(VRDisplay vrDisplay, PoseData vrPose) {
        boolean smooth;
        float mirrorSmooth = VRClientSettings.getMirrorSmooth();
        boolean bl = smooth = vrDisplay == VRDisplay.FIRST_PERSON && mirrorSmooth > 0.0f;
        if (smooth) {
            Vector3f avg = ClientContext.rawPoseHandler.getHmdData().getPositionHistory().averagePosition(mirrorSmooth);
            return avg.mul(vrPose.getWorldScale()).rotateY(vrPose.getRotationY()).add(vrPose.getOrigin());
        }
        return vrPose.getElementForDisplay(vrDisplay).getPosition();
    }

    public static Vector3fc getControllerPosition(ControllerHand hand) {
        return ClientContext.player.getPoseData(PoseDataType.RENDER).getController(hand).getPosition();
    }
}

