/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.NotNull;

public class RenderShaderHelper {
    private static final double[] POS_X = new double[]{-1.0, 1.0, -1.0, 1.0};
    private static final double[] POS_Y = new double[]{-1.0, -1.0, 1.0, 1.0};
    private static final float[] UV_U = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
    private static final float[] UV_V = new float[]{0.0f, 0.0f, 1.0f, 1.0f};

    private RenderShaderHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void renderFullscreenQuad(@NotNull ShaderInstance shader, @NotNull RenderTarget source) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        shader.m_173350_("Sampler0", (Object)source.m_83975_());
        shader.m_173363_();
        RenderShaderHelper.renderFullscreenQuad(shader.m_173364_());
        shader.m_173362_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void renderFullscreenQuad(VertexFormat format) {
        if (format != DefaultVertexFormat.f_85817_ && format != DefaultVertexFormat.f_85819_) {
            throw new RuntimeException("Unexpected vertex format " + String.valueOf(format));
        }
        boolean needColor = format == DefaultVertexFormat.f_85819_;
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, format);
        for (int i = 0; i < 4; ++i) {
            VertexConsumer v = buf.m_5483_(POS_X[i], POS_Y[i], 0.0).m_7421_(UV_U[i], UV_V[i]);
            if (needColor) {
                v.m_6122_(255, 255, 255, 255);
            }
            v.m_5752_();
        }
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)buf.m_231175_());
    }
}

