/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.visor.api.client.gui.helpers.TexturesHelper;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.VRRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL11C;

public class VREffectsHelper {
    private static boolean stencilEnabledByVisor;

    private VREffectsHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void renderInBlockEffect() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f mat = new Matrix4f();
        mat.m00(1.0f);
        mat.m11(1.0f);
        mat.m22(-1.0f);
        mat.m33(1.0f);
        mat.m32(-1.0f);
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_252986_(mat, -1.5f, -1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 1.5f, -1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, 1.5f, 1.5f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(mat, -1.5f, 1.5f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawEyeStencil() {
        stencilEnabledByVisor = GL11C.glIsEnabled((int)2960);
        if (VRRenderState.getCurrentVRDisplay().isEye()) {
            VREffectsHelper.doStencil(false);
        }
    }

    public static void disableStencilTest() {
        if (!stencilEnabledByVisor) {
            GL11C.glDisable((int)2960);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doStencil(boolean inverse) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget rt = mc.m_91385_();
        int prevProgram = GL11.glGetInteger((int)35725);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.getModelViewStack().m_85836_();
        try {
            VREffectsHelper.enableStencilTest();
            VREffectsHelper.configureStencilWrite(inverse);
            VREffectsHelper.clearStencilAndDepth();
            VREffectsHelper.setupMaskDrawState();
            VREffectsHelper.applyOrthoProjection(rt, inverse);
            VRDisplay eye = VRRenderState.getCurrentVRDisplay();
            float[] maskVerts = VREffectsHelper.getStencilMask(eye);
            VREffectsHelper.drawStencilMask(maskVerts);
        }
        finally {
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.restoreProjectionMatrix();
            VREffectsHelper.restorePostStencilState(prevProgram);
        }
    }

    private static void enableStencilTest() {
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.stencilMask((int)255);
    }

    private static void configureStencilWrite(boolean inverse) {
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    private static void clearStencilAndDepth() {
        RenderSystem.clear((int)1280, (boolean)false);
    }

    private static void setupMaskDrawState() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private static void applyOrthoProjection(RenderTarget rt, boolean inverse) {
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)rt.f_83917_, 0.0f, (float)rt.f_83918_, 0.0f, 20.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.f_276633_);
        if (inverse) {
            RenderSystem.getModelViewStack().m_252880_(0.0f, 0.0f, -20.0f);
        }
        RenderSystem.applyModelViewMatrix();
    }

    private static float[] getStencilMask(VRDisplay eye) {
        if (eye != VRDisplay.EYE_LEFT && eye != VRDisplay.EYE_RIGHT) {
            return null;
        }
        VRRendererBase renderer = ClientContext.renderer;
        return eye == VRDisplay.EYE_LEFT ? renderer.getHiddenAreaVertices(EyeType.LEFT) : renderer.getHiddenAreaVertices(EyeType.RIGHT);
    }

    private static void drawStencilMask(float[] verts) {
        if (verts == null || verts.length < 2) {
            return;
        }
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
        Minecraft.m_91087_().m_91097_().m_174784_(TexturesHelper.getBlackTexture());
        float scale = ClientContext.renderer.renderScale;
        for (int i = 0; i < verts.length; i += 2) {
            buf.m_5483_((double)(verts[i] * scale), (double)(verts[i + 1] * scale), 0.0).m_5752_();
        }
        RenderSystem.setShader(GameRenderer::m_172808_);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
    }

    private static void restorePostStencilState(int prevProgram) {
        ProgramManager.m_85578_((int)prevProgram);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.stencilFunc((int)517, (int)255, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        GL11.glDisable((int)2960);
    }

    public record NearestOpaqueBlock(float distance, BlockState state, BlockPos position) {
    }
}

