/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.player.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayerData;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.render.player.model.VRPlayerModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VRPlayerModelWithArms<T extends LivingEntity>
extends VRPlayerModel<T> {
    private final boolean slim;
    private final ModelPart leftShoulder;
    private final ModelPart rightShoulder;
    private final ModelPart leftShoulder_sleeve;
    private final ModelPart rightShoulder_sleeve;
    private final ModelPart leftHand;
    private final ModelPart rightHand;
    private boolean laying;

    public VRPlayerModelWithArms(ModelPart modelPart, boolean isSlim) {
        super(modelPart, isSlim);
        this.slim = isSlim;
        this.leftShoulder = modelPart.m_171324_("left_arm");
        this.rightShoulder = modelPart.m_171324_("right_arm");
        this.leftShoulder_sleeve = modelPart.m_171324_("leftShoulder_sleeve");
        this.rightShoulder_sleeve = modelPart.m_171324_("rightShoulder_sleeve");
        this.rightHand = modelPart.m_171324_("rightHand");
        this.leftHand = modelPart.m_171324_("leftHand");
        if (!this.leftShoulder.f_104212_.isEmpty()) {
            this.copyUV(((ModelPart.Cube)this.leftShoulder.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.leftHand.f_104212_.get((int)0)).f_104341_[1]);
            this.copyUV(((ModelPart.Cube)this.leftShoulder.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.leftHand.f_104212_.get((int)0)).f_104341_[0]);
        }
        if (!this.rightShoulder.f_104212_.isEmpty()) {
            this.copyUV(((ModelPart.Cube)this.rightShoulder.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.rightHand.f_104212_.get((int)0)).f_104341_[1]);
            this.copyUV(((ModelPart.Cube)this.rightShoulder.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.rightHand.f_104212_.get((int)0)).f_104341_[0]);
        }
        if (!this.f_103375_.f_104212_.isEmpty()) {
            this.copyUV(((ModelPart.Cube)this.rightShoulder_sleeve.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.f_103375_.f_104212_.get((int)0)).f_104341_[1]);
            this.copyUV(((ModelPart.Cube)this.rightShoulder_sleeve.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.f_103375_.f_104212_.get((int)0)).f_104341_[0]);
        }
        if (!this.f_103374_.f_104212_.isEmpty()) {
            this.copyUV(((ModelPart.Cube)this.leftShoulder_sleeve.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.f_103374_.f_104212_.get((int)0)).f_104341_[1]);
            this.copyUV(((ModelPart.Cube)this.leftShoulder_sleeve.f_104212_.get((int)0)).f_104341_[1], ((ModelPart.Cube)this.f_103374_.f_104212_.get((int)0)).f_104341_[0]);
        }
    }

    private void copyUV(ModelPart.Polygon source, ModelPart.Polygon dest) {
        for (int i = 0; i < source.f_104359_.length; ++i) {
            ModelPart.Vertex newVertex;
            dest.f_104359_[i] = newVertex = new ModelPart.Vertex(dest.f_104359_[i].f_104371_, source.f_104359_[i].f_104372_, source.f_104359_[i].f_104373_);
        }
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshdefinition = VRPlayerModel.createMesh(cubeDeformation, slim);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        if (slim) {
            partdefinition.m_171599_("leftHand", CubeListBuilder.m_171558_().m_171514_(32, 55).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("rightHand", CubeListBuilder.m_171558_().m_171514_(40, 23).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 39).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("leftShoulder_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("rightShoulder_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        } else {
            partdefinition.m_171599_("leftHand", CubeListBuilder.m_171558_().m_171514_(32, 55).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 55).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("rightHand", CubeListBuilder.m_171558_().m_171514_(40, 23).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 39).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("leftShoulder_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partdefinition.m_171599_("rightShoulder_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        }
        return meshdefinition;
    }

    @Override
    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VRRemotePlayerData remotePlayerData = VRRemotePlayers.getInstance().getPlayer(entity.m_20148_());
        if (remotePlayerData == null) {
            return;
        }
        double height = -1.501f * remotePlayerData.heightScale();
        float offhandYaw = (float)Mth.m_14136_((double)(-remotePlayerData.offhandDirection().x()), (double)(-remotePlayerData.offhandDirection().z()));
        float offhandPitch = (float)Math.asin(remotePlayerData.offhandDirection().y() / remotePlayerData.offhandDirection().length());
        float mainHandYaw = (float)Mth.m_14136_((double)(-remotePlayerData.mainHandDirection().x()), (double)(-remotePlayerData.mainHandDirection().z()));
        float mainHandPitch = (float)Math.asin(remotePlayerData.mainHandDirection().y() / remotePlayerData.mainHandDirection().length());
        double bodyYaw = remotePlayerData.getBodyYawRad();
        boolean bl = this.laying = this.f_102818_ > 0.0f || entity.m_21255_() && !entity.m_21209_();
        if (!remotePlayerData.leftHanded()) {
            this.rightShoulder.m_104227_(-Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f, this.slim ? 2.5f : 2.0f, Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f);
            this.leftShoulder.m_104227_(Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f, this.slim ? 2.5f : 2.0f, -Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f);
        } else {
            this.leftShoulder.m_104227_(-Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f, this.slim ? 2.5f : 2.0f, Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f);
            this.rightShoulder.m_104227_(Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f, this.slim ? 2.5f : 2.0f, -Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f);
        }
        if (this.f_102817_) {
            this.rightShoulder.f_104201_ += 3.2f;
            this.leftShoulder.f_104201_ += 3.2f;
        }
        Vector3f offhandArmPos = remotePlayerData.offhandPosition().add(0.0f, (float)height, 0.0f, new Vector3f()).rotateY((float)(-Math.PI + bodyYaw)).mul(16.0f / remotePlayerData.heightScale());
        this.leftHand.m_104227_(-offhandArmPos.x, -offhandArmPos.y, offhandArmPos.z);
        this.leftHand.f_104203_ = (float)((double)(-offhandPitch) + 4.71238898038469);
        this.leftHand.f_104204_ = (float)(Math.PI - (double)offhandYaw - bodyYaw);
        this.leftHand.f_104205_ = 0.0f;
        Vector3f leftShoulderPos = new Vector3f(this.leftShoulder.f_104200_ + offhandArmPos.x, this.leftShoulder.f_104201_ + offhandArmPos.y, this.leftShoulder.f_104202_ - offhandArmPos.z);
        float leftShoulderYaw = (float)Mth.m_14136_((double)leftShoulderPos.x(), (double)leftShoulderPos.z());
        float leftShoulderPitch = (float)(4.71238898038469 - Math.asin(leftShoulderPos.y() / leftShoulderPos.length()));
        this.leftShoulder.f_104205_ = 0.0f;
        this.leftShoulder.f_104203_ = leftShoulderPitch;
        this.leftShoulder.f_104204_ = leftShoulderYaw;
        if (this.leftShoulder.f_104204_ > 0.0f) {
            this.leftShoulder.f_104204_ = 0.0f;
        }
        if (this.f_102815_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            this.leftHand.f_104203_ = (float)((double)this.leftHand.f_104203_ - 1.5707963267948966);
        }
        Vector3f mainArm = remotePlayerData.mainHandPosition().add(0.0f, (float)height, 0.0f, new Vector3f()).rotateY((float)(-Math.PI + bodyYaw)).mul(16.0f / remotePlayerData.heightScale());
        this.rightHand.m_104227_(-mainArm.x, -mainArm.y, mainArm.z);
        this.rightHand.f_104203_ = (float)((double)(-mainHandPitch) + 4.71238898038469);
        this.rightHand.f_104204_ = (float)(Math.PI - (double)mainHandYaw - bodyYaw);
        this.rightHand.f_104205_ = 0.0f;
        Vec3 rightShoulderPos = new Vec3((double)this.rightShoulder.f_104200_ + (double)mainArm.x, (double)this.rightShoulder.f_104201_ + (double)mainArm.y, (double)this.rightShoulder.f_104202_ - (double)mainArm.z);
        float rightShoulderYaw = (float)Mth.m_14136_((double)rightShoulderPos.f_82479_, (double)rightShoulderPos.f_82481_);
        float rightShoulderPitch = (float)(4.71238898038469 - Math.asin(rightShoulderPos.f_82480_ / rightShoulderPos.m_82553_()));
        this.rightShoulder.f_104205_ = 0.0f;
        this.rightShoulder.f_104203_ = rightShoulderPitch;
        this.rightShoulder.f_104204_ = rightShoulderYaw;
        if (this.rightShoulder.f_104204_ < 0.0f) {
            this.rightShoulder.f_104204_ = 0.0f;
        }
        if (this.f_102816_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            this.rightHand.f_104203_ = (float)((double)this.rightHand.f_104203_ - 1.5707963267948966);
        }
        if (this.laying) {
            this.rightShoulder.f_104203_ = (float)((double)this.rightShoulder.f_104203_ - 1.5707963267948966);
            this.leftShoulder.f_104203_ = (float)((double)this.leftShoulder.f_104203_ - 1.5707963267948966);
        }
        this.f_103374_.m_104315_(this.leftHand);
        this.f_103375_.m_104315_(this.rightHand);
        this.leftShoulder_sleeve.m_104315_(this.leftShoulder);
        this.rightShoulder_sleeve.m_104315_(this.rightShoulder);
        this.leftShoulder_sleeve.f_104207_ = this.f_103374_.f_104207_;
        this.rightShoulder_sleeve.f_104207_ = this.f_103375_.f_104207_;
    }

    public void m_8009_(boolean flag) {
        super.m_8009_(flag);
        this.rightShoulder.f_104207_ = flag;
        this.leftShoulder.f_104207_ = flag;
        this.rightShoulder_sleeve.f_104207_ = flag;
        this.leftShoulder_sleeve.f_104207_ = flag;
        this.rightHand.f_104207_ = flag;
        this.leftHand.f_104207_ = flag;
    }

    protected ModelPart m_102851_(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftHand : this.rightHand;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        ModelPart armModel = this.m_102851_(arm);
        if (this.laying) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        }
        armModel.m_104299_(poseStack);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI))));
        poseStack.m_85837_(0.0, -0.5, 0.0);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.leftHand, (Object)this.rightHand, (Object)this.leftShoulder, (Object)this.rightShoulder, (Object)this.leftShoulder_sleeve, (Object)this.rightShoulder_sleeve, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_, (Object)this.f_103376_, (Object)this.f_103377_, (Object[])new ModelPart[]{this.f_103374_, this.f_103375_, this.f_103378_});
    }

    public ModelPart getLeftHand() {
        return this.leftHand;
    }

    public ModelPart getRightHand() {
        return this.rightHand;
    }
}

