/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.shaders;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.data.PoseElementImpl;
import me.phoenixra.visor.core.client.render.helpers.MirrorHelper;
import me.phoenixra.visor.core.client.render.helpers.RenderShaderHelper;
import me.phoenixra.visor.core.client.render.shaders.VRShader;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.modified.client.WindowModified;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRShaderMixedReality
implements VRShader {
    private ShaderInstance handle;
    private AbstractUniform uHmdViewPosition;
    private AbstractUniform uHmdPlaneNormal;
    private AbstractUniform uInverseProjectionView;
    private AbstractUniform uAsGrid2x2;
    private AbstractUniform uKeyColor;
    private AbstractUniform uAlphaMode;

    @Override
    public void init() throws Exception {
        this.handle = new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), "vr_mixed_reality", DefaultVertexFormat.f_85817_);
        this.uAsGrid2x2 = this.handle.m_173356_("uAsGrid2x2");
        this.uAlphaMode = this.handle.m_173356_("uAlphaMode");
        this.uHmdViewPosition = this.handle.m_173356_("uHmdViewPosition");
        this.uHmdPlaneNormal = this.handle.m_173356_("uHmdPlaneNormal");
        this.uInverseProjectionView = this.handle.m_173356_("uInverseProjectionView");
        this.uKeyColor = this.handle.m_173356_("uKeyColor");
    }

    public void drawMirror() {
        WindowModified mcWindow = (WindowModified)VisorClientImpl.MC.m_91268_();
        RenderSystem.viewport((int)0, (int)0, (int)mcWindow.visor$getActualScreenWidth(), (int)mcWindow.visor$getActualScreenHeight());
        boolean asGrid2x2 = VRClientSettings.isMixedRealityAsGrid2x2();
        boolean alphaMask = asGrid2x2 && VRClientSettings.isMixedRealityAlphaMask();
        boolean withFirstPerson = VRClientSettings.isMixedRealityWithFirstPerson();
        PoseDataImpl roomPose = ClientContext.player.getPoseData(PoseDataType.ROOM);
        PoseElementImpl cameraElement = roomPose.getThirdPersonCamera();
        Vector3f cameraPos = roomPose.getHeadPivot().sub(cameraElement.getPosition(), new Vector3f());
        Matrix4f cameraRotation = cameraElement.getRotation().transpose(new Matrix4f());
        Vector3fc cameraDir = cameraElement.getDirection();
        Matrix4f proj = ((GameRendererModified)VisorClientImpl.MC.f_91063_).visor$getThirdPersonProjection();
        Matrix4f invProjView = new Matrix4f((Matrix4fc)proj).mul((Matrix4fc)cameraRotation).invert();
        this.uInverseProjectionView.m_5679_(invProjView);
        this.uAlphaMode.m_142617_(alphaMask ? 1 : 0);
        this.uAsGrid2x2.m_142617_(asGrid2x2 ? 1 : 0);
        this.uHmdViewPosition.m_5889_(cameraPos.x, cameraPos.y, cameraPos.z);
        this.uHmdPlaneNormal.m_5889_(-cameraDir.x(), 0.0f, -cameraDir.z());
        if (!alphaMask) {
            AtumColor color = VRClientSettings.getMixedRealityKeyColor();
            this.uKeyColor.m_5889_(color.getRed(), color.getGreen(), color.getBlue());
        } else {
            this.uKeyColor.m_5889_(0.0f, 0.0f, 0.0f);
        }
        RenderTarget target = ClientContext.renderer.thirdPersonTarget.getTarget();
        this.handle.m_173350_("SamplerColor", (Object)target.m_83975_());
        this.handle.m_173350_("SamplerDepth", (Object)target.m_83980_());
        this.handle.m_173363_();
        RenderShaderHelper.renderFullscreenQuad(this.handle.m_173364_());
        this.handle.m_173362_();
        if (asGrid2x2) {
            RenderTarget source = withFirstPerson ? ClientContext.renderer.firstPersonTarget.getTarget() : (VRClientSettings.getMirrorEye() == EyeType.LEFT ? ClientContext.renderer.getTextureLeftEye().getRenderTarget() : ClientContext.renderer.getTextureRightEye().getRenderTarget());
            MirrorHelper.blit(source, VisorClientImpl.MC.f_91042_.f_83915_ / 2, 0, VisorClientImpl.MC.f_91042_.f_83915_, VisorClientImpl.MC.f_91042_.f_83916_ / 2);
        }
    }

    @Override
    public ShaderInstance getHandle() {
        return this.handle;
    }
}

