/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.shaders;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.helpers.RenderShaderHelper;
import me.phoenixra.visor.core.client.render.shaders.VRShader;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;

public class VRShaderPostProcessEye
implements VRShader {
    private static final AtumColor PUMPKIN_VIGNETTE_COLOR = AtumColor.ORANGE.blend(AtumColor.BLACK, 0.5f);
    private ShaderInstance handle;
    private AbstractUniform uniformEye;
    private AbstractUniform uVignetteRadius;
    private AbstractUniform uVignetteOffset;
    private AbstractUniform uVignetteBorder;
    private AbstractUniform uVignetteColor;
    private AbstractUniform uTintRed;
    private AbstractUniform uTintBlue;
    private AbstractUniform uTintBlack;

    @Override
    public void init() throws Exception {
        this.handle = new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), "vr_post_process_eye", DefaultVertexFormat.f_85817_);
        this.uniformEye = this.handle.m_173356_("uEye");
        this.uTintRed = this.handle.m_173356_("uTintRed");
        this.uTintBlue = this.handle.m_173356_("uTintBlue");
        this.uTintBlack = this.handle.m_173356_("uTintBlack");
        this.uVignetteRadius = this.handle.m_173356_("uVignetteRadius");
        this.uVignetteOffset = this.handle.m_173356_("uVignetteOffset");
        this.uVignetteBorder = this.handle.m_173356_("uVignetteBorder");
        this.uVignetteColor = this.handle.m_173356_("uVignetteColor");
    }

    public void finishEye(EyeType eye, RenderTarget source, float partialTicks) {
        if (eye == EyeType.LEFT) {
            this.updateUniforms(partialTicks);
        }
        this.uniformEye.m_142617_(eye == EyeType.LEFT ? 1 : -1);
        RenderShaderHelper.renderFullscreenQuad(this.handle, source);
        GLUtils.checkGLError("post process eye: " + eye.name());
    }

    private void updateUniforms(float partialTicks) {
        boolean canApplyEffects = VisorClientImpl.MC.f_91073_ != null && VisorClientImpl.MC.f_91074_ != null && !VisorClientImpl.MC.f_91074_.m_5833_();
        float time = (float)Util.m_137550_() / 1000.0f;
        float redTint = 0.0f;
        float blueTint = 0.0f;
        float blackTint = 0.0f;
        float vignetteRadius = 1.0f;
        float vignetteBorder = 0.06f;
        AtumColor vignetteColor = AtumColor.BLACK;
        if (canApplyEffects) {
            if (VisorClientImpl.MC.f_91074_.m_7500_()) {
                redTint = 0.0f;
            } else {
                float hurtTimer = (float)VisorClientImpl.MC.f_91074_.f_20916_ - partialTicks;
                float healthPercent = 1.0f - VisorClientImpl.MC.f_91074_.m_21223_() / VisorClientImpl.MC.f_91074_.m_21233_();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (VRClientSettings.isHitIndicatorEnabled() && hurtTimer > 0.0f) {
                    hurtTimer /= (float)VisorClientImpl.MC.f_91074_.f_20917_;
                    redTint = hurtTimer = healthPercent + Mth.m_14031_((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (VRClientSettings.isLowHealthIndicatorEnabled()) {
                    redTint = healthPercent * Mth.m_14154_((float)Mth.m_14031_((float)(2.5f * time / (1.0f - healthPercent + 0.1f))));
                }
            }
            if (VRClientSettings.isFreezeEffectEnabled()) {
                boolean hasFreezeEffect;
                float freeze = VisorClientImpl.MC.f_91074_.m_146889_();
                boolean bl = hasFreezeEffect = freeze > 0.0f;
                if (hasFreezeEffect) {
                    blueTint = redTint;
                    blueTint = Math.max(freeze / 2.0f, blueTint);
                    redTint = 0.0f;
                }
            }
            if (VisorClientImpl.MC.f_91074_.m_5803_()) {
                blackTint = 0.5f + 0.3f * (float)VisorClientImpl.MC.f_91074_.m_36318_() * 0.01f;
            }
            ItemStack headItem = VisorClientImpl.MC.f_91074_.m_150109_().m_36052_(3);
            if (VRClientSettings.isPumpkinEffectEnabled()) {
                boolean hasPumpkin;
                boolean bl = hasPumpkin = headItem.m_41720_() == Blocks.f_50143_.m_5456_() && (!headItem.m_41782_() || headItem.m_41783_().m_128451_("CustomModelData") == 0);
                if (hasPumpkin) {
                    vignetteColor = PUMPKIN_VIGNETTE_COLOR;
                    vignetteRadius = 0.3f;
                    vignetteBorder = 0.0f;
                }
            }
        }
        this.uTintRed.m_5985_(redTint);
        this.uTintBlue.m_5985_(blueTint);
        this.uTintBlack.m_5985_(blackTint);
        this.uVignetteRadius.m_5985_(vignetteRadius);
        this.uVignetteBorder.m_5985_(vignetteBorder);
        this.uVignetteOffset.m_5985_(0.1f);
        this.uVignetteColor.m_5805_(vignetteColor.getRed(), vignetteColor.getGreen(), vignetteColor.getBlue(), vignetteColor.getAlpha());
    }

    @Override
    public ShaderInstance getHandle() {
        return this.handle;
    }
}

