/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.render.target.types;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.HashMap;
import java.util.Map;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.render.target.RenderTargetHolder;
import me.phoenixra.visor.core.client.render.target.VRRenderTarget;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public class RenderTargetGUI
implements RenderTargetHolder {
    private RenderTarget target = null;
    private final HashMap<VROverlayScreen, VRRenderTarget> overlayTargets = new HashMap();
    private int savedWidth;
    private int savedHeight;
    private boolean init;

    @Override
    public void init(int width, int height) throws Exception {
        this.target = new VRRenderTarget("GUI", width, height, true, () -> -1, true, false);
        GLUtils.checkGLError("GUI target setup");
        VisorClientImpl.LOGGER.info(this.target.toString());
        this.overlayTargets.clear();
        for (VROverlay overlay : ClientContext.overlayManager.getOverlaysRegistry().getSortedElements()) {
            if (!(overlay instanceof VROverlayScreen)) continue;
            VROverlayScreen overlayScreen = (VROverlayScreen)overlay;
            if (!overlay.isVisible() || !overlay.isEnabled()) {
                this.overlayTargets.put(overlayScreen, null);
                overlayScreen.setRenderTarget(null);
                continue;
            }
            VRRenderTarget renderTarget = new VRRenderTarget("Overlay " + overlayScreen.getId(), overlayScreen.getRequestedWidth(), overlayScreen.getRequestedHeight(), true, () -> -1, true, false);
            GLUtils.checkGLError("Overlay " + overlayScreen.getId() + " framebuffer setup");
            this.overlayTargets.put(overlayScreen, renderTarget);
            overlayScreen.setRenderTarget(renderTarget);
        }
        this.savedWidth = width;
        this.savedHeight = height;
        this.init = true;
    }

    @Override
    public void resize(int width, int height) throws Exception {
        this.target.m_83941_(width, height, Minecraft.f_91002_);
        for (Map.Entry<VROverlayScreen, VRRenderTarget> entry : this.overlayTargets.entrySet()) {
            if (this.target == null) continue;
            VROverlayScreen overlay = entry.getKey();
            entry.getValue().m_83941_(overlay.getRequestedWidth(), overlay.getRequestedHeight(), Minecraft.f_91002_);
            overlay.updateSize();
        }
        if (VisorClientImpl.MC.f_91080_ != null) {
            int screenWidth = VisorClientImpl.MC.m_91268_().m_85445_();
            int screenHeight = VisorClientImpl.MC.m_91268_().m_85446_();
            VisorClientImpl.MC.f_91080_.m_6575_(VisorClientImpl.MC, screenWidth, screenHeight);
        }
        this.savedWidth = width;
        this.savedHeight = height;
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.m_83930_();
            this.target = null;
        }
        for (VRRenderTarget target : this.overlayTargets.values()) {
            if (target == null) continue;
            target.m_83930_();
        }
        this.overlayTargets.clear();
        this.init = false;
    }

    public void updateOverlayTarget(@NotNull VROverlayScreen overlayScreen) {
        VRRenderTarget renderTarget = this.overlayTargets.get(overlayScreen);
        boolean visible = overlayScreen.isVisible();
        if (renderTarget == null && visible) {
            renderTarget = new VRRenderTarget("Overlay " + overlayScreen.getId(), overlayScreen.getRequestedWidth(), overlayScreen.getRequestedHeight(), true, () -> -1, true, false);
            GLUtils.checkGLError("Overlay " + overlayScreen.getId() + " framebuffer setup");
            this.overlayTargets.put(overlayScreen, renderTarget);
        } else if (renderTarget != null && !visible) {
            renderTarget.m_83930_();
            this.overlayTargets.put(overlayScreen, null);
        } else if (renderTarget != null) {
            int neededWidth = overlayScreen.getRequestedWidth();
            int neededHeight = overlayScreen.getRequestedHeight();
            if (neededWidth != renderTarget.f_83915_ || neededHeight != renderTarget.f_83916_) {
                renderTarget.m_83930_();
                renderTarget.m_83941_(neededWidth, neededHeight, Minecraft.f_91002_);
                overlayScreen.updateSize();
            }
        }
        overlayScreen.setRenderTarget(this.overlayTargets.get(overlayScreen));
    }

    public RenderTarget getTarget() {
        return this.target;
    }

    public HashMap<VROverlayScreen, VRRenderTarget> getOverlayTargets() {
        return this.overlayTargets;
    }

    public int getSavedWidth() {
        return this.savedWidth;
    }

    public int getSavedHeight() {
        return this.savedHeight;
    }

    public boolean isInit() {
        return this.init;
    }
}

