/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.atumconfig.api.placeholders.PlaceholderHandler;
import me.phoenixra.atumconfig.api.placeholders.types.StaticPlaceholder;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.atumvr.api.misc.color.AtumColorMutable;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.VROptionCategory;
import me.phoenixra.visor.core.client.settings.VROptionWidgetType;
import me.phoenixra.visor.core.client.settings.options.VROptionField;
import me.phoenixra.visor.core.client.settings.options.VROptionRecord;
import me.phoenixra.visor.core.client.settings.overlays.OverlayConfigsManager;
import me.phoenixra.visor.core.client.utils.LangHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class VRClientSettingsHandler {
    public static VRClientSettingsHandler instance;
    private final Map<String, VROptionRecord> allOptions = new HashMap<String, VROptionRecord>();
    private final Map<String, VROptionWidgetType> optionWidgets = new HashMap<String, VROptionWidgetType>();
    private final ConfigFile settings;
    private Config defaultSettings;
    private final OverlayConfigsManager overlayConfigsAccessor;
    private boolean wasInit;

    public VRClientSettingsHandler() {
        instance = this;
        ConfigManager configManager = ClientContext.visor.getConfigManager();
        try {
            this.settings = configManager.createConfigFile(ConfigType.YAML, "settings", Path.of("settings.yml", new String[0]), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initOptionFields();
        this.updateDefaultOptions();
        this.loadOptions();
        this.saveOptions();
        this.overlayConfigsAccessor = new OverlayConfigsManager();
        PlaceholderHandler placeholderHandler = configManager.getPlaceholderHandler().get();
        if (!this.wasInit) {
            placeholderHandler.registerGlobalPlaceholder(new StaticPlaceholder("left_handed", () -> String.valueOf(VRClientSettings.isLeftHanded() ? 1 : 0)));
            placeholderHandler.registerGlobalPlaceholder(new StaticPlaceholder("right_handed", () -> String.valueOf(!VRClientSettings.isLeftHanded() ? 1 : 0)));
            placeholderHandler.registerGlobalPlaceholder(new StaticPlaceholder("main_hand", () -> String.valueOf(VRClientSettings.isLeftHanded() ? -1 : 1)));
            placeholderHandler.registerGlobalPlaceholder(new StaticPlaceholder("tick", () -> String.valueOf(VisorState.TICK_COUNT)));
            placeholderHandler.registerGlobalPlaceholder(new StaticPlaceholder("frame", () -> String.valueOf(VisorState.FRAME_COUNT)));
        }
        this.wasInit = true;
    }

    public void saveOptions() {
        this.applyOptionsTo(this.settings);
        try {
            this.settings.save();
        }
        catch (Exception exception) {
            VisorClientImpl.LOGGER.info("------Failed to save settings data!------");
            LoggerUtils.printError(exception);
        }
    }

    public void loadOptions() {
        this.loadOptionsFrom(this.settings);
    }

    public void updateDefaultOptions() {
        this.defaultSettings = ClientContext.visor.getConfigManager().createConfig(ConfigType.YAML, null);
        this.applyOptionsTo(this.defaultSettings);
    }

    public void applyOptionsTo(@NotNull Config config) {
        try {
            for (Map.Entry<String, VROptionRecord> entry : this.allOptions.entrySet()) {
                String optionKey = entry.getKey();
                VROptionRecord optionRecord = entry.getValue();
                Field field = optionRecord.field();
                Class<?> fieldType = field.getType();
                Object fieldValue = field.get(null);
                try {
                    Object value = this.prepareValueForSave(fieldValue, fieldType);
                    config.set(optionKey, value);
                }
                catch (Exception e) {
                    VisorClientImpl.LOGGER.warn("Failed to save VR option: " + optionKey);
                    LoggerUtils.printError(e);
                }
            }
        }
        catch (Exception ex) {
            VisorClientImpl.LOGGER.warn("Failed to save VR options: ");
            LoggerUtils.printError(ex);
        }
    }

    public void loadOptionsFrom(@NotNull Config config) {
        try {
            for (Map.Entry<String, VROptionRecord> entry : this.allOptions.entrySet()) {
                try {
                    Object value = config.get(entry.getKey());
                    if (value == null) continue;
                    Field field = entry.getValue().field();
                    Class<?> fieldType = field.getType();
                    Object result = Objects.requireNonNull(this.prepareValueForLoad(value, fieldType));
                    field.set(null, result);
                }
                catch (Exception exception) {
                    VisorClientImpl.LOGGER.info("Failed to load VR option: " + entry.getKey());
                    LoggerUtils.printError(exception);
                }
            }
        }
        catch (Exception ex) {
            VisorClientImpl.LOGGER.info("Failed to load VR options!");
            LoggerUtils.printError(ex);
        }
    }

    public void setOptionValue(@NotNull String key, @NotNull Object value) {
        try {
            VROptionRecord optionRecord = this.allOptions.get(key);
            if (optionRecord == null) {
                return;
            }
            VROptionWidgetType optionWidget = this.optionWidgets.get(key);
            optionRecord.field().set(null, value);
            if (optionWidget != null) {
                optionWidget.getBehaviour().onChanged();
            }
            this.saveOptions();
        }
        catch (Exception exception) {
            System.out.println("Failed to set VR option field: " + key);
            LoggerUtils.printError(exception);
        }
    }

    public Object getOptionValue(@NotNull String key) {
        try {
            VROptionRecord optionRecord = this.allOptions.get(key);
            if (optionRecord == null) {
                return null;
            }
            return optionRecord.field().get(null);
        }
        catch (Exception exception) {
            System.out.println("Failed to get VR option field: " + key);
            LoggerUtils.printError(exception);
            return null;
        }
    }

    public void nextOptionValue(@NotNull String key) {
        try {
            Object newValue;
            VROptionRecord optionRecord = this.allOptions.get(key);
            if (optionRecord == null) {
                return;
            }
            Field field = optionRecord.field();
            Class<?> fieldType = field.getType();
            VROptionWidgetType optionWidget = this.optionWidgets.get(key);
            Object object = newValue = optionWidget != null ? optionWidget.getBehaviour().nextValue(field.get(null)) : null;
            if (newValue == null) {
                if (fieldType == Boolean.TYPE) {
                    newValue = (Boolean)field.get(null) == false;
                } else if (fieldType.isEnum()) {
                    ?[] enumConstants = fieldType.getEnumConstants();
                    int currentIndex = ((Enum)field.get(null)).ordinal();
                    newValue = enumConstants[(currentIndex + 1) % enumConstants.length];
                } else {
                    VisorClientImpl.LOGGER.info("Failed to find next VR option value" + optionRecord.key() + " with type " + fieldType.getSimpleName());
                    return;
                }
            }
            this.setOptionValue(key, newValue);
        }
        catch (Exception exception) {
            System.out.println("Failed to find next VR option value: " + key);
            LoggerUtils.printError(exception);
        }
    }

    public void loadDefaultOptionValue(@NotNull String key) {
        try {
            VROptionRecord optionRecord = this.allOptions.get(key);
            if (optionRecord == null) {
                return;
            }
            String optionKey = optionRecord.key();
            Object value = this.defaultSettings.get(optionKey);
            if (value == null) {
                return;
            }
            Field field = optionRecord.field();
            Class<?> fieldType = field.getType();
            Object result = Objects.requireNonNull(this.prepareValueForLoad(value, fieldType));
            field.set(null, result);
        }
        catch (Exception ex) {
            VisorClientImpl.LOGGER.info("Failed to load default VR option: " + key);
            LoggerUtils.printError(ex);
        }
    }

    public String getOptionButtonName(VROptionWidgetType optionWidget) {
        return this.getOptionButtonName(optionWidget, false);
    }

    public String getOptionButtonName(VROptionWidgetType optionWidget, boolean valueOnly) {
        String lang = LangHelper.getText("visor.options." + optionWidget.getKey(), new Object[0]);
        Object text = lang + ": ";
        if (valueOnly) {
            text = "";
        }
        try {
            VROptionRecord optionRecord = this.allOptions.get(optionWidget.getKey());
            if (optionRecord == null) {
                return lang;
            }
            Field field = optionRecord.field();
            Class<?> fieldType = field.getType();
            Object currentValue = field.get(null);
            String optionString = optionWidget.getBehaviour().getDisplayString((String)text, currentValue);
            if (optionString != null) {
                return optionString;
            }
            if (fieldType == Boolean.TYPE) {
                return (Boolean)currentValue != false ? (String)text + LangHelper.getOn() : (String)text + LangHelper.getOff();
            }
            if (fieldType == Float.TYPE || fieldType == Double.TYPE) {
                return (String)text + String.format("%.2f", Float.valueOf(((Number)currentValue).floatValue()));
            }
            if (currentValue instanceof Enum) {
                Enum enumValue = (Enum)currentValue;
                return (String)text + LangHelper.getText(this.getEnumOptionLangKey(enumValue), new Object[0]);
            }
            return (String)text + currentValue.toString();
        }
        catch (Exception exception) {
            System.out.println("Failed to get VR option display string for button: " + String.valueOf((Object)optionWidget));
            LoggerUtils.printError(exception);
            return "ERROR OCCURRED";
        }
    }

    private String getEnumOptionLangKey(Enum<?> type) {
        switch (type.name().toLowerCase()) {
            case "on": {
                return "options.on";
            }
            case "off": {
                return "options.off";
            }
        }
        Class<?> clazz = type.getClass();
        String enumId = (!clazz.isAnonymousClass() ? clazz : clazz.getSuperclass()).getSimpleName();
        String enumName = type.name();
        return "visor.options.enums." + enumId + "." + enumName;
    }

    private void initOptionFields() {
        try {
            for (Field field : VRClientSettings.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                VROptionField annotation = field.getAnnotation(VROptionField.class);
                if (annotation == null) continue;
                Object optionKey = annotation.key().isEmpty() ? field.getName() : annotation.key();
                VROptionCategory category = annotation.category();
                if (category == VROptionCategory.EMPTY) {
                    category = annotation.widgetType().getCategory();
                }
                if (category != VROptionCategory.EMPTY) {
                    optionKey = category.getKey() + "." + (String)optionKey;
                }
                VROptionRecord optionRecord = new VROptionRecord(field, annotation.widgetType(), (String)optionKey);
                if (annotation.widgetType() != VROptionWidgetType.EMPTY) {
                    if (this.optionWidgets.containsValue((Object)annotation.widgetType())) {
                        throw new RuntimeException("duplicate option widget in client settings! field: " + String.valueOf((Object)annotation.widgetType()));
                    }
                    annotation.widgetType().setKey((String)optionKey);
                    this.optionWidgets.put((String)optionKey, annotation.widgetType());
                }
                this.allOptions.put((String)optionKey, optionRecord);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object prepareValueForSave(Object fieldValue, Class<?> fieldType) {
        if (fieldType.isEnum()) {
            return fieldValue.toString();
        }
        if (fieldType.isAssignableFrom(Quaternionf.class) && fieldValue instanceof Quaternionf) {
            Quaternionf value = (Quaternionf)fieldValue;
            return String.format("%s;%s;%s;%s", Float.valueOf(value.x), Float.valueOf(value.y), Float.valueOf(value.z), Float.valueOf(value.w));
        }
        if (fieldType.isAssignableFrom(AtumColor.class) && fieldValue instanceof AtumColor) {
            AtumColor value = (AtumColor)fieldValue;
            return value.getRedInt() + ";" + value.getGreenInt() + ";" + value.getBlueInt() + ";" + value.getAlphaInt();
        }
        return fieldValue;
    }

    private Object prepareValueForLoad(Object configValue, Class<?> fieldType) {
        if (fieldType.isEnum()) {
            Class<Quaternionf> enumType = fieldType;
            return Enum.valueOf(enumType, configValue.toString().toUpperCase());
        }
        if (fieldType.isAssignableFrom(Quaternionf.class)) {
            String[] split = configValue.toString().split(";");
            float w = Float.parseFloat(split[3]);
            float x = Float.parseFloat(split[0]);
            float y = Float.parseFloat(split[1]);
            float z = Float.parseFloat(split[2]);
            return new Quaternionf(x, y, z, w);
        }
        if (fieldType.isAssignableFrom(AtumColor.class)) {
            String[] split = configValue.toString().split(";");
            int red = Integer.parseInt(split[0]);
            int green = Integer.parseInt(split[1]);
            int blue = Integer.parseInt(split[2]);
            int alpha = Integer.parseInt(split[3]);
            if (fieldType.isAssignableFrom(AtumColorMutable.class)) {
                return AtumColor.mutable(red, green, blue, alpha);
            }
            return AtumColor.immutable(red, green, blue, alpha);
        }
        if (fieldType.isAssignableFrom(Byte.class) || fieldType.isAssignableFrom(Byte.TYPE)) {
            return ((Number)configValue).byteValue();
        }
        if (fieldType.isAssignableFrom(Short.class) || fieldType.isAssignableFrom(Short.TYPE)) {
            return ((Number)configValue).shortValue();
        }
        if (fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Integer.TYPE)) {
            return ((Number)configValue).intValue();
        }
        if (fieldType.isAssignableFrom(Long.class) || fieldType.isAssignableFrom(Long.TYPE)) {
            return ((Number)configValue).longValue();
        }
        if (fieldType.isAssignableFrom(Float.class) || fieldType.isAssignableFrom(Float.TYPE)) {
            return Float.valueOf(((Number)configValue).floatValue());
        }
        if (fieldType.isAssignableFrom(Double.class) || fieldType.isAssignableFrom(Double.TYPE)) {
            return ((Number)configValue).doubleValue();
        }
        return configValue;
    }

    public OverlayConfigsManager getOverlayConfigsAccessor() {
        return this.overlayConfigsAccessor;
    }
}

