/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings.options;

import java.util.function.Function;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import me.phoenixra.visor.core.client.settings.options.OptionBehaviour;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4i;

public class OptionBehaviourBuilder {
    private final Function<Vector4i, AbstractWidget> widgetSupplier;
    private Function<Object, Object> onNextValue = old -> null;
    private Runnable onChanged = () -> {};
    private Function<PairRecord<String, Object>, String> onUpdateName = entry -> null;

    public OptionBehaviourBuilder(@NotNull Function<Vector4i, AbstractWidget> widgetSupplier) {
        this.widgetSupplier = widgetSupplier;
    }

    @NotNull
    public OptionBehaviour build() {
        return new OptionBehaviour(){

            @Override
            public Object nextValue(Object old) {
                return OptionBehaviourBuilder.this.onNextValue.apply(old);
            }

            @Override
            public void onChanged() {
                OptionBehaviourBuilder.this.onChanged.run();
            }

            @Override
            public String getDisplayString(String prefix, Object value) {
                return OptionBehaviourBuilder.this.onUpdateName.apply(new PairRecord<String, Object>(prefix, value));
            }

            @Override
            public AbstractWidget getWidget(int x, int y, int width, int height) {
                return OptionBehaviourBuilder.this.widgetSupplier.apply(new Vector4i(x, y, width, height));
            }
        };
    }

    public OptionBehaviourBuilder setOnNextValue(Function<Object, Object> onNextValue) {
        this.onNextValue = onNextValue;
        return this;
    }

    public OptionBehaviourBuilder setOnChanged(Runnable onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public OptionBehaviourBuilder setOnUpdateName(Function<PairRecord<String, Object>, String> onUpdateName) {
        this.onUpdateName = onUpdateName;
        return this;
    }
}

