/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.settings.overlays;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalog;
import me.phoenixra.atumconfig.api.config.catalog.ConfigCatalogListener;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplateRecord;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.gui.registry.VROverlayRegistry;
import me.phoenixra.visor.core.client.gui.registry.VROverlayTemplateRegistry;
import me.phoenixra.visor.core.client.settings.overlays.OverlayConfigsManager;
import org.jetbrains.annotations.NotNull;

public class OverlayCatalogListener
implements ConfigCatalogListener {
    private final OverlayConfigsManager manager;
    private ConfigCatalog catalog;
    private VisorAddon addon;
    private boolean builtIn;

    public OverlayCatalogListener(OverlayConfigsManager manager, boolean builtIn) {
        this.manager = manager;
        this.builtIn = builtIn;
    }

    @Override
    public void onConfigLoaded(@NotNull ConfigFile config) {
        this.manager.addConfig(this.addon, config, this.builtIn);
    }

    @Override
    public void afterReload() {
        if (this.builtIn) {
            this.loadBuiltInOverlaysOptions();
        } else {
            this.initializeCustomOverlays();
        }
    }

    @Override
    public void afterLoadDefaults() {
        Path baseDir = this.catalog.getConfigManager().getDirectory().resolve(this.catalog.getDirectory());
        if (Files.notExists(baseDir, new LinkOption[0])) {
            try {
                Files.createDirectories(baseDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.builtIn) {
            return;
        }
        VROverlayTemplateRegistry templatesRegistry = ClientContext.overlayManager.getOverlayTemplatesRegistry();
        try {
            for (VROverlayTemplateRecord entry : templatesRegistry.getAddonElements(this.addon)) {
                if (!entry.isCreateDefault()) continue;
                entry.constructor().newInstance(entry.owner(), entry.id());
            }
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    @Override
    public void onClear() {
        this.manager.onCatalogCleared(this.catalog);
    }

    private void loadBuiltInOverlaysOptions() {
        VROverlayRegistry overlaysRegistry = ClientContext.overlayManager.getOverlaysRegistry();
        for (ConfigFile config : this.manager.getAddonConfigs(this.addon, this.builtIn)) {
            String id = config.getId();
            VROverlay overlay = overlaysRegistry.getElement(id);
            if (overlay == null) continue;
            overlay.reloadOptions();
        }
    }

    private void initializeCustomOverlays() {
        VROverlayRegistry overlaysRegistry = ClientContext.overlayManager.getOverlaysRegistry();
        VROverlayTemplateRegistry templatesRegistry = ClientContext.overlayManager.getOverlayTemplatesRegistry();
        for (ConfigFile config : this.manager.getAddonConfigs(this.addon, this.builtIn)) {
            String id = config.getId();
            if (overlaysRegistry.getElement(id) != null) {
                LoggerUtils.getLogger().error("The overlay with id {} already exists!", (Object)id);
                continue;
            }
            String templateId = config.getString("template");
            VROverlayTemplateRecord templateRecord = templatesRegistry.getElement(templateId);
            if (templateRecord == null) {
                LoggerUtils.getLogger().error("Unknown overlay template {} specified for {}", (Object)templateId, (Object)id);
                continue;
            }
            try {
                VROverlayTemplate overlay = templateRecord.constructor().newInstance(templateRecord.owner(), id);
                overlaysRegistry.registerElement(overlay);
            }
            catch (Throwable throwable) {
                VisorState.destroyVRWithErrorScreen(throwable);
            }
        }
    }

    public void setCatalog(ConfigCatalog catalog) {
        this.catalog = catalog;
    }

    public void setAddon(VisorAddon addon) {
        this.addon = addon;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }
}

