/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.overlays.builtin.hotbar.HotBarSlice;
import me.phoenixra.visor.core.client.gui.overlays.builtin.hotbar.VROverlayHotBar;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegisterVisorTask
public class TaskHotBar
extends VisorTask {
    private static final String ID = "hotbar";
    private static TaskHotBar instance;
    private boolean inputPressedMain;
    private boolean inputPressedOffhand;
    private boolean pressedMain;
    private boolean pressedOffhand;
    private static HotBarSlice currentStateMain;
    private static HotBarSlice currentStateOffhand;
    private static HotBarSlice previousStateMain;
    private static HotBarSlice previousStateOffhand;
    private static boolean resetData;

    public TaskHotBar(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    public void onRun(@Nullable LocalPlayer player) {
        int slot;
        if (resetData || player.m_150109_().f_35977_ != currentStateMain.getSlot()) {
            currentStateMain = HotBarSlice.fromSlot(player.m_150109_().f_35977_);
            resetData = false;
        }
        VROverlayHotBar hotBarOffhand = (VROverlayHotBar)ClientContext.overlayManager.getOverlay("hotbar_offhand");
        VROverlayHotBar hotBarMainHand = (VROverlayHotBar)ClientContext.overlayManager.getOverlay("hotbar_mainhand");
        if (VisorAPI.client().isFeatureDisabled(ClientFeature.VR_WORLD_HANDS)) {
            hotBarMainHand.setEnabled(false);
            hotBarOffhand.setEnabled(false);
            return;
        }
        if (VisorAPI.client().isFeatureDisabled(ClientFeature.VR_WORLD_HAND_OFFHAND)) {
            hotBarOffhand.setEnabled(false);
        } else {
            if (this.inputPressedOffhand && !this.pressedOffhand) {
                ClientContext.inputManager.triggerHapticPulse(ControllerHand.OFFHAND, 0.002f);
                hotBarOffhand.setEnabled(true);
                this.pressedOffhand = true;
            }
            if (this.pressedOffhand) {
                currentStateOffhand = HotBarSlice.fromSlot(hotBarOffhand.getSelectedSlice());
                slot = currentStateOffhand.getSlot();
                if (slot != -1) {
                    if (previousStateMain != null && slot != previousStateMain.getSlot()) {
                        currentStateMain = previousStateMain;
                        player.m_150109_().f_35977_ = currentStateMain.getSlot();
                        previousStateMain = null;
                    } else if (slot == currentStateMain.getSlot()) {
                        previousStateMain = currentStateMain;
                        player.m_150109_().f_35977_ = slot == 8 ? 0 : slot + 1;
                        currentStateMain = HotBarSlice.fromSlot(player.m_150109_().f_35977_);
                    }
                }
                if (!this.inputPressedOffhand) {
                    ClientContext.inputManager.triggerHapticPulse(ControllerHand.OFFHAND, 0.003f);
                    hotBarOffhand.setEnabled(false);
                    this.pressedOffhand = false;
                    previousStateOffhand = null;
                    previousStateMain = null;
                    if (previousStateOffhand != currentStateOffhand) {
                        // empty if block
                    }
                }
            }
        }
        if (VisorAPI.client().isFeatureDisabled(ClientFeature.VR_WORLD_HAND_MAIN)) {
            hotBarMainHand.setEnabled(false);
        } else {
            if (this.inputPressedMain && !this.pressedMain) {
                ClientContext.inputManager.triggerHapticPulse(ControllerHand.MAIN, 0.002f);
                hotBarMainHand.setEnabled(true);
                this.pressedMain = true;
            }
            if (this.pressedMain) {
                currentStateMain = HotBarSlice.fromSlot(hotBarMainHand.getSelectedSlice());
                slot = currentStateMain.getSlot();
                if (slot != -1) {
                    player.m_150109_().f_35977_ = slot;
                    if (previousStateOffhand != null && slot != previousStateOffhand.getSlot()) {
                        currentStateOffhand = previousStateOffhand;
                        previousStateOffhand = null;
                    } else if (slot == currentStateOffhand.getSlot()) {
                        previousStateOffhand = currentStateOffhand;
                        currentStateOffhand = HotBarSlice.NOT_SELECTED;
                    }
                }
                if (!this.inputPressedMain) {
                    ClientContext.inputManager.triggerHapticPulse(ControllerHand.MAIN, 0.003f);
                    hotBarMainHand.setEnabled(false);
                    this.pressedMain = false;
                    previousStateOffhand = null;
                    previousStateMain = null;
                    if (previousStateOffhand != currentStateOffhand) {
                        // empty if block
                    }
                }
            }
        }
        if (currentStateOffhand.getSlot() == currentStateMain.getSlot()) {
            currentStateOffhand = HotBarSlice.NOT_SELECTED;
        }
    }

    @Override
    protected void onClear(@Nullable LocalPlayer player) {
    }

    @Override
    public boolean isActive(@Nullable LocalPlayer player) {
        if (player == null) {
            return false;
        }
        return VisorClientImpl.MC.f_91080_ == null;
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    public static ItemStack getOffhandItem() {
        if (currentStateOffhand == HotBarSlice.NOT_SELECTED || VisorClientImpl.MC.f_91074_ == null) {
            return ItemStack.f_41583_;
        }
        return VisorClientImpl.MC.f_91074_.m_150109_().m_8020_(currentStateOffhand.getSlot());
    }

    public static ItemStack getHandItem(ControllerHand hand) {
        if (hand == ControllerHand.OFFHAND) {
            return TaskHotBar.getOffhandItem();
        }
        if (currentStateMain == HotBarSlice.NOT_SELECTED || VisorClientImpl.MC.f_91074_ == null) {
            return ItemStack.f_41583_;
        }
        return VisorClientImpl.MC.f_91074_.m_150109_().m_8020_(currentStateMain.getSlot());
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public static TaskHotBar getInstance() {
        return instance;
    }

    public void setInputPressedMain(boolean inputPressedMain) {
        this.inputPressedMain = inputPressedMain;
    }

    public void setInputPressedOffhand(boolean inputPressedOffhand) {
        this.inputPressedOffhand = inputPressedOffhand;
    }

    public static HotBarSlice getCurrentStateMain() {
        return currentStateMain;
    }

    public static HotBarSlice getCurrentStateOffhand() {
        return currentStateOffhand;
    }

    public static void setCurrentStateOffhand(HotBarSlice currentStateOffhand) {
        TaskHotBar.currentStateOffhand = currentStateOffhand;
    }

    public static void setResetData(boolean resetData) {
        TaskHotBar.resetData = resetData;
    }

    static {
        currentStateMain = HotBarSlice.CENTER;
        currentStateOffhand = HotBarSlice.NOT_SELECTED;
        previousStateMain = null;
        previousStateOffhand = null;
        resetData = true;
    }
}

