/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks;

import java.util.EnumMap;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.input.actionset.actions.ActionRightMouse;
import net.minecraft.Util;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomConsume
extends VisorTask {
    private static final String ID = "room_consume";
    private static TaskRoomConsume instance;
    private static final int DURATION = 2100;
    private static final float MOUTH_DISTANCE = 0.25f;
    private static final float HAPTIC_PULSE_DURATION = 0.007f;
    private static final int HAPTIC_DELAY_EAT_DRINK = 2;
    private static final int HAPTIC_DELAY_TOOT_HORN = 1;
    private final EnumMap<ControllerHand, Boolean> consuming = new EnumMap(ControllerHand.class);
    private final EnumMap<ControllerHand, Long> eatStartMap = new EnumMap(ControllerHand.class);
    private boolean eatingPressed;

    public TaskRoomConsume(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(LocalPlayer player) {
        boolean isEating;
        PoseDataImpl roomPose = ClientContext.player.getPoseData(PoseDataType.ROOM);
        Vector3fc hmdPos = roomPose.getHmd().getPosition();
        Vector3f mouthPos = roomPose.getController(ControllerHand.MAIN).getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f)).add(hmdPos);
        for (ControllerHand hand : ControllerHand.values()) {
            long ticksLeft;
            boolean usedItem;
            int hapticDelay;
            ItemStack foodItem;
            Vector3fc handPos = this.calculateHandPosition(roomPose, hand);
            if (mouthPos.distance(handPos) >= 0.25f) {
                this.consuming.put(hand, false);
                continue;
            }
            InteractionHand interactHand = hand == ControllerHand.MAIN ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack itemStack = foodItem = hand == ControllerHand.MAIN ? player.m_21205_() : player.m_21206_();
            if (!this.isConsumable(foodItem)) continue;
            switch (foodItem.m_41780_()) {
                case EAT: 
                case DRINK: {
                    int n = 2;
                    break;
                }
                case TOOT_HORN: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = hapticDelay = -1;
                }
            }
            if (hapticDelay == -1) continue;
            if (!this.consuming.getOrDefault((Object)hand, false).booleanValue() && (usedItem = VisorClientImpl.MC.f_91072_.m_233721_((Player)player, interactHand).m_19077_())) {
                VisorClientImpl.MC.f_91063_.f_109055_.m_109320_(interactHand);
                this.consuming.put(hand, true);
                this.eatStartMap.put(hand, Util.m_137550_());
            }
            if (this.consuming.getOrDefault((Object)hand, false).booleanValue() && (ticksLeft = (long)player.m_21212_()) > 0L && ticksLeft % 5L <= (long)hapticDelay) {
                ClientContext.inputManager.triggerHapticPulse(hand, 0.007f);
            }
            if (Util.m_137550_() - this.eatStartMap.getOrDefault((Object)hand, 0L) <= 2100L) continue;
            this.consuming.put(hand, false);
        }
        boolean bl = isEating = this.consuming.getOrDefault((Object)ControllerHand.MAIN, false) != false || this.consuming.getOrDefault((Object)ControllerHand.OFFHAND, false) != false;
        if (isEating) {
            ActionRightMouse actionRightMouse = (ActionRightMouse)ClientContext.inputManager.getActiveSet().getAction("mouse_right");
            actionRightMouse.forcePress();
            this.eatingPressed = true;
        } else if (this.eatingPressed) {
            ActionRightMouse actionRightMouse = (ActionRightMouse)ClientContext.inputManager.getActiveSet().getAction("mouse_right");
            actionRightMouse.forceRelease();
            this.eatingPressed = false;
        }
    }

    @Override
    protected void onClear(LocalPlayer player) {
        this.consuming.clear();
        this.eatStartMap.clear();
    }

    @Override
    public boolean isActive(@Nullable LocalPlayer player) {
        if (VisorClientImpl.MC.f_91072_ == null || player == null || !player.m_6084_() || player.m_5803_() || player.m_5833_()) {
            return false;
        }
        return this.isConsumable(player.m_21205_()) || this.isConsumable(player.m_21206_());
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private Vector3fc calculateHandPosition(PoseDataImpl roomPose, ControllerHand hand) {
        Vector3f basePos = ClientContext.rawPoseHandler.getControllerData(hand).getPositionHistory().averagePosition(0.333f);
        Vector3f customOffset = roomPose.getController(hand).getCustomVector((Vector3fc)new Vector3f(0.0f, 0.0f, -0.1f));
        Vector3f directionOffset = roomPose.getController(hand).getDirection().mul(0.1f, new Vector3f());
        return basePos.add((Vector3fc)customOffset, new Vector3f()).add((Vector3fc)directionOffset);
    }

    private boolean isConsumable(ItemStack item) {
        if (item == ItemStack.f_41583_) {
            return false;
        }
        UseAnim useAnim = item.m_41780_();
        return useAnim == UseAnim.EAT || useAnim == UseAnim.DRINK || useAnim == UseAnim.TOOT_HORN;
    }

    public static TaskRoomConsume getInstance() {
        return instance;
    }
}

